/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.concurrent.PriorityExecutor;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.SPXOutputStream;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TileEncoderResult;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.CompressorLZW;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.TileCompression;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.imagereader.image.FSIImage;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public final class TileEncoder
implements Callable<TileEncoderResult>,
PriorityExecutor.Important {
    private final FSILogger logger;
    private final int priority;
    private final FSIImage rgbImage;
    private final ByteOrder byteOrder;
    private final int width;
    private final int height;
    private final int startX;
    private final int startY;
    private final int tileX;
    private final int tileY;
    private final int TILESIZE;
    private final TileCompression tileFormat;
    private final JPEGPreparation jpegPreparation;
    private final CompressionMode compression = CompressionMode.DEFLATE;
    private static final int compressionLevel = 4;
    private final FilterMode filter = FilterMode.NONE;

    public TileEncoder(FSILogger logger, int priority, FSIImage rgbImage, ByteOrder byteOrder, int startX, int startY, int zoomlevel, int tileX, int tileY, int TILESIZE, TileCompression tileFormat, JPEGPreparation jpegPreparation) {
        this.logger = logger;
        this.priority = priority;
        this.rgbImage = rgbImage.createSlice();
        this.byteOrder = byteOrder;
        this.startX = startX;
        this.startY = startY;
        this.tileX = tileX;
        this.tileY = tileY;
        this.width = rgbImage.getWidth();
        this.height = rgbImage.getHeight();
        this.TILESIZE = TILESIZE;
        this.tileFormat = tileFormat;
        this.jpegPreparation = jpegPreparation;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public TileEncoderResult call() {
        TileEncoderResult result = new TileEncoderResult();
        if (this.rgbImage.isDisposed()) {
            result.success = false;
        } else {
            long compressionTime = 0L;
            result.tileX = this.tileX;
            result.tileY = this.tileY;
            short tileWidth = (short)(this.width - this.startX < this.TILESIZE ? this.width - this.startX : this.TILESIZE);
            short tileHeight = (short)(this.height - this.startY < this.TILESIZE ? this.height - this.startY : this.TILESIZE);
            boolean success = false;
            try {
                long startCompression = System.currentTimeMillis();
                byte[][] compressionResult = this.compressData(tileWidth, tileHeight);
                byte[] data = compressionResult[0];
                byte[] alphadata = compressionResult[1];
                compressionTime = System.currentTimeMillis() - startCompression;
                try (ByteArrayOutputStreamFast baosf = new ByteArrayOutputStreamFast();
                     SPXOutputStream sow = new SPXOutputStream(this.byteOrder, baosf);){
                    sow.writeTagShort((short)14, tileWidth);
                    sow.writeTagShort((short)15, tileHeight);
                    if (this.tileFormat == TileCompression.LOSSLESS) {
                        switch (this.filter) {
                            case SUB: {
                                sow.writeTagByte((short)103, (byte)1);
                                break;
                            }
                            case UP: {
                                sow.writeTagByte((short)103, (byte)2);
                                break;
                            }
                            case AVG: {
                                sow.writeTagByte((short)103, (byte)3);
                                break;
                            }
                            case PAETH: {
                                sow.writeTagByte((short)103, (byte)4);
                                break;
                            }
                            default: {
                                sow.writeTagByte((short)103, (byte)0);
                            }
                        }
                        switch (this.compression) {
                            case DEFLATE: {
                                sow.writeTagByte((short)102, (byte)2);
                                break;
                            }
                            case LZW: {
                                sow.writeTagByte((short)102, (byte)1);
                                break;
                            }
                            default: {
                                sow.writeTagByte((short)102, (byte)0);
                                break;
                            }
                        }
                    } else if (this.tileFormat == TileCompression.JPEG && this.rgbImage.hasAlpha() && alphadata != null) {
                        sow.writeTagBytes((short)201, alphadata);
                    }
                    sow.writeTagByte((short)101, (byte)this.tileFormat.ordinal());
                    if (data != null) {
                        sow.writeTagBytes((short)200, data);
                    }
                    if (this.rgbImage.getExtraAlphaCount() > 0) {
                        sow.writeTagInt((short)300, this.rgbImage.getExtraAlphaCount());
                        byte[] extraAlphaData = new byte[tileWidth * tileHeight];
                        for (int b = 0; b < this.rgbImage.getExtraAlphaCount(); ++b) {
                            this.rgbImage.getSampleExtraAlphaRange(b, this.startX, this.startY, this.startX + tileWidth - 1, this.startY + tileHeight - 1, extraAlphaData);
                            byte[] compressedEAD = this.compressDeflate(extraAlphaData);
                            sow.writeTagBytes((short)301, compressedEAD);
                        }
                    }
                    sow.close();
                    result.tiledata = baosf.toByteArray();
                    success = true;
                }
            }
            catch (IOException e) {
                this.logger.log(3175, "TileEncoder", e.getLocalizedMessage());
            }
            result.success = success;
            result.compressiontime = compressionTime;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] compressData(int tileWidth, int tileHeight) throws IOException {
        byte[][] result = new byte[2][];
        byte[] data = null;
        byte[] alphadata = null;
        if (this.tileFormat == TileCompression.LOSSLESS) {
            byte[] argbData = new byte[tileWidth * tileHeight * 4];
            this.rgbImage.getSampleRangeBytes(this.startX, this.startY, this.startX + tileWidth - 1, this.startY + tileHeight - 1, argbData);
            switch (this.filter) {
                case SUB: {
                    this.filterSub4(argbData, tileWidth);
                    break;
                }
                case UP: {
                    this.filterUp4(argbData, tileWidth);
                    break;
                }
            }
            switch (this.compression) {
                case DEFLATE: {
                    data = this.compressDeflate(argbData);
                    break;
                }
                case LZW: {
                    data = this.compressLZW(argbData);
                    break;
                }
            }
        } else if (this.tileFormat == TileCompression.JPEG) {
            int[] argbData = new int[tileWidth * tileHeight];
            this.rgbImage.getSampleRange(this.startX, this.startY, this.startX + tileWidth - 1, this.startY + tileHeight - 1, argbData);
            if (this.rgbImage.hasAlpha()) {
                alphadata = new byte[argbData.length];
                for (int p = 0; p < argbData.length; ++p) {
                    alphadata[p] = (byte)(argbData[p] >>> 24);
                }
                alphadata = this.compressDeflate(alphadata);
            }
            BufferedImage pbOut = new BufferedImage(tileWidth, tileHeight, 1);
            try {
                WritableRaster wr = pbOut.getRaster();
                wr.setDataElements(0, 0, tileWidth, tileHeight, argbData);
                data = this.packJPEG(pbOut);
            }
            finally {
                pbOut.flush();
            }
        }
        result[0] = data;
        result[1] = alphadata;
        return result;
    }

    /*
     * Exception decompiling
     */
    private byte[] compressDeflate(byte[] data) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private byte[] compressLZW(byte[] data) {
        CompressorLZW lzw = new CompressorLZW();
        return lzw.pack(data);
    }

    private void filterUp4(byte[] data, int tWidth) {
        int len = data.length;
        int width4 = tWidth * 4;
        int rows = len / width4;
        for (int r = rows - 1; r > 0; --r) {
            int prior = (r - 1) * width4;
            int pos = r * width4;
            int c = 0;
            while (c < width4) {
                int n = pos;
                data[n] = (byte)(data[n] - data[prior]);
                int n2 = pos + 1;
                data[n2] = (byte)(data[n2] - data[prior + 1]);
                int n3 = pos + 2;
                data[n3] = (byte)(data[n3] - data[prior + 2]);
                int n4 = pos + 3;
                data[n4] = (byte)(data[n4] - data[prior + 3]);
                pos += 4;
                c += 4;
                prior += 4;
            }
        }
    }

    private void filterSub4(byte[] data, int tWidth) {
        int len = data.length;
        int width4 = tWidth * 4;
        int rows = len / width4;
        for (int r = 0; r < rows; ++r) {
            int pos = r * width4 + width4 - 1;
            for (int c = width4 - 1; c >= 4; c -= 4) {
                int n = pos;
                data[n] = (byte)(data[n] - data[pos - 4]);
                int n2 = pos - 1;
                data[n2] = (byte)(data[n2] - data[pos - 5]);
                int n3 = pos - 2;
                data[n3] = (byte)(data[n3] - data[pos - 6]);
                int n4 = pos - 3;
                data[n4] = (byte)(data[n4] - data[pos - 7]);
                pos -= 4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private byte[] packJPEG(BufferedImage bi) {
        block32: {
            Iterator<ImageWriter> iwit = ImageIO.getImageWritersByFormatName("jpeg");
            if (!iwit.hasNext()) break block32;
            ImageWriter writer = iwit.next();
            IIOImage tImage = new IIOImage(bi, null, this.jpegPreparation.getMetadata());
            try {
                byte[] byArray;
                Throwable throwable;
                ByteArrayOutputStreamFast baos;
                block30: {
                    block31: {
                        baos = new ByteArrayOutputStreamFast(2048);
                        throwable = null;
                        try (MemoryCacheImageOutputStream mos = new MemoryCacheImageOutputStream(baos);){
                            writer.setOutput(mos);
                            writer.write(this.jpegPreparation.getMetadata(), tImage, this.jpegPreparation.getJPEGParam());
                        }
                        byArray = baos.toByteArray();
                        if (baos == null) break block30;
                        if (throwable == null) break block31;
                        try {
                            baos.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        break block30;
                    }
                    baos.close();
                }
                return byArray;
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (baos != null) {
                                if (throwable != null) {
                                    try {
                                        baos.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    baos.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (IOException e) {
                        this.logger.logException(e, 9001, "TileEncoder.packJPEG: " + e.getLocalizedMessage());
                    }
                }
            }
            finally {
                writer.dispose();
            }
        }
        return null;
    }

    private static enum FilterMode {
        NONE,
        UP,
        SUB,
        AVG,
        PAETH;

    }

    private static enum CompressionMode {
        NONE,
        DEFLATE,
        LZW;

    }
}

