/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TrashList {
    private static final Map<Path, TrashList> instances = new HashMap<Path, TrashList>();
    private final Path listFile;
    private long fileTimestamp = -1L;
    private Set<TrashListEntry> list;

    private TrashList(Path listFile) {
        this.listFile = listFile;
    }

    public Set<TrashListEntry> getList() {
        this.readFromFile();
        HashSet<TrashListEntry> result = new HashSet<TrashListEntry>();
        result.addAll(this.list);
        return result;
    }

    public static synchronized TrashList getInstance(Path listFile) {
        if (listFile == null) {
            throw new IllegalArgumentException("Can't create TrashList without file.");
        }
        if (instances.containsKey(listFile)) {
            return instances.get(listFile);
        }
        TrashList tl = new TrashList(listFile);
        instances.put(listFile, tl);
        return tl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addEntry(TrashListEntry entry) {
        Path path = this.listFile;
        synchronized (path) {
            this.readFromFile();
            this.list.add(entry);
            return this.writeToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeEntry(String entryid) {
        Path path = this.listFile;
        synchronized (path) {
            this.readFromFile();
            TrashListEntry entryToRemove = null;
            for (TrashListEntry tle : this.list) {
                if (!tle.trashID.equals(entryid)) continue;
                entryToRemove = tle;
                break;
            }
            if (entryToRemove != null) {
                this.list.remove(entryToRemove);
            }
            return this.writeToFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TrashListEntry getEntryByHash(String entryid) {
        Path path = this.listFile;
        synchronized (path) {
            this.readFromFile();
            TrashListEntry foundEntry = null;
            for (TrashListEntry tle : this.list) {
                if (!tle.trashID.equals(entryid)) continue;
                foundEntry = tle;
                break;
            }
            return foundEntry;
        }
    }

    private void readFromFile() {
        try {
            long listLM = Files.getLastModifiedTime(this.listFile, new LinkOption[0]).toMillis();
            if (this.list == null || listLM != this.fileTimestamp) {
                this.list = (Set)FileOperations.readObjectFromFile(this.listFile);
                this.fileTimestamp = listLM;
            }
        }
        catch (Exception e) {
            this.list = new HashSet<TrashListEntry>();
        }
    }

    private boolean writeToFile() {
        try {
            FileOperations.writeObjectToFile(this.listFile, this.list);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

