/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.V1002;

import com.neptunelabs.fsiframework.comparator.FSIStringComparator;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.TrashListEntry;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import java.util.Comparator;

public class TrashListEntryComparator
implements Comparator<TrashListEntry> {
    private final SupportedSortField sortfield;
    private final SortDirection direction;
    private final FSIStringComparator stringComparator;

    public TrashListEntryComparator(String sortfield, FSIStringComparator stringComparator, SortDirection sortDirection) {
        this.stringComparator = stringComparator;
        this.direction = sortDirection;
        this.sortfield = this.evaluateSortField(sortfield);
    }

    private SupportedSortField evaluateSortField(String sortfieldValue) {
        try {
            if (sortfieldValue != null) {
                return SupportedSortField.valueOf(sortfieldValue.toUpperCase());
            }
            return SupportedSortField.NO_SORTING;
        }
        catch (IllegalArgumentException e) {
            return SupportedSortField.NO_SORTING;
        }
    }

    @Override
    public int compare(TrashListEntry o1, TrashListEntry o2) {
        int result;
        switch (this.sortfield) {
            case FILENAME: {
                result = this.compareByFilename(o1, o2, true);
                break;
            }
            case DELETEPATH: {
                result = this.compareByPath(o1, o2, true);
                break;
            }
            case LASTMODIFIED: {
                result = this.compareLongs(o1.originalLMDate, o2.originalLMDate);
                break;
            }
            case DELETEDATE: {
                result = this.compareLongs(o1.deletedDate, o2.deletedDate);
                break;
            }
            case FILESIZE: {
                result = this.compareLongs(o1.sourceFileSize, o2.sourceFileSize);
                break;
            }
            default: {
                result = 0;
            }
        }
        if (result == 0 && this.sortfield != SupportedSortField.FILENAME) {
            result = this.compareByFilename(o1, o2, false);
        }
        if (this.direction == SortDirection.DESC && this.sortfield != SupportedSortField.FILENAME && this.sortfield != SupportedSortField.DELETEPATH) {
            result = -result;
        }
        return result;
    }

    private int compareLongs(long l1, long l2) {
        return l1 < l2 ? -1 : (l1 == l2 ? 0 : 1);
    }

    private int compareByFilename(TrashListEntry o1, TrashListEntry o2, boolean allowFallback) {
        int result = this.stringComparator.compare(o1.originalFilename, o2.originalFilename);
        if (allowFallback && result == 0) {
            this.compareByPath(o1, o2, false);
        }
        return result;
    }

    private int compareByPath(TrashListEntry o1, TrashListEntry o2, boolean allowFallback) {
        int result = this.stringComparator.compare(o1.originalDir, o2.originalDir);
        if (allowFallback && result == 0) {
            this.compareByFilename(o1, o2, false);
        }
        return result;
    }

    private static enum SupportedSortField {
        NO_SORTING,
        FILENAME,
        DELETEPATH,
        LASTMODIFIED,
        DELETEDATE,
        FILESIZE;

    }
}

