/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.utils;

import java.io.IOException;
import javax.imageio.stream.MemoryCacheImageOutputStream;

final class LZWBitFile {
    private final MemoryCacheImageOutputStream output_;
    private final byte[] buffer_;
    private int index_;
    private int bitsLeft_;

    public LZWBitFile(MemoryCacheImageOutputStream output) {
        this.output_ = output;
        this.buffer_ = new byte[256];
        this.index_ = 0;
        this.bitsLeft_ = 8;
    }

    public void flush() throws IOException {
        int numBytes = this.index_ + (this.bitsLeft_ == 8 ? 0 : 1);
        if (numBytes > 0) {
            this.output_.write(this.buffer_, 0, numBytes);
            this.buffer_[0] = 0;
            this.index_ = 0;
            this.bitsLeft_ = 8;
        }
    }

    public void writeBits(int bits, int numbits) throws IOException {
        int numBytes = 255;
        do {
            if (this.index_ == 254 && this.bitsLeft_ == 0 || this.index_ > 254) {
                this.output_.write(this.buffer_, 0, 255);
                this.buffer_[0] = 0;
                this.index_ = 0;
                this.bitsLeft_ = 8;
            }
            if (numbits <= this.bitsLeft_) {
                int n = this.index_;
                this.buffer_[n] = (byte)(this.buffer_[n] | (bits & (1 << numbits) - 1) << this.bitsLeft_ - numbits);
                this.bitsLeft_ -= numbits;
                numbits = 0;
                continue;
            }
            int topbits = bits >>> numbits - this.bitsLeft_ & (1 << this.bitsLeft_) - 1;
            int n = this.index_++;
            this.buffer_[n] = (byte)(this.buffer_[n] | topbits);
            numbits -= this.bitsLeft_;
            this.buffer_[this.index_] = 0;
            this.bitsLeft_ = 8;
        } while (numbits != 0);
    }
}

