/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.sourcemanager.storage.utils;

final class LZWStringTable {
    private static final int RES_CODES = 2;
    private static final short HASH_FREE = -1;
    private static final short NEXT_FIRST = -1;
    private static final int MAXBITS = 12;
    private static final int MAXSTR = 4096;
    private static final short HASHSIZE = 9973;
    private static final short HASHSTEP = 2039;
    private final byte[] strChr_ = new byte[4096];
    private final short[] strNxt_ = new short[4096];
    private final short[] strHsh_;
    private short numStrings_;
    private final int[] strLen_ = new int[4096];

    public LZWStringTable() {
        this.strHsh_ = new short[9973];
    }

    int addCharString(short index, byte b) {
        if (this.numStrings_ >= 4096) {
            return 65535;
        }
        int hshidx = this.hash(index, b);
        while (this.strHsh_[hshidx] != -1) {
            hshidx = (hshidx + 2039) % 9973;
        }
        this.strHsh_[hshidx] = this.numStrings_;
        this.strChr_[this.numStrings_] = b;
        if (index == -1) {
            this.strNxt_[this.numStrings_] = -1;
            this.strLen_[this.numStrings_] = 1;
        } else {
            this.strNxt_[this.numStrings_] = index;
            this.strLen_[this.numStrings_] = this.strLen_[index] + 1;
        }
        short s = this.numStrings_;
        this.numStrings_ = (short)(s + 1);
        return s;
    }

    short findCharString(short index, byte b) {
        short nxtidx;
        if (index == -1) {
            return (short)(b & 0xFF);
        }
        int hshidx = this.hash(index, b);
        while ((nxtidx = this.strHsh_[hshidx]) != -1) {
            if (this.strNxt_[nxtidx] == index && this.strChr_[nxtidx] == b) {
                return nxtidx;
            }
            hshidx = (hshidx + 2039) % 9973;
        }
        return -1;
    }

    void clearTable(int codesize) {
        this.numStrings_ = 0;
        for (int q = 0; q < 9973; ++q) {
            this.strHsh_[q] = -1;
        }
        int w = (1 << codesize) + 2;
        for (int q = 0; q < w; ++q) {
            this.addCharString((short)-1, (byte)q);
        }
    }

    private int hash(short index, byte lastbyte) {
        return (((short)(lastbyte << 8) ^ index) & 0xFFFF) % 9973;
    }
}

