/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.security.BytesToAscii64;
import com.neptunelabs.fsiframework.security.CityHash;
import java.util.Iterator;
import java.util.Map;

public final class ETag {
    private final StringBuilder tagHash = new StringBuilder();
    private boolean modified = true;
    private String fixedETag = null;
    private String eTag = null;

    public void addModifier(String modifier) {
        this.tagHash.append(modifier);
        this.modified = true;
    }

    public boolean hasModifier() {
        return this.eTag != null || this.fixedETag != null || this.tagHash.length() > 0;
    }

    public String getStrongTag(long assetURLHash, long queryHash) {
        if (this.fixedETag != null) {
            return this.fixedETag;
        }
        if (this.modified) {
            this.modified = false;
            if (this.eTag == null) {
                byte[] dataMod = this.tagHash.toString().getBytes(FileOperations.charsetUTF8);
                long longMod = queryHash ^ CityHash.cityHash64(dataMod, 0, dataMod.length);
                this.eTag = '\"' + BytesToAscii64.encode(ETag.longToByteArray(assetURLHash)) + '-' + BytesToAscii64.encode(ETag.longToByteArray(longMod)) + '\"';
            }
            this.modified = false;
            return this.eTag;
        }
        if (this.eTag != null) {
            return this.eTag;
        }
        return null;
    }

    public void setStrongETag(String eTag) {
        this.fixedETag = eTag;
        this.modified = false;
    }

    public static int hashCodeMap(Map<?, ?> map) {
        int h = 0;
        Iterator<Map.Entry<?, ?>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            h = 31 * h + ((Object)i.next()).hashCode();
        }
        return h;
    }

    private static byte[] longToByteArray(long value) {
        long v = value;
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(v & 0xFFL);
            v >>= 8;
        }
        return result;
    }
}

