/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.helpers.ExecutorPool;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.requestprocessor.renderers.RendererEnvironment;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FileLockHandler;
import com.neptunelabs.fsiserver.utils.LicenceExpireTimerTask;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import com.neptunelabs.fsiservletframework.jmx.MBeanUtils;
import com.neptunelabs.fsiservletframework.settings.ServletXMLSettings;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import com.neptunelabs.imageio.MimeTypesLoader;
import com.neptunelabs.imagereader.ImageFormatScanner;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.ObjectName;
import javax.servlet.GenericServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpSession;

public abstract class FSIServerSettings
extends ServletXMLSettings {
    public static final String STATIC_PREFIX = "static";
    private ByteOrder byteOrder;
    private Comparator<String> defaultStringComparator = null;
    private final Path configHome;
    protected PluginLoader pluginLoader = null;
    private ExecutorPool executorPool;
    private IOController ioController;
    protected SystemMonitor systemMonitor = null;
    private RendererEnvironment environment;
    protected StorageHelperV1002 storageHelper;
    private boolean licenceIsExpired = false;
    private Timer licenceExpireTimer;
    private LicenceExpireTimerTask licenceExpireTimerTask = null;
    protected final Map<String, SourceConnectorReader> sourceConnectors = new HashMap<String, SourceConnectorReader>();
    private Path storageLocation = null;
    private String storageLocationPath = null;
    protected CacheManager cacheManager;
    protected boolean serverUsesOwnCacheManager = false;
    protected Map<String, String> mimeTypes = null;
    protected Set<ObjectName> mbeans = new HashSet<ObjectName>();

    public FSIServerSettings(HttpServlet servlet, boolean autorestart, ServletFileEventCursor fileEventCursor, boolean export, boolean startExpireTask) {
        super((GenericServlet)servlet, autorestart, fileEventCursor, export);
        this.configHome = this.servletConfig != null ? (Path)this.servletConfig.getServletContext().getAttribute("com.neptunelabs.fsiserver.config.home") : null;
        if (startExpireTask) {
            this.licenceExpireTimer = new Timer("FSI Settings Task", true);
            this.licenceExpireTimerTask = new LicenceExpireTimerTask(this, 60000L);
            this.licenceExpireTimer.scheduleAtFixedRate((TimerTask)this.licenceExpireTimerTask, 0L, 60000L);
        }
    }

    public abstract FileLockHandler getFileLockHandler();

    public abstract CacheManager getCacheManager();

    public Path getStorageLocation() {
        if (this.storageLocation == null) {
            String storage = this.getPrefsString("application", "storage");
            Path tmp = Paths.get(storage, new String[0]);
            if (!tmp.isAbsolute()) {
                tmp = this.getWebInfPath().resolve(storage);
            }
            this.storageLocation = tmp.toAbsolutePath();
        }
        return this.storageLocation;
    }

    public String getStorageLocationPath() {
        if (this.storageLocation != null && this.storageLocationPath == null) {
            this.storageLocationPath = this.storageLocation.toAbsolutePath().toString();
        }
        return this.storageLocationPath;
    }

    public Comparator<String> getDefaultStringComparator() {
        if (this.defaultStringComparator == null) {
            Locale locale = null;
            String collatorStr = this.getPrefsString("limits", "sortcollator");
            if (collatorStr.equalsIgnoreCase("auto")) {
                locale = Locale.getDefault();
            } else if (!collatorStr.equalsIgnoreCase("none")) {
                locale = new Locale(collatorStr);
            }
            this.environment = RendererEnvironment.getInstance(locale);
            this.defaultStringComparator = this.environment.selectStringComparator(RendererEnvironment.DEFAULT_SORT_METHOD, this.environment.getDefaultSortLanguage(), this.environment.getDefaultSortCountry(), false, RendererEnvironment.DEFAULT_SORT_ORDER == SortDirection.ASC);
        }
        return this.defaultStringComparator;
    }

    public Path getMetaDataLocation() {
        return this.getStorageLocation().resolve("metadata");
    }

    public Path getConfigHome() {
        return this.configHome;
    }

    public void setupStorageHelper(StorageHelperV1002.Hasher hasher, Path storageLocation) {
        this.storageHelper = new StorageHelperV1002(hasher, storageLocation);
    }

    public StorageHelperV1002 getStorageHelper() {
        return this.storageHelper;
    }

    public void evaluateStorageID() throws IOException {
        this.storageHelper.evaluateStorageID();
    }

    public String getStorageID() {
        return this.storageHelper.getStorageID();
    }

    public String getStorageKey() {
        return this.storageHelper.getStorageKey();
    }

    public void setPluginLoader(PluginLoader pluginLoader) {
        this.pluginLoader = pluginLoader;
    }

    public PluginLoader getPluginLoader() {
        return this.pluginLoader;
    }

    public SourceConnectorReader getSourceConnectorFromAssetURLPath(String assetURLPath) {
        return this.sourceConnectors.get(this.getSourceConnectorNameFromAssetURLPath(assetURLPath));
    }

    public Path getTempDirectory() {
        return ServletUtils.getRealPath(this.servletContext, "WEB-INF").resolve("internal").resolve("temp");
    }

    public void setExecutorPool(ExecutorPool executorPool) {
        this.executorPool = executorPool;
    }

    public ExecutorPool getExecutorPool() {
        return this.executorPool;
    }

    public void setIOController(IOController ioController) {
        this.ioController = ioController;
    }

    public IOController getIOController() {
        return this.ioController;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.licenceExpireTimer != null) {
            this.licenceExpireTimer.cancel();
        }
    }

    public int getSourceConnectorCount() {
        int count = 0;
        for (Map.Entry<String, SourceConnectorReader> entry : this.sourceConnectors.entrySet()) {
            String name = entry.getKey();
            boolean found = false;
            for (String uncountedConnector : Defines.UNCOUNTED_CONNECTORS) {
                if (!name.equals(uncountedConnector)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++count;
        }
        return count;
    }

    public SourceConnectorReader getSourceConnectorFromAssetURLPath(String assetURLPath, String username) throws NotConfiguredException {
        String connectorName = this.getSourceConnectorNameFromAssetURLPath(assetURLPath);
        if (connectorName.equals("_configs")) {
            if (username != null) {
                return this.generateConfigsConnector(username);
            }
            return null;
        }
        if (connectorName.equals("_viewers")) {
            if (username != null) {
                return this.generateViewerConnector(username);
            }
            return null;
        }
        return this.sourceConnectors.get(connectorName);
    }

    public SourceConnectorReader getSourceConnectorFromAssetURLPath(String assetURLPath, HttpSession session) throws NotConfiguredException {
        String username = null;
        if (session != null) {
            try {
                username = this.getUserAuthenticationInterface().getUser((String)session.getAttribute("id"));
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return this.getSourceConnectorFromAssetURLPath(assetURLPath, username);
    }

    public SystemMonitor getSystemMonitor() {
        return this.systemMonitor;
    }

    public void setSystemMonitor(SystemMonitor monitor) {
        this.systemMonitor = monitor;
    }

    private String getSourceConnectorNameFromAssetURLPath(String assetURLPath) {
        if (assetURLPath == null) {
            return null;
        }
        while (assetURLPath.startsWith("/")) {
            assetURLPath = assetURLPath.substring(1);
        }
        int firstSlash = assetURLPath.indexOf(47);
        if (firstSlash == -1) {
            return assetURLPath;
        }
        return assetURLPath.substring(0, firstSlash);
    }

    public RendererEnvironment getRenderEnvironment() {
        return this.environment;
    }

    public abstract UserAuthenticationInterface getUserAuthenticationInterface() throws NotConfiguredException;

    private SourceConnectorReader generateConfigsConnector(String username) throws NotConfiguredException {
        SourceConnectorReader configsConnector = null;
        if (username != null) {
            PermissionSet ps = new PermissionSet();
            ps.setFullReadPermissionsEnabled(true);
            ps.setFullWritePermissionsEnabled(true);
            configsConnector = new SourceConnectorReader(this.logger, "_configs", username, null, this.getUserAuthenticationInterface(), ps);
        }
        return configsConnector;
    }

    private SourceConnectorReader generateViewerConnector(String username) throws NotConfiguredException {
        SourceConnectorReader viewerConnector = null;
        if (username != null) {
            PermissionSet ps = new PermissionSet();
            ps.setFullReadPermissionsEnabled(true);
            ps.setFullWritePermissionsEnabled(true);
            viewerConnector = new SourceConnectorReader(this.logger, "_viewers", username, null, this.getUserAuthenticationInterface(), ps);
        }
        return viewerConnector;
    }

    public ByteOrder getByteOrder() {
        if (this.byteOrder == null) {
            String order = this.getPrefsString("application", "byteorder");
            this.byteOrder = order.equalsIgnoreCase("big_endian") || order.equalsIgnoreCase("bigendian") || order.equalsIgnoreCase("be") ? ByteOrder.BIG_ENDIAN : (order.equalsIgnoreCase("little_endian") || order.equalsIgnoreCase("littleendian") || order.equalsIgnoreCase("le") ? ByteOrder.LITTLE_ENDIAN : ByteOrder.nativeOrder());
        }
        return this.byteOrder;
    }

    public long evaluateMaxBlockCache(String ramstr) {
        long ramWish;
        long reserve = 0xA0000000L;
        long space256m = 0x10000000L;
        MemoryManager mm = MemoryManager.getInstance();
        long maxAvailable = mm.getMaxOldGen() - 0xA0000000L;
        long result = Math.min(maxAvailable, ramWish = ramstr == null || ramstr.equalsIgnoreCase("auto") ? maxAvailable : this.getHumanRAMBytes(ramstr));
        if (result < 0x10000000L) {
            result = 0x10000000L;
        }
        return result;
    }

    @Override
    public void updateLicenceFromLicenceManager() {
        super.updateLicenceFromLicenceManager();
        if (this.systemMonitor != null) {
            this.systemMonitor.setLicence(this.getLicence());
        }
        if (this.licenceExpireTimerTask != null) {
            this.licenceExpireTimerTask.resetRuntimeCounter();
            this.licenceExpireTimerTask.run();
        }
        this.configureJMXSupport();
    }

    public LicenceState isLicensed() {
        return this.isLicensed(this.getLicence());
    }

    public LicenceState isLicensed(Licence lic) {
        return this.isLicensed(lic, false);
    }

    public LicenceState isLicensed(Licence lic, boolean testMode) {
        LicenceState pass = LicenceState.VALID;
        if (lic == null || !lic.hasLicence()) {
            pass = LicenceState.NO_LICENCE;
        } else {
            int currentVersion = SoftwareVersion.getMajorVersion() * 100 + SoftwareVersion.getMinorVersion();
            int maxVersion = lic.getMaxVersion();
            int minVersion = lic.getMinVersion();
            if (minVersion > 100 && currentVersion < minVersion) {
                pass = LicenceState.VERSION_MIN_ERROR;
            }
            if (maxVersion <= 100) {
                maxVersion = currentVersion;
            }
            if (maxVersion > 100 && currentVersion > maxVersion) {
                pass = LicenceState.VERSION_MAX_ERROR;
            }
            if (testMode) {
                long expireDate = lic.getExpireTime();
                if (expireDate > 0L && System.currentTimeMillis() > expireDate) {
                    pass = LicenceState.EXPIRED;
                }
                if (pass == LicenceState.VALID && !this.validateHardwareID(this.systemInformation.getMacs(), lic.getMacAddresses())) {
                    pass = LicenceState.HARDWARE_ID_NOT_MATCHING;
                }
            } else {
                if (this.licenceIsExpired) {
                    pass = LicenceState.EXPIRED;
                }
                if (pass == LicenceState.VALID && !this.hardwareIDMatches) {
                    pass = LicenceState.HARDWARE_ID_NOT_MATCHING;
                }
            }
            if (pass == LicenceState.VALID) {
                long countedImages = this.systemMonitor.getAssetCount();
                if (lic.getMaxImages() > 0L && countedImages > 0L && countedImages > lic.getMaxImages()) {
                    pass = LicenceState.IMAGES_EXCEEDED;
                }
            }
            if (pass == LicenceState.VALID && lic.getMaxConnectors() > 0 && this.sourceConnectors.size() > lic.getMaxConnectors()) {
                pass = LicenceState.CONNECTORS_EXCEEDED;
            }
            if (pass == LicenceState.VALID) {
                try {
                    if (lic.getMaxUserGroups() > 0 && this.getUserAuthenticationInterface().getGroupCount() > lic.getMaxUserGroups()) {
                        pass = LicenceState.GROUPS_EXCEEDED;
                    }
                }
                catch (NotConfiguredException notConfiguredException) {
                    // empty catch block
                }
            }
        }
        return pass;
    }

    protected void setLicenceExpired(boolean state) {
        this.licenceIsExpired = state;
    }

    public abstract boolean isMigrationModeEnabled();

    protected abstract void initMBeans();

    public void configureJMXSupport() {
        if (this.settingsFileEvaluated) {
            boolean tryUnregister = true;
            if (this.getPrefsBoolean("application", "jmx")) {
                if (this.getLicence().isJMXEnabled()) {
                    this.initMBeans();
                    tryUnregister = false;
                } else if (this.isLicensed() == LicenceState.VALID) {
                    this.logger.log(2058, new Object[0]);
                }
            }
            if (tryUnregister) {
                this.unregisterMBeans();
            }
        }
    }

    private int evaluateThreadsPerCPU(String threadStr, int maxCPU, int maxConverterTheads) {
        int maxTPJ;
        if (this.licence.isStagingLicence()) {
            maxTPJ = 1;
        } else {
            if (threadStr.equalsIgnoreCase("auto")) {
                maxTPJ = (int)Math.ceil((float)maxCPU * 0.8f);
            } else {
                try {
                    maxTPJ = Integer.valueOf(threadStr);
                }
                catch (NumberFormatException e) {
                    maxTPJ = (int)Math.ceil((float)maxCPU / (float)maxConverterTheads);
                    this.logger.log(2503, "maxThreadsPerJob", threadStr);
                }
            }
            maxTPJ = maxTPJ < 1 ? 1 : maxTPJ;
            maxTPJ = maxTPJ < maxCPU ? maxTPJ : maxCPU;
        }
        return maxTPJ;
    }

    private int evaluateMaxCPU(String cpustr) {
        int maxCPU;
        int maxAvailable = Runtime.getRuntime().availableProcessors();
        if (cpustr.equalsIgnoreCase("auto")) {
            maxCPU = maxAvailable;
        } else {
            try {
                maxCPU = Integer.valueOf(cpustr);
            }
            catch (NumberFormatException e) {
                maxCPU = Runtime.getRuntime().availableProcessors();
                this.logger.log(2503, "maxCPU", cpustr);
            }
        }
        maxCPU = maxCPU < 1 ? 1 : maxCPU;
        int n = maxCPU = maxCPU < maxAvailable ? maxCPU : maxAvailable;
        if (this.licence.isStagingLicence()) {
            maxCPU = 1;
        }
        return maxCPU;
    }

    private int evaluateMaxIO(String cpustr) {
        int maxIO;
        int maxAvailable = 2;
        if (cpustr.equalsIgnoreCase("auto")) {
            maxIO = 2;
        } else {
            try {
                maxIO = Integer.valueOf(cpustr);
            }
            catch (NumberFormatException e) {
                maxIO = Runtime.getRuntime().availableProcessors();
                this.logger.log(2503, "maxIO", cpustr);
            }
        }
        maxIO = maxIO < 1 ? 1 : maxIO;
        int n = maxIO = maxIO < 2 ? maxIO : 2;
        if (this.licence.isStagingLicence()) {
            maxIO = 1;
        }
        return maxIO;
    }

    public int[] evaluateExecutorPoolThreads(int standardConversionThreads) {
        boolean hasHyperThreading = this.getPrefsBoolean("application", "hasht");
        String maxcpuStr = this.getPrefsString("application", "maxcpu");
        int maxcpu = this.evaluateMaxCPU(maxcpuStr);
        if (hasHyperThreading && maxcpu > 1) {
            maxcpu = maxcpu / 2 + 1;
        } else if (maxcpu > 1) {
            --maxcpu;
        }
        String maxioStr = this.getPrefsString("application", "maxio");
        int maxio = this.evaluateMaxIO(maxioStr);
        int cpuThreads = maxcpu;
        int ioThreads = maxio;
        String maxTpjStr = this.getPrefsString("application", "maxthreadsperjob");
        int maxThreadsPerJobs = this.evaluateThreadsPerCPU(maxTpjStr, maxcpu, standardConversionThreads);
        if (!this.licence.isStagingLicence()) {
            String forceTPJ;
            String forceIOThreads;
            String forceCPUThreads = this.getPrefsString("application", "forceCPUThreads");
            if (forceCPUThreads != null && !forceCPUThreads.isEmpty()) {
                try {
                    cpuThreads = Integer.parseInt(forceCPUThreads);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((forceIOThreads = this.getPrefsString("application", "forceIOThreads")) != null && !forceIOThreads.isEmpty()) {
                try {
                    ioThreads = Integer.parseInt(forceIOThreads);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((forceTPJ = this.getPrefsString("application", "forceThreadsPerJob")) != null && !forceTPJ.isEmpty()) {
                try {
                    maxThreadsPerJobs = Integer.parseInt(forceTPJ);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        cpuThreads = cpuThreads < 2 ? 2 : cpuThreads;
        return new int[]{cpuThreads, ioThreads, maxThreadsPerJobs};
    }

    public CacheManager initCacheManager(boolean enabled, long byteCacheSize, boolean useDirectMemory, boolean useL1, int l1Size, boolean useL2, boolean cacheResponse, boolean packAsync) {
        CacheManager manager;
        Object o;
        if (this.servletContext != null && (o = this.servletContext.getAttribute("CacheManager")) != null) {
            this.serverUsesOwnCacheManager = false;
            this.cacheManager = manager = (CacheManager)o;
        }
        if (this.cacheManager == null) {
            this.serverUsesOwnCacheManager = true;
            manager = new CacheManager(this.logger, enabled, byteCacheSize, useDirectMemory, useL1, l1Size, useL2, cacheResponse, packAsync);
            manager.setDaemon(true);
            manager.start();
            this.cacheManager = manager;
        }
        if (this.servletContext != null) {
            this.servletContext.setAttribute("CacheManager", (Object)this.cacheManager);
        }
        return this.cacheManager;
    }

    private void unregisterMBeans() {
        for (ObjectName mb : this.mbeans) {
            MBeanUtils.unregister(this.logger, mb);
        }
        this.mbeans.clear();
    }

    public boolean initMimeTypes(boolean magicScanner) {
        MimeTypesLoader mimeTypesLoader = new MimeTypesLoader(this.logger);
        mimeTypesLoader.loadFromFile(this.getConfigHome().resolve("mime.types"));
        this.mimeTypes = mimeTypesLoader.getMimeTypes();
        ImageFormatScanner.getInstance(this.mimeTypes, magicScanner);
        return this.mimeTypes != null && this.mimeTypes.size() != 0;
    }

    public Map<String, String> getMimeTypes() {
        return this.mimeTypes;
    }

    public static enum LicenceState {
        VALID,
        NO_LICENCE,
        EXPIRED,
        IMAGES_EXCEEDED,
        CONNECTORS_EXCEEDED,
        GROUPS_EXCEEDED,
        WRONG_MAJOR,
        HARDWARE_ID_NOT_MATCHING,
        VERSION_MIN_ERROR,
        VERSION_MAX_ERROR;

    }
}

