/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.utils.Headers;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;

public class HeadersReader {
    private final Map<String, Map<String, String>> headerSets = new HashMap<String, Map<String, String>>();
    private final String[] forbiddenHeaders = new String[]{"X-Software", "Last-modified", "ETag", "X-Comment"};
    private final FSILogger logger;

    public HeadersReader(FSILogger logger) {
        this.logger = logger;
    }

    public Map<String, String> getHeaderSet(String name) {
        return this.headerSets.get(name.toLowerCase());
    }

    public void loadFromFile(Path file) {
        this.headerSets.clear();
        if (Files.exists(file, new LinkOption[0])) {
            try {
                Document doc = FileOperations.getXMLFileContent(this.logger, file);
                String xml = XMLOperations.elementNamesToLowerCase(this.logger, doc);
                Headers rawHeaders = XMLOperations.unmarshalJAXB(xml, Headers.class);
                HashMap<String, String> constants = new HashMap<String, String>();
                for (Headers.NameValuePair pair : rawHeaders.declarations.constants) {
                    constants.put(pair.name, pair.value);
                }
                for (Headers.HeaderSet rawSet : rawHeaders.sets) {
                    HashMap<String, String> set = new HashMap<String, String>();
                    for (Headers.NameValuePair pair : rawSet.headers) {
                        if (this.isForbidden(pair.name)) continue;
                        String value = pair.value;
                        for (Map.Entry constant : constants.entrySet()) {
                            value = value.replace("[" + (String)constant.getKey() + "]", (CharSequence)constant.getValue());
                        }
                        set.put(pair.name, value);
                    }
                    this.headerSets.put(rawSet.name.toLowerCase(), set);
                }
                if (this.logger != null) {
                    this.logger.log(2056, constants.size(), this.headerSets.size());
                }
            }
            catch (Exception e) {
                this.logger.log(2057, e.getLocalizedMessage());
            }
        }
    }

    private boolean isForbidden(String header) {
        for (String forbidden : this.forbiddenHeaders) {
            if (!forbidden.equalsIgnoreCase(header)) continue;
            return true;
        }
        return false;
    }
}

