/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.CorruptReverseLookupException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.NotAValidDirlistFileException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.Provider.DirListWriter;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public final class ImageListFileBuffer
extends Thread {
    private static final int BUFFER_SYNC_INTERVAL = 30000;
    private final IOController ioController;
    private final Map<String, PoolList> filelist = new ConcurrentHashMap<String, PoolList>();
    private final CacheManager cacheManager;
    private volatile boolean keepRunning = true;
    private final boolean bufferingEnabled;
    private final FSIServerSettings settings;
    private final StorageManager storageManager;
    private final ReentrantLock lock = new ReentrantLock();

    public ImageListFileBuffer(FSIServerSettings settings, IOController ioController, boolean bufferingEnabled, StorageManager storageManager) {
        this.setName("ListBuffer");
        this.settings = settings;
        this.bufferingEnabled = bufferingEnabled;
        this.ioController = ioController;
        this.storageManager = storageManager;
        this.cacheManager = settings.getCacheManager();
        if (bufferingEnabled) {
            this.start();
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                this.syncBufferedLists();
                ImageListFileBuffer.sleep(30000L);
            }
            catch (InterruptedException e) {
                this.syncBufferedLists();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.settings.getFSILogger().logException(e, 3151, "unknown", e.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncBufferedLists() {
        this.lock.lock();
        try {
            String[] bufferKeys;
            for (String bufferKey : bufferKeys = this.filelist.keySet().toArray(new String[0])) {
                PoolList pl = this.filelist.get(bufferKey);
                if (pl == null) continue;
                Path target = pl.getStorageDirlist();
                try {
                    if (!pl.isSyncRequired() && FileOperations.getSafeLastModified(target) == pl.lastmodified) continue;
                    this.writeListFile(target, pl);
                    if (pl.isSyncRequired()) continue;
                    this.filelist.remove(bufferKey);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    if (!this.keepRunning) continue;
                    this.settings.getFSILogger().log(3151, target, ioe.getLocalizedMessage());
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolList getList(Path file, String assetURLPath) throws NoSuchFileException, IOException {
        this.lock.lock();
        try {
            PoolList result = this.bufferingEnabled && this.filelist.containsKey(assetURLPath) ? this.filelist.get(assetURLPath) : null;
            if (result == null) {
                CacheKey cacheKey = CacheKey.getInstance(assetURLPath, 'D');
                CacheLoad cl = this.cacheManager.get(cacheKey, CacheType.LIST);
                if (cl != null) {
                    if (cl.requestedL1Object != null) {
                        result = (PoolList)cl.requestedL1Object;
                    } else {
                        result = PoolList.unpack(cl.data);
                    }
                }
                if (result == null) {
                    result = this.getListFileContents(file, assetURLPath);
                    this.cacheManager.put(cacheKey, result, true);
                }
                if (this.bufferingEnabled && result != null) {
                    this.filelist.put(assetURLPath, result);
                }
            }
            PoolList poolList = result;
            return poolList;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidateAllBuffers() {
        this.syncBufferedLists();
        if (this.bufferingEnabled) {
            this.filelist.clear();
        }
    }

    public void invalidateBuffer(String assetURLPath) {
        this.syncBufferedLists();
        if (this.bufferingEnabled) {
            this.filelist.remove(assetURLPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeList(Path listPath, PoolList poolList) {
        if (!this.keepRunning || poolList == null) {
            return;
        }
        this.lock.lock();
        try {
            String listKey;
            block9: {
                boolean listExists = false;
                listKey = poolList.getAssetURLPath();
                if (this.bufferingEnabled) {
                    listExists = Files.exists(listPath, new LinkOption[0]);
                }
                if (!listExists) {
                    try {
                        this.writeListFile(listPath, poolList);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        if (!this.keepRunning) break block9;
                        this.settings.getFSILogger().logException(ioe, 3151, listPath, ioe.getLocalizedMessage());
                    }
                }
            }
            if (this.bufferingEnabled) {
                this.filelist.put(listKey, poolList);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void readAndCheckMagicNumber(byte[] plRaw, Path file) throws NotAValidDirlistFileException, IOException {
        for (int c = 0; c < 8; ++c) {
            if (plRaw[c] == EISEnvironment.SPD_MAGIC[c]) continue;
            throw new NotAValidDirlistFileException(file);
        }
    }

    private short checkContainerMinorVersion(ByteArrayWalker baw) throws IOException {
        short containerVersion = baw.getShort();
        if (containerVersion != 2) {
            throw new IOException("Wrong container version " + containerVersion);
        }
        return containerVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolList getListFileContents(Path dirlistFile, String assetURLPath) throws NoSuchFileException, IOException {
        String assetURLPathValue = assetURLPath.length() > 1 && assetURLPath.endsWith("/") ? assetURLPath.substring(0, assetURLPath.length() - 1) : assetURLPath;
        long startTime = this.settings.getFSILogger().isTraceEnabled() ? System.nanoTime() : 0L;
        boolean error = false;
        PoolList poolList = new PoolList(dirlistFile, assetURLPathValue);
        long checkfilecount = -1L;
        long checkdircount = -1L;
        try {
            byte[] plRaw = null;
            LockerReadWrite.Value<String> eisLock = this.settings.getFileLockHandler().readLock(dirlistFile.toString());
            try {
                this.ioController.waitForRead();
                plRaw = FileOperations.readFile(dirlistFile);
                this.readAndCheckMagicNumber(plRaw, dirlistFile);
            }
            catch (NotAValidDirlistFileException e) {
                plRaw = null;
                int chainEntryNumber = EISChainReader.findChainEntryNumber(dirlistFile, assetURLPathValue);
                if (chainEntryNumber == -1) {
                    throw new NoSuchFileException(dirlistFile + " chain for " + assetURLPathValue);
                }
                Path chainedDirListFile = StorageManager.getChainedDestination(dirlistFile, chainEntryNumber);
                plRaw = FileOperations.readFile(chainedDirListFile);
                this.readAndCheckMagicNumber(plRaw, chainedDirListFile);
                poolList.chainIndex = chainEntryNumber;
                poolList.setStorageDirlist(chainedDirListFile);
            }
            finally {
                this.settings.getFileLockHandler().unlockRead(eisLock);
                this.ioController.unlockRead();
            }
            byte order = plRaw[8];
            ByteOrder bo = order == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            ByteArrayWalker baw = ByteArrayWalker.wrap(plRaw, bo);
            baw.position(9);
            int maxPos = baw.capacity();
            this.checkContainerMinorVersion(baw);
            boolean endReached = false;
            while (!endReached && !error) {
                int tag;
                try {
                    tag = baw.getShort();
                }
                catch (IndexOutOfBoundsException e) {
                    tag = -1;
                    endReached = true;
                }
                if (tag != 3854 && tag != -1) {
                    int tagContentLength;
                    try {
                        tagContentLength = baw.getInt();
                    }
                    catch (IndexOutOfBoundsException e) {
                        tagContentLength = 0;
                        endReached = true;
                    }
                    switch (tag) {
                        case 101: {
                            if (baw.position() + 1 < maxPos) {
                                PoolFileEntry poolEntry = this.readImageTag(baw, tagContentLength);
                                poolList.addImageInitial(poolEntry);
                                break;
                            }
                            endReached = true;
                            error = true;
                            break;
                        }
                        case 102: {
                            if (baw.position() + 1 < maxPos) {
                                PoolDirectoryEntry pde = this.readDirectoryTag(baw, tagContentLength);
                                poolList.addDirectoryInitial(pde);
                                break;
                            }
                            endReached = true;
                            error = true;
                            break;
                        }
                        case 100: {
                            poolList.lastmodified = baw.getLong();
                            break;
                        }
                        case 10: {
                            checkfilecount = baw.getLong();
                            break;
                        }
                        case 11: {
                            checkdircount = baw.getLong();
                            break;
                        }
                        default: {
                            baw.position(baw.position() + tagContentLength);
                            break;
                        }
                    }
                    continue;
                }
                endReached = true;
            }
        }
        catch (OutOfMemoryError oome) {
            if (this.keepRunning) {
                this.settings.getFSILogger().logError(oome, 3157, dirlistFile);
            }
            error = true;
        }
        catch (IndexOutOfBoundsException | NegativeArraySizeException | NullPointerException npe) {
            if (this.keepRunning) {
                this.settings.getFSILogger().logException(npe, 3156, dirlistFile);
            }
            error = true;
        }
        catch (NoSuchFileException fnfe) {
            throw fnfe;
        }
        catch (ClosedChannelException fnfe) {
        }
        catch (IOException ioe) {
            if (this.keepRunning) {
                this.settings.getFSILogger().logException(ioe, 3196, dirlistFile, ioe.getLocalizedMessage());
            }
            throw ioe;
        }
        if (this.settings.getFSILogger().isTraceEnabled() && !error) {
            float time = (float)(System.nanoTime() - startTime) / 1000000.0f;
            this.settings.getFSILogger().log(3516, dirlistFile, Float.valueOf(time));
        }
        if (this.settings.isMigrationModeEnabled()) {
            if (checkfilecount == (long)poolList.getFileCount() && checkdircount == (long)poolList.getDirectoryCount()) {
                poolList.setSyncRequired(false);
            }
        } else {
            if ((checkfilecount != (long)poolList.getFileCount() || checkdircount != (long)poolList.getDirectoryCount()) && this.keepRunning) {
                this.settings.getFSILogger().log(3156, "Data mismatch in " + dirlistFile + " for " + assetURLPathValue);
            }
            poolList.setSyncRequired(false);
        }
        if (error) {
            poolList = null;
        }
        return poolList;
    }

    private PoolDirectoryEntry readDirectoryTag(ByteArrayWalker baw, int tagLength) throws IndexOutOfBoundsException {
        PoolDirectoryEntry pfe = new PoolDirectoryEntry();
        boolean directoryTagFinished = false;
        int tagCount = 0;
        do {
            byte directoryTag = baw.get();
            switch (directoryTag) {
                case 0: {
                    short entryTagLength = baw.getShort();
                    byte[] rawName = new byte[entryTagLength];
                    baw.get(rawName);
                    pfe.name = new String(rawName, FileOperations.charsetUTF8);
                    tagCount += entryTagLength + 1 + 2;
                    break;
                }
                case 1: {
                    pfe.lastmodified = baw.getLong();
                    tagCount += 9;
                    break;
                }
                case 2: {
                    pfe.files = baw.getInt();
                    tagCount += 5;
                    ++tagCount;
                    break;
                }
                case 3: {
                    pfe.subdirectories = baw.getInt();
                    tagCount += 5;
                    ++tagCount;
                }
            }
        } while (tagCount < tagLength);
        return pfe;
    }

    private PoolFileEntry readImageTag(ByteArrayWalker baw, int tagLength) throws IndexOutOfBoundsException {
        PoolFileEntry pfe = new PoolFileEntry();
        boolean imageTagFinished = false;
        int tagCount = 0;
        do {
            short tag = baw.get();
            switch (tag) {
                case 1: {
                    short entryTagLength = baw.getShort();
                    byte[] rawName = new byte[entryTagLength];
                    baw.get(rawName);
                    pfe.name = new String(rawName, FileOperations.charsetUTF8);
                    tagCount += entryTagLength + 1 + 2;
                    break;
                }
                case 2: {
                    pfe.filesize = baw.getLong();
                    tagCount += 9;
                    break;
                }
                case 3: {
                    pfe.lastmodified = baw.getLong();
                    tagCount += 9;
                    break;
                }
                case 4: {
                    pfe.width = baw.getInt();
                    tagCount += 5;
                    break;
                }
                case 5: {
                    pfe.height = baw.getInt();
                    tagCount += 5;
                    break;
                }
                case 0: {
                    pfe.importStatus = baw.get();
                    tagCount += 2;
                }
            }
        } while (tagCount != tagLength);
        return pfe;
    }

    private void writeListFile(Path dirListFile, PoolList poolList) throws IOException {
        poolList.setSyncRequired(false);
        PoolList listCopy = (PoolList)poolList.copy();
        try {
            DirListWriter dlw = new DirListWriter(this.settings.getFSILogger(), listCopy, this.storageManager.getStorageLogger());
            Path target = StorageManager.getDestinationWithoutChainIndex(dirListFile);
            this.storageManager.executeStorageDataProvider(target, dlw);
        }
        catch (CorruptReverseLookupException e) {
            this.settings.getFSILogger().log(3229, dirListFile);
            Files.deleteIfExists(dirListFile);
        }
    }

    void halt() {
        this.keepRunning = false;
        this.interrupt();
        this.syncBufferedLists();
    }
}

