/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ImageListFileBuffer;
import com.neptunelabs.fsiserver.utils.PoolList;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import javax.servlet.ServletContext;

public class ImageListFileReader {
    private final FSIServerSettings serverSettings;
    private ImageListFileBuffer listfilebuffer = null;

    public ImageListFileReader(FSIServerSettings settings, IOController ioController, StorageManager storageManager, boolean enableBuffering) {
        Object plfb;
        ServletContext sc;
        this.serverSettings = settings;
        if (settings != null && (sc = settings.getServletContext()) != null && (plfb = sc.getAttribute("ListFileBuffer")) != null) {
            this.listfilebuffer = (ImageListFileBuffer)plfb;
        }
        if (this.listfilebuffer == null) {
            this.listfilebuffer = new ImageListFileBuffer(settings, ioController, enableBuffering, storageManager);
            if (settings != null && (sc = settings.getServletContext()) != null) {
                sc.setAttribute("ListFileBuffer", (Object)this.listfilebuffer);
            }
        }
    }

    public PoolList getListFileContents(Path path, String assetURLPath) throws NoSuchFileException, IOException {
        return this.listfilebuffer.getList(path, assetURLPath);
    }

    public ImageListFileBuffer getListBuffer() {
        return this.listfilebuffer;
    }

    public void shutdownListBuffer() {
        if (this.listfilebuffer != null) {
            this.listfilebuffer.halt();
            try {
                this.listfilebuffer.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

