/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.ImageListFileReader;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolList;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ImageListFileWriter {
    private final FSIServerSettings settings;
    private final ImageListFileReader reader;

    public ImageListFileWriter(FSIServerSettings settings, ImageListFileReader reader) {
        this.settings = settings;
        this.reader = reader;
    }

    public void updateEntry(Path dirlistFile, String assetURLPath, Path parentDirlistFile, String parentAssetURL, PoolEntry pe, long lastmodified) {
        ArrayList<PoolEntry> entriesToUpdate = new ArrayList<PoolEntry>(1);
        if (pe != null) {
            entriesToUpdate.add(pe);
        }
        this.updateEntries(dirlistFile, assetURLPath, parentDirlistFile, parentAssetURL, entriesToUpdate, lastmodified);
    }

    public PoolList updateEntries(Path dirlistPath, String assetURLPath, Path parentDirlistPath, String parentAssetURLPath, List<PoolEntry> entriesToUpdate, long lastmodified) {
        if (entriesToUpdate == null) {
            return null;
        }
        assetURLPath = ImageListFileWriter.cleanEntryname(assetURLPath);
        PoolList poolList = this.getPoolList(dirlistPath, assetURLPath);
        if (lastmodified != -1L) {
            poolList.lastmodified = lastmodified;
        }
        this.replacePoolListEntries(poolList, entriesToUpdate);
        poolList.setSyncRequired(true);
        this.writeListAndLog(dirlistPath, assetURLPath, poolList);
        if (parentDirlistPath != null && parentAssetURLPath != null) {
            String dirname = (parentAssetURLPath = ImageListFileWriter.cleanEntryname(parentAssetURLPath)).length() > 1 ? assetURLPath.substring(parentAssetURLPath.length() + 1) : assetURLPath;
            this.updateParentContentCount(parentDirlistPath, parentAssetURLPath, dirname, poolList.getDirectoryCount(), poolList.getFileCount(), poolList.lastmodified);
        }
        this.settings.getFSILogger().log(3507, entriesToUpdate.size(), assetURLPath, dirlistPath);
        return poolList;
    }

    private void updateParentContentCount(Path dirlistFile, String assetURLPath, String directoryName, int directoryCount, int fileCount, long lastmodified) {
        PoolList poolList = this.getPoolList(dirlistFile, assetURLPath);
        PoolDirectoryEntry pde = poolList.getDirectory(directoryName);
        boolean update = false;
        if (pde != null) {
            if (pde.lastmodified != lastmodified) {
                pde.lastmodified = lastmodified;
                update = true;
            }
            if (pde.files != (long)fileCount) {
                pde.files = fileCount;
                update = true;
            }
            if (pde.subdirectories != (long)directoryCount) {
                pde.subdirectories = directoryCount;
                update = true;
            }
        } else {
            PoolDirectoryEntry newPde = new PoolDirectoryEntry(directoryName, lastmodified, fileCount, directoryCount);
            poolList.addDirectory(newPde);
            poolList.lastmodified = lastmodified;
            update = true;
        }
        if (update) {
            this.writeListAndLog(dirlistFile, assetURLPath, poolList);
        }
    }

    public void updateLastModified(Path dirlist, String assetURLPath, long lastmodified) {
        PoolList poolList;
        this.settings.getFSILogger().log(3509, assetURLPath, dirlist);
        try {
            poolList = this.reader.getListFileContents(dirlist, assetURLPath);
        }
        catch (IOException e) {
            poolList = new PoolList(dirlist, assetURLPath);
        }
        if (poolList == null) {
            poolList = new PoolList(dirlist, assetURLPath);
        }
        poolList.lastmodified = lastmodified;
        poolList.setSyncRequired(true);
        this.writeListAndLog(dirlist, assetURLPath, poolList);
    }

    private void replacePoolListEntries(PoolList poolList, List<PoolEntry> list) {
        for (PoolEntry entry : list) {
            if (entry.type == ListEntryType.FILE) {
                this.replaceImageEntry(poolList, (PoolFileEntry)entry);
                continue;
            }
            if (entry.type != ListEntryType.DIRECTORY) continue;
            poolList.addDirectory((PoolDirectoryEntry)entry);
        }
    }

    private PoolList getPoolList(Path dirlist, String assetURLPath) {
        PoolList poolList = null;
        try {
            poolList = this.reader.getListFileContents(dirlist, assetURLPath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (poolList == null) {
            poolList = new PoolList(dirlist, assetURLPath);
        }
        return poolList;
    }

    private int replaceImageEntry(PoolList poolList, PoolFileEntry entry) {
        int result = 1;
        if (poolList.containsImageFilename(entry.name)) {
            if (entry.width == 0) {
                PoolFileEntry oldentry = poolList.getImage(entry.name);
                entry.width = oldentry.width;
                entry.height = oldentry.height;
            }
            poolList.removeImageFilename(entry.name);
            result = 0;
        }
        poolList.addImage(entry);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(Path dirlistfile, String dirURLPath, Path parentDirlistFile, String parentAssetURLPath, String entryname, long lastmodified) {
        entryname = ImageListFileWriter.cleanEntryname(entryname);
        dirURLPath = ImageListFileWriter.cleanEntryname(dirURLPath);
        String string = dirlistfile.toAbsolutePath().toString();
        synchronized (string) {
            try {
                PoolList poolList = this.reader.getListFileContents(dirlistfile, dirURLPath);
                if (lastmodified > 0L) {
                    poolList.lastmodified = lastmodified;
                }
                boolean deletedEntry = false;
                if (poolList.containsImageFilename(entryname)) {
                    this.settings.getFSILogger().log(3514, entryname, dirlistfile);
                    poolList.removeImageFilename(entryname);
                    deletedEntry = true;
                } else if (poolList.getDirectoryNameSet().contains(entryname)) {
                    this.settings.getFSILogger().log(3515, entryname, dirlistfile);
                    poolList.removeDirectory(entryname);
                    deletedEntry = true;
                }
                if (deletedEntry) {
                    this.writeListAndLog(dirlistfile, dirURLPath, poolList);
                    if (parentDirlistFile != null && parentAssetURLPath != null) {
                        String dirname = (parentAssetURLPath = ImageListFileWriter.cleanEntryname(parentAssetURLPath)).length() > 1 ? dirURLPath.substring(parentAssetURLPath.length() + 1) : dirURLPath;
                        this.updateParentContentCount(parentDirlistFile, parentAssetURLPath, dirname, poolList.getDirectoryCount(), poolList.getFileCount(), poolList.lastmodified);
                    }
                }
            }
            catch (IOException e) {
                this.settings.getFSILogger().logException(e, 3249, dirURLPath, dirlistfile);
            }
        }
    }

    private void writeListAndLog(Path dirlistfile, String assetURLPath, PoolList poolList) {
        this.reader.getListBuffer().writeList(dirlistfile, poolList);
        if (this.settings instanceof SourceManagerSettings) {
            ((SourceManagerSettings)this.settings).getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.U, assetURLPath);
        }
    }

    public void forceClearingAllBuffers() {
        this.reader.getListBuffer().invalidateAllBuffers();
    }

    public void forceClearingBuffer(String assetURLPath) {
        this.reader.getListBuffer().invalidateBuffer(assetURLPath);
    }

    public synchronized void replaceAll(Path dirlistfile, PoolList poolList) {
        this.reader.getListBuffer().writeList(dirlistfile, poolList);
    }

    private static String cleanEntryname(String entryname) {
        if (!entryname.equals("/")) {
            if (entryname.startsWith("/")) {
                entryname = entryname.substring(1);
            }
            if (entryname.endsWith("/")) {
                entryname = entryname.substring(0, entryname.lastIndexOf(47));
            }
        }
        return entryname;
    }

    public static enum ListEntryType {
        FILE,
        DIRECTORY,
        NONE;

    }
}

