/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.w3c.dom.Document;

public class LDAPAuthentication
extends UserAuthenticationInterface {
    private final Path configHome;
    private final SearchControls subtreeSearchControls;
    final String ldapuri;
    final String ldapuser;
    final String ldappassword;
    final String ldapbaseDN;
    private int ldapUsersChecksum = -1;
    private int ldapGroupsChecksum = -1;

    public LDAPAuthentication(SourceManagerSettings settings) {
        super(settings);
        this.configHome = settings.getConfigHome();
        this.subtreeSearchControls = new SearchControls();
        this.subtreeSearchControls.setSearchScope(2);
        String rawldapuri = settings.getPrefsString("application", "ldapuri");
        this.ldapuri = rawldapuri.endsWith("/") ? rawldapuri : rawldapuri + "/";
        this.ldapuser = settings.getPrefsString("application", "ldapuser");
        this.ldappassword = settings.getPrefsString("application", "ldappassword");
        this.ldapbaseDN = settings.getPrefsString("application", "ldapbasedn");
        this.permissionsetsDirectory = this.configHome.resolve("permissionsets");
        this.propertySetsDirectory = this.configHome.resolve("propertysets");
        this.publishingSetsDirectory = this.configHome.resolve("publishingsets");
        this.readPermissionConfig();
        this.readPropertyConfig();
        Path[] permissionRelevantDirectories = new Path[]{this.permissionsetsDirectory};
        this.setupMonitoring("readPermissionsConfig", null, permissionRelevantDirectories);
        Path[] propertiesRelevantDirectories = new Path[]{this.propertySetsDirectory, this.publishingSetsDirectory};
        this.setupMonitoring("readPropertConfig", null, propertiesRelevantDirectories);
    }

    @Override
    public boolean isPasswordChangePossible() {
        return false;
    }

    private Hashtable<String, String> getLDAPEnvironment() {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapuri + this.ldapbaseDN);
        if (this.ldapuser != null && this.ldapuser.length() > 0) {
            env.put("java.naming.security.authentication", "simple");
            env.put("java.naming.security.principal", this.ldapuser);
            env.put("java.naming.security.credentials", this.ldappassword);
        }
        return env;
    }

    @Override
    public boolean addGroup(String groupname, Set<String> usersValue, String permissionSet, String propertySet) {
        return false;
    }

    @Override
    protected void readPermissionSets() {
        this.permissionSets.clear();
        this.globalPermissions = null;
        this.setupDefaultPermissionSets();
        try {
            List<PathCached> permissionSetFiles = FileOperations.listFiles(this.permissionsetsDirectory, "*.xml");
            for (PathCached permissionSetFile : permissionSetFiles) {
                String pSetName = permissionSetFile.getFileName().substring(0, permissionSetFile.getFileName().length() - 4);
                try {
                    Document doc = FileOperations.getXMLFileContent(this.settings.getFSILogger(), permissionSetFile.getPath());
                    String xml = XMLOperations.elementNamesToLowerCase(this.settings.getFSILogger(), doc);
                    PermissionSet pset = XMLOperations.unmarshalJAXB(xml, PermissionSet.class);
                    pset.setName(pSetName);
                    this.rawPermissionSets.put(pSetName, pset);
                    PermissionSet productionPSet = pset.clone();
                    productionPSet.applyDefaults();
                    this.permissionSets.put(pSetName, productionPSet);
                }
                catch (DataBindingException dbe) {
                    this.settings.getFSILogger().log(2061, permissionSetFile);
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            this.settings.getFSILogger().logException(e, 2072, this.propertySetsDirectory.toString());
        }
    }

    public boolean checkLDAPConfig() {
        boolean changesPerformed = false;
        int currentLdapGroupsChecksum = this.ldapGroupsChecksum;
        Map<String, Group> tmpGroups = this.getGroupsFromLDAP();
        if (currentLdapGroupsChecksum != this.ldapGroupsChecksum) {
            this.groups.clear();
            this.setupDefaultGroups();
            this.groups.putAll(tmpGroups);
            changesPerformed = true;
        }
        int currentLdapUsersChecksum = this.ldapUsersChecksum;
        Set<Users.User> tmpUsers = this.getUsersFromLDAP();
        if (currentLdapUsersChecksum != this.ldapUsersChecksum) {
            this.users.clear();
            this.users.addAll(tmpUsers);
            changesPerformed = true;
        }
        return changesPerformed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Group> getGroupsFromLDAP() {
        HashMap<String, Group> result = new HashMap<String, Group>();
        NamingEnumeration<SearchResult> results = null;
        try {
            InitialDirContext ctx = null;
            ctx = new InitialDirContext(this.getLDAPEnvironment());
            results = ctx.search("", "(objectclass=groupOfNames)", this.subtreeSearchControls);
            while (results.hasMore()) {
                SearchResult searchResult = results.next();
                Attributes attributes = searchResult.getAttributes();
                Attribute attr = attributes.get("cn");
                String cn = (String)attr.get();
                Group g = new Group(cn);
                HashSet<String> usersInGroup = new HashSet<String>();
                Attribute a = attributes.get("member");
                NamingEnumeration<?> members = a.getAll();
                while (members.hasMore()) {
                    LdapName ldapName = new LdapName((String)members.next());
                    List<Rdn> rdns = ldapName.getRdns();
                    usersInGroup.add((String)rdns.get(rdns.size() - 1).getValue());
                }
                g.setUsers(usersInGroup);
                result.put(g.getName(), g);
            }
        }
        catch (NamingException e) {
            this.settings.getFSILogger().log(2062, e.getLocalizedMessage());
        }
        finally {
            LDAPAuthentication.closeResult(results);
        }
        this.ldapGroupsChecksum = result.hashCode();
        return result;
    }

    @Override
    protected void readGroups() {
        this.groups.clear();
        this.setupDefaultGroups();
        this.groups.putAll(this.getGroupsFromLDAP());
    }

    @Override
    protected void readUsers() {
        this.users.clear();
        this.users.addAll(this.getUsersFromLDAP());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Users.User> getUsersFromLDAP() {
        HashSet<Users.User> result = new HashSet<Users.User>();
        NamingEnumeration<SearchResult> results = null;
        try {
            InitialDirContext ctx = null;
            ctx = new InitialDirContext(this.getLDAPEnvironment());
            results = ctx.search("", "(objectclass=account)", this.subtreeSearchControls);
            HashSet<String> usernames = new HashSet<String>();
            while (results.hasMore()) {
                SearchResult searchResult = results.next();
                Users.User u = new Users.User();
                Attributes attributes = searchResult.getAttributes();
                Attribute nameAttr = attributes.get("uid");
                u.name = (String)nameAttr.get();
                Attribute passwordAttr = attributes.get("userPassword");
                if (passwordAttr != null && passwordAttr.get() instanceof byte[]) {
                    u.hash = new String((byte[])passwordAttr.get(), FileOperations.charsetUTF8);
                }
                result.add(u);
                usernames.add(u.name);
            }
            Group authenticatedGroup = (Group)this.groups.get("authenticated");
            if (authenticatedGroup != null) {
                authenticatedGroup.setUsers(usernames);
            }
        }
        catch (NamingException e) {
            this.settings.getFSILogger().log(2062, e.getLocalizedMessage());
        }
        finally {
            LDAPAuthentication.closeResult(results);
        }
        this.ldapUsersChecksum = result.hashCode();
        return result;
    }

    private static void closeResult(NamingEnumeration<?> result) {
        if (result != null) {
            try {
                result.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected synchronized boolean savePermissionSets() {
        permissionLock.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean success = true;
        for (Map.Entry entry : this.rawPermissionSets.entrySet()) {
            Path targetFile = this.permissionsetsDirectory.resolve((String)entry.getKey() + ".xml");
            try {
                try (OutputStream fos = Files.newOutputStream(targetFile, new OpenOption[0]);){
                    JAXB.marshal(entry.getValue(), (OutputStream)fos);
                }
                success &= true;
            }
            catch (IOException ioe) {
                this.settings.getFSILogger().log(2048, targetFile, ioe.getLocalizedMessage());
            }
            catch (DataBindingException dbe) {
                this.settings.getFSILogger().log(2048, targetFile, dbe.getLocalizedMessage());
            }
        }
        this.setFileMonitorTasksSuspended(false);
        permissionLock.unlock();
        return success;
    }

    @Override
    protected synchronized boolean saveGroups() {
        throw new UnsupportedOperationException("Saving to LDAP Server not permitted");
    }

    @Override
    protected synchronized boolean saveUsers() {
        throw new UnsupportedOperationException("Saving to LDAP Server not permitted");
    }

    @Override
    public boolean duplicateGroup(String source, String target) {
        throw new UnsupportedOperationException("Saving to LDAP Server not permitted");
    }

    public Path getPermissionSetsDirectory() {
        return this.permissionsetsDirectory;
    }

    @Override
    public boolean isUserModificationPossible() {
        return false;
    }
}

