/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.licensing.Licence;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import java.util.TimerTask;

public class LicenceExpireTimerTask
extends TimerTask {
    private final FSIServerSettings settings;
    private Licence licence;
    private long maxRuntime;
    private final long runDelay;
    private long countedRuntime = 0L;
    private long expireTime;
    private long registerTime;

    public LicenceExpireTimerTask(FSIServerSettings settings, long runDelay) {
        this.settings = settings;
        this.runDelay = runDelay;
    }

    @Override
    public void run() {
        boolean expired = false;
        this.licence = this.settings.getLicence();
        if (this.licence != null && this.licence.hasLicence()) {
            this.maxRuntime = this.licence.getExpireTime() - this.licence.getRegisterTime();
            this.expireTime = this.licence.getExpireTime();
            this.registerTime = this.licence.getRegisterTime();
            if (this.expireTime > 0L) {
                long cTime = System.currentTimeMillis();
                if (cTime > this.expireTime) {
                    expired = true;
                } else if (cTime < this.registerTime) {
                    expired = true;
                }
                this.countedRuntime += this.runDelay;
                if (this.countedRuntime > this.maxRuntime) {
                    expired = true;
                }
            }
        }
        this.settings.setLicenceExpired(expired);
    }

    void resetRuntimeCounter() {
        this.countedRuntime = 0L;
    }
}

