/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.IOController;
import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.FileLockHandler;
import com.neptunelabs.fsiserver.utils.SPXEnvironment;
import com.neptunelabs.fsiserver.utils.histogram.HistogramLoader;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

public final class MetaDataFileReader {
    public static final int BASIC = 0;
    public static final int ADVANCED = 1;
    public static final int ICC = 2;
    public static final int IPTC = 4;
    public static final int EXIF = 8;
    public static final int XMP = 16;
    public static final int HISTOGRAM = 32;
    public static final int SELECTIONS = 64;
    private final FSIServerSettings settings;
    private final IOController ioController;

    public MetaDataFileReader(FSIServerSettings settings, IOController ioController) {
        this.settings = settings;
        this.ioController = ioController;
    }

    public ImageMetaData getMetaData(Path file, int readFlag) throws NoSuchFileException, IOException {
        this.settings.getFSILogger().log(3501, file);
        return this.getMetaDataObjectFromFile(file, readFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageMetaData getMetaDataObjectFromFile(Path file, int readFlag) throws NoSuchFileException {
        ImageMetaData result = new ImageMetaData();
        FileLockHandler lockHandler = this.settings.getFileLockHandler();
        LockerReadWrite.Value<String> eisLock = lockHandler.readLock(file.toString());
        this.ioController.waitForRead();
        try (ReaderChannel input = new ReaderChannel(file, StandardOpenOption.READ);){
            byte[] magicNumber = new byte[8];
            ((ReaderAbstract)input).read(magicNumber);
            ByteOrder bo = ((ReaderAbstract)input).readByte() == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
            input.setByteOrder(bo);
            result.setByteOrder(bo);
            if (Arrays.equals(magicNumber, SPXEnvironment.SPM_MAGIC)) {
                result.setContainterMinorVersion(((ReaderAbstract)input).readShort());
                boolean endReached = false;
                while (!endReached) {
                    try {
                        endReached |= this.processNextTag(input, result, readFlag, file.getParent());
                        if ((readFlag & 1) != 0 || !result.basicDataComplete()) continue;
                        endReached = true;
                    }
                    catch (EOFException e) {
                        endReached = true;
                        this.settings.getFSILogger().log(3504, e.getLocalizedMessage(), file);
                    }
                }
            } else {
                this.settings.getFSILogger().log(3503, file);
                result.setImportStatus((byte)2);
            }
        }
        catch (NoSuchFileException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            result.setImportStatus((byte)2);
            this.settings.getFSILogger().logException(ioe, 3505, file, ioe.getLocalizedMessage());
        }
        finally {
            this.ioController.unlockRead();
            lockHandler.unlockRead(eisLock);
        }
        return result;
    }

    private boolean processNextTag(ReaderAbstract input, ImageMetaData result, int readFlag, Path inputdir) throws IOException {
        short tag = input.readShort();
        int tagContentLength = input.readInt();
        if (tag == -1 || tagContentLength == -1) {
            return true;
        }
        switch (tag) {
            case 1: {
                result.setFormatVersion(input.readShort());
                break;
            }
            case 2: {
                result.setImportStatus((byte)input.readShort());
                break;
            }
            case 11: {
                result.setWidth(input.readInt());
                break;
            }
            case 12: {
                result.setHeight(input.readInt());
                break;
            }
            case 14: {
                this.readImportModuleName(result, input, tagContentLength, readFlag);
                break;
            }
            case 16: {
                result.setLastModified(input.readLong());
                break;
            }
            case 17: {
                result.setSourceFileSize(input.readLong());
                break;
            }
            case 18: {
                this.readImportTime(result, input, tagContentLength, readFlag);
                break;
            }
            case 200: {
                this.readSymKey(result, input, tagContentLength, readFlag);
                break;
            }
            case 202: {
                this.readIPTC(result, input, inputdir, tagContentLength, readFlag);
                break;
            }
            case 203: {
                this.readExif(result, input, inputdir, tagContentLength, readFlag);
                break;
            }
            case 212: {
                this.readHistogram(result, input, inputdir, tagContentLength, readFlag);
                break;
            }
            case 211: {
                this.readICC(result, input, inputdir, tagContentLength, readFlag);
                break;
            }
            case 501: {
                this.readZoomLevels(result, input, tagContentLength);
                break;
            }
            case 502: {
                result.setTileSize(input.readInt());
                break;
            }
            case 503: {
                this.readTileFormat(result, input);
                break;
            }
            case 508: {
                result.setExtraAlphaCount(input.readInt());
                break;
            }
            case 3854: {
                return true;
            }
            default: {
                input.skip(tagContentLength);
            }
        }
        return false;
    }

    private void readTileFormat(ImageMetaData result, ReaderAbstract input) throws IOException {
        byte format = input.readByte();
        if (format == 4 || format == 2) {
            result.setHasAlpha(true);
        }
        result.setTileFormat(format);
    }

    private void readImportModuleName(ImageMetaData result, ReaderAbstract input, int tagContentLength, int readFlag) throws IOException {
        if ((readFlag & 1) > 0) {
            byte[] module = new byte[tagContentLength];
            input.read(module);
            result.setImportModuleName(new String(module, FileOperations.charsetUTF8));
        } else {
            input.skip(tagContentLength);
        }
    }

    private void readImportTime(ImageMetaData result, ReaderAbstract input, int tagContentLength, int readFlag) throws IOException {
        if ((readFlag & 1) > 0) {
            result.setImportTime(input.readLong());
        } else {
            input.skip(tagContentLength);
        }
    }

    private void readSymKey(ImageMetaData result, ReaderAbstract input, int tagContentLength, int readFlag) throws IOException {
        if ((readFlag & 1) > 0) {
            byte[] kh = new byte[tagContentLength];
            input.read(kh);
            result.setKeyHook(kh);
        } else {
            input.skip(tagContentLength);
        }
    }

    private void readZoomLevels(ImageMetaData result, ReaderAbstract input, int tagContentLength) throws IOException {
        double[] zoomlevels = new double[tagContentLength / 8];
        for (int i = 0; i < zoomlevels.length; ++i) {
            zoomlevels[i] = input.readDouble();
        }
        result.setZoomFactors(zoomlevels);
    }

    private void readICC(ImageMetaData result, ReaderAbstract input, Path inputdir, int tagContentLength, int readFlag) throws IOException {
        if ((readFlag & 2) > 0) {
            Path iccFile;
            short x = input.readShort();
            if (x == 1 && Files.isReadable(iccFile = inputdir.resolve("color.icc"))) {
                byte[] iccBytes = FileOperations.readFile(this.settings.getFSILogger(), iccFile);
                ICCProfileWrap ipw = new ICCProfileWrap(iccBytes);
                result.setICC(ipw);
            }
        } else {
            input.skip(tagContentLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readHistogram(ImageMetaData result, ReaderAbstract input, Path inputdir, int tagContentLength, int readFlag) throws IOException {
        if ((readFlag & 0x20) > 0) {
            Path histoFile;
            short x = input.readShort();
            if (x == 1 && Files.isReadable(histoFile = inputdir.resolve("meta.hist"))) {
                this.ioController.waitForRead();
                try {
                    result.setHistogram(HistogramLoader.load(histoFile));
                }
                catch (IOException iOException) {
                }
                finally {
                    this.ioController.unlockRead();
                }
            }
        } else {
            input.skip(tagContentLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readIPTC(ImageMetaData result, ReaderAbstract input, Path inputdir, int tagContentLength, int readFlag) throws IOException {
        if ((readFlag & 4) > 0) {
            Path iptcFile;
            short x = input.readShort();
            if (x == 1 && Files.isReadable(iptcFile = inputdir.resolve("meta.iptc"))) {
                this.ioController.waitForRead();
                try {
                    result.addIPTCData(FileOperations.readFile(this.settings.getFSILogger(), iptcFile));
                }
                finally {
                    this.ioController.unlockRead();
                }
            }
        } else {
            input.skip(tagContentLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readExif(ImageMetaData result, ReaderAbstract input, Path inputdir, int tagContentLength, int readFlag) throws IOException {
        if ((readFlag & 8) > 0) {
            Path exifFile;
            short x = input.readShort();
            if (x == 1 && Files.isReadable(exifFile = inputdir.resolve("meta.exif"))) {
                this.ioController.waitForRead();
                try {
                    result.setEXIF(FileOperations.readFile(this.settings.getFSILogger(), exifFile));
                }
                finally {
                    this.ioController.unlockRead();
                }
            }
        } else {
            input.skip(tagContentLength);
        }
    }
}

