/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.DirectOutputStream;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.PoolEntry;
import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.PoolListSummary;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class PoolList
implements CacheableData<PoolList> {
    private Path dirlistFile;
    private final String assetURLPath;
    public short version = (short)-1;
    public long lastmodified = -1L;
    public int chainIndex = 0;
    private final Map<String, PoolFileEntry> images;
    private final Map<String, PoolDirectoryEntry> directories;
    private volatile boolean syncRequired = true;

    public PoolList(Path dirlistFile, String assetURLPath) {
        this.dirlistFile = dirlistFile;
        this.assetURLPath = assetURLPath;
        this.images = new ConcurrentHashMap<String, PoolFileEntry>(16, 0.75f, 2);
        this.directories = new ConcurrentHashMap<String, PoolDirectoryEntry>(16, 0.75f, 2);
    }

    public PoolList(Path dirlistFile, String assetURLPath, int fileInitCount, int dirInitCount) {
        this.dirlistFile = dirlistFile;
        this.assetURLPath = assetURLPath;
        this.images = new ConcurrentHashMap<String, PoolFileEntry>(fileInitCount + 16, 0.75f, 2);
        this.directories = new ConcurrentHashMap<String, PoolDirectoryEntry>(dirInitCount + 16, 0.75f, 2);
    }

    public boolean isSyncRequired() {
        return this.syncRequired;
    }

    public void setSyncRequired(boolean syncRequired) {
        this.syncRequired = syncRequired;
    }

    public Path getStorageDirlist() {
        return this.dirlistFile;
    }

    public void setStorageDirlist(Path dir) {
        this.dirlistFile = dir;
    }

    public String getAssetURLPath() {
        return this.assetURLPath;
    }

    public int addImage(PoolFileEntry pe) {
        PoolFileEntry previous = this.images.put(pe.name, pe);
        int result = previous != null ? 0 : 1;
        this.syncRequired = true;
        return result;
    }

    public void addImageInitial(PoolFileEntry pe) {
        this.images.put(pe.name, pe);
    }

    public int addDirectory(PoolDirectoryEntry dir) {
        int result = 0;
        PoolDirectoryEntry previous = this.directories.put(dir.name, dir);
        result = previous != null ? 0 : 1;
        this.syncRequired = true;
        return result;
    }

    public void addDirectoryInitial(PoolDirectoryEntry dir) {
        this.directories.put(dir.name, dir);
    }

    public Collection<PoolFileEntry> getFilesAsCollection() {
        return this.images.values();
    }

    public List<PoolFileEntry> getFilesAsList() {
        return new ArrayList<PoolFileEntry>(this.images.values());
    }

    public Set<Map.Entry<String, PoolFileEntry>> getImageSet() {
        return this.images.entrySet();
    }

    public Set<String> getImageNameSet() {
        return new HashSet<String>(this.images.keySet());
    }

    public PoolDirectoryEntry getDirectory(String name) {
        return this.directories.get(name);
    }

    public Map<String, PoolDirectoryEntry> getDirectories() {
        return this.directories;
    }

    public List<String> getDirectoryNamesAsList() {
        return new ArrayList<String>(this.directories.keySet());
    }

    public List<PoolDirectoryEntry> getDirectoriesAsList() {
        return new ArrayList<PoolDirectoryEntry>(this.directories.values());
    }

    public Collection<PoolDirectoryEntry> getDirectoriesAsCollection() {
        return this.directories.values();
    }

    public Set<String> getDirectoryNameSet() {
        return new HashSet<String>(this.directories.keySet());
    }

    public boolean containsImageFilename(String filename) {
        return this.images.containsKey(filename);
    }

    public boolean containsDirectory(String dir) {
        return this.directories.containsKey(dir);
    }

    public synchronized boolean removeImageFilename(String filename) {
        if (this.images.remove(filename) != null) {
            this.syncRequired = true;
            return true;
        }
        return false;
    }

    public synchronized boolean removeDirectory(String dir) {
        if (this.directories.remove(dir) != null) {
            this.syncRequired = true;
            return true;
        }
        return false;
    }

    public synchronized PoolFileEntry getImage(String name) {
        return this.images.get(name);
    }

    @Override
    public CacheableData<PoolList> copy() {
        PoolList copy = new PoolList(this.dirlistFile, this.assetURLPath, this.images.size(), this.directories.size());
        copy.version = this.version;
        copy.lastmodified = this.lastmodified;
        for (PoolFileEntry pe : this.images.values()) {
            copy.addImage(pe);
        }
        for (PoolDirectoryEntry dir : this.directories.values()) {
            copy.addDirectory(dir);
        }
        return copy;
    }

    public int getFileCount() {
        return this.images.size();
    }

    public int getDirectoryCount() {
        return this.directories.size();
    }

    public PoolListSummary getSummary() {
        return new PoolListSummary(this.lastmodified, this.getFileCount(), this.getDirectoryCount());
    }

    @Override
    public byte[] pack() {
        byte[] result;
        try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast((this.images.size() + this.directories.size()) * 32);
             DirectOutputStream dos = new DirectOutputStream(baos);){
            byte[] nameBytes;
            dos.setByteOrder(ByteOrder.nativeOrder());
            if (this.dirlistFile != null) {
                String ap = this.dirlistFile.toAbsolutePath().toString();
                byte[] byArray = ap.getBytes(FileOperations.charsetUTF8);
                dos.writeInt(byArray.length);
                dos.write(byArray);
            } else {
                dos.writeInt(0);
            }
            if (this.assetURLPath != null) {
                byte[] data = this.assetURLPath.getBytes(FileOperations.charsetUTF8);
                dos.writeInt(data.length);
                dos.write(data);
            } else {
                dos.writeInt(0);
            }
            dos.writeShort(this.version);
            dos.writeLong(this.lastmodified);
            dos.writeInt(this.chainIndex);
            dos.writeBoolean(this.isSyncRequired());
            if (this.images != null && this.images.size() > 0) {
                dos.writeInt(this.images.size());
                for (Map.Entry<String, PoolFileEntry> entry : this.images.entrySet()) {
                    PoolFileEntry pfe = entry.getValue();
                    nameBytes = pfe.name.getBytes(FileOperations.charsetUTF8);
                    dos.writeInt(nameBytes.length);
                    dos.write(nameBytes);
                    dos.writeLong(pfe.lastmodified);
                    dos.writeLong(pfe.filesize);
                    dos.writeInt(pfe.width);
                    dos.writeInt(pfe.height);
                    dos.writeByte(pfe.importStatus);
                }
            } else {
                dos.writeInt(0);
            }
            if (this.directories != null && this.directories.size() > 0) {
                dos.writeInt(this.directories.size());
                for (Map.Entry<String, PoolEntry> entry : this.directories.entrySet()) {
                    PoolDirectoryEntry pde = (PoolDirectoryEntry)entry.getValue();
                    nameBytes = pde.name.getBytes(FileOperations.charsetUTF8);
                    dos.writeInt(nameBytes.length);
                    dos.write(nameBytes);
                    dos.writeLong(pde.lastmodified);
                    dos.writeInt((int)pde.files);
                    dos.writeInt((int)pde.subdirectories);
                }
            } else {
                dos.writeInt(0);
            }
            dos.close();
            result = baos.toByteArray();
        }
        catch (IOException e) {
            result = null;
        }
        return result;
    }

    public static final PoolList unpack(byte[] bytes) {
        ByteArrayWalker bb = ByteArrayWalker.wrap(bytes, ByteOrder.nativeOrder());
        try {
            byte[] data;
            int lenName;
            int l;
            byte[] data2;
            String dirlistFilename = null;
            String assetURLPath = null;
            int len = bb.getInt();
            if (len > 0) {
                data2 = new byte[len];
                bb.get(data2);
                dirlistFilename = new String(data2, FileOperations.charsetUTF8);
            }
            if ((len = bb.getInt()) > 0) {
                data2 = new byte[len];
                bb.get(data2);
                assetURLPath = new String(data2, FileOperations.charsetUTF8);
            }
            PoolList poolList = new PoolList(Paths.get(dirlistFilename, new String[0]), assetURLPath);
            poolList.version = bb.getShort();
            poolList.lastmodified = bb.getLong();
            poolList.chainIndex = bb.getInt();
            poolList.setSyncRequired(bb.get() == 1);
            len = bb.getInt();
            if (len > 0) {
                for (l = 0; l < len; ++l) {
                    PoolFileEntry pfe = new PoolFileEntry();
                    lenName = bb.getInt();
                    if (lenName > 0) {
                        data = new byte[lenName];
                        bb.get(data);
                        pfe.name = new String(data, FileOperations.charsetUTF8);
                    }
                    pfe.lastmodified = bb.getLong();
                    pfe.filesize = bb.getLong();
                    pfe.width = bb.getInt();
                    pfe.height = bb.getInt();
                    pfe.importStatus = bb.get();
                    poolList.addImageInitial(pfe);
                }
            }
            if ((len = bb.getInt()) > 0) {
                for (l = 0; l < len; ++l) {
                    PoolDirectoryEntry pfd = new PoolDirectoryEntry();
                    lenName = bb.getInt();
                    if (lenName > 0) {
                        data = new byte[lenName];
                        bb.get(data);
                        pfd.name = new String(data, FileOperations.charsetUTF8);
                    }
                    pfd.lastmodified = bb.getLong();
                    pfd.files = bb.getInt();
                    pfd.subdirectories = bb.getInt();
                    poolList.addDirectoryInitial(pfd);
                }
            }
            return poolList;
        }
        catch (BufferUnderflowException e) {
            return null;
        }
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.LIST;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PoolList: ");
        sb.append(this.assetURLPath);
        sb.append(" - Images: ");
        sb.append(this.images.size());
        sb.append(this.images.keySet());
        sb.append(" - Dirs: ");
        sb.append(this.directories.size());
        sb.append(" - Source: ");
        sb.append(this.dirlistFile);
        return sb.toString();
    }
}

