/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.utils.SPXParserUtils;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import java.nio.ByteOrder;

public class SPXMetaDataParser {
    public static ImageMetaData getFromSPXBytes(byte[] spxBytes, ByteOrder byteOrder) {
        ImageMetaData result = new ImageMetaData();
        ByteArrayWalker input = ByteArrayWalker.wrap(spxBytes, byteOrder);
        block17: while (input.remaining() > 0) {
            short tag = input.getShort();
            int tagContentLength = input.getInt();
            switch (tag) {
                case 2: {
                    result.setImportStatus((byte)input.getShort());
                    break;
                }
                case 11: {
                    result.setWidth(input.getInt());
                    break;
                }
                case 12: {
                    result.setHeight(input.getInt());
                    break;
                }
                case 14: {
                    String moduleName = SPXParserUtils.getTagContentAsString(input, tagContentLength);
                    result.setImportModuleName(moduleName);
                    break;
                }
                case 15: {
                    String moduleVersion = SPXParserUtils.getTagContentAsString(input, tagContentLength);
                    result.setImportModuleVersion(moduleVersion);
                    break;
                }
                case 16: {
                    result.setLastModified(input.getLong());
                    break;
                }
                case 17: {
                    result.setSourceFileSize(input.getLong());
                    break;
                }
                case 18: {
                    result.setImportTime(input.getLong());
                    break;
                }
                case 200: {
                    byte[] keyhook = SPXParserUtils.getTagContentAsByteArray(input, tagContentLength);
                    result.setKeyHook(keyhook);
                    break;
                }
                case 210: {
                    String iccname = SPXParserUtils.getTagContentAsString(input, tagContentLength);
                    ICCProfileWrap iccProfileWrap = new ICCProfileWrap(null);
                    iccProfileWrap.overwriteName(iccname);
                    result.setICC(iccProfileWrap);
                    break;
                }
                case 23: {
                    result.setImageReaderVersion(input.getInt());
                    break;
                }
                case 501: {
                    int levelCount = tagContentLength / 16;
                    Level[] levels = new Level[levelCount];
                    for (int l = 0; l < levelCount; ++l) {
                        Level level = new Level();
                        level.tileSizeX = input.getInt();
                        level.tileSizeY = input.getInt();
                        level.width = input.getInt();
                        level.height = input.getInt();
                        levels[l] = level;
                    }
                    result.setZoomLevels(levels);
                    break;
                }
                case 509: {
                    byte[] extraAlphaBytes = SPXParserUtils.getTagContentAsByteArray(input, tagContentLength);
                    result.setAlphaTypes(extraAlphaBytes);
                    for (byte b : extraAlphaBytes) {
                        if (b != 1) continue;
                        result.setHasAlpha(true);
                    }
                    continue block17;
                }
                case 508: {
                    result.setExtraAlphaCount(input.getInt());
                    break;
                }
                case 503: {
                    byte format = input.get();
                    if (format == 4 || format == 2) {
                        result.setHasAlpha(true);
                    }
                    result.setTileFormat(format);
                    break;
                }
                default: {
                    input.position(input.position() + tagContentLength);
                }
            }
        }
        return result;
    }
}

