/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;

public class SPXParserUtils {
    public static String getTagContentAsString(ByteArrayWalker input, int tagContentLength) {
        byte[] tagContent = new byte[tagContentLength];
        input.get(tagContent);
        String contentStr = new String(tagContent, FileOperations.charsetUTF8);
        return contentStr;
    }

    public static byte[] getTagContentAsByteArray(ByteArrayWalker input, int tagContentLength) {
        byte[] tagContent = new byte[tagContentLength];
        input.get(tagContent);
        return tagContent;
    }

    public static double[] getTagContentAsDoubleArray(ByteArrayWalker input, int tagContentLength) {
        double[] result = new double[tagContentLength / 8];
        for (int i = 0; i < result.length; ++i) {
            result[i] = input.getDouble();
        }
        return result;
    }

    public static float[] getTagContentAsFloatArray(ByteArrayWalker input, int tagContentLength) {
        float[] result = new float[tagContentLength / 4];
        for (int i = 0; i < result.length; ++i) {
            result[i] = input.getFloat();
        }
        return result;
    }
}

