/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.sourcemanager.storage.utils.TileCompression;
import com.neptunelabs.fsiserver.utils.SourceConnector;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.w3c.dom.Document;

public final class SourceConnectorReader {
    private final FSILogger logger;
    private final PathCached connectorFile;
    private final String name;
    private final Path webInfPath;
    private final Path tempPath;
    private final UserAuthenticationInterface authenticationInterface;
    private SourceConnector sourceConnectorDefinition;
    private boolean enabled = false;
    private SourceConnectorType mountType = SourceConnectorType.STORAGE;
    private boolean hasErrors = false;
    private String errorMessage = null;
    private PathCached inboxDirectory;
    private String headers;
    private String forceHeaders;
    private TileCompression tileCompression = TileCompression.JPEG;
    private int jpegQuality = 94;
    private final int tileSize = 384;
    private LevelQuality levelQuality = LevelQuality.NORMAL;
    private JPEGPreparation.ChromaSubsampling chromaSubsampling = JPEGPreparation.ChromaSubsampling.CS444;
    private boolean makeHistogram = true;
    private String comment = null;
    private String copyrigthNotice = null;
    private long lastModified = 0L;
    private final Map<Group, PermissionSet> accessPermissons = new HashMap<Group, PermissionSet>();
    private final Map<Group, String> accessProperties = new HashMap<Group, String>();
    private JPEGPreparation jpegPreparation;
    private boolean virtualViewerConnector = false;
    private String virtualConnectorUsername = null;
    private long currentImageCount = -1L;

    public SourceConnectorReader(FSILogger logger, String name, PathCached file, Path webInfPath, Path tempPath, UserAuthenticationInterface authenticationInterface) {
        this.name = name;
        this.logger = logger;
        this.webInfPath = webInfPath;
        this.tempPath = tempPath;
        this.connectorFile = file;
        this.authenticationInterface = authenticationInterface;
        try {
            this.readSourceConnectorFromFile();
        }
        catch (IOException ioe) {
            this.errorMessage = ioe.getLocalizedMessage();
            this.hasErrors = true;
        }
        float q = (float)(this.jpegQuality < 0 ? 0 : (this.jpegQuality > 100 ? 100 : this.jpegQuality)) / 100.0f;
        try {
            this.jpegPreparation = new JPEGPreparation(q, true, this.chromaSubsampling, null, null, 0, null, false);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
    }

    SourceConnectorReader(FSILogger logger, String name, String virtualConnectorUsername, PathCached inboxDirectory, UserAuthenticationInterface authenticationInterface, PermissionSet ps) {
        this.logger = logger;
        this.name = name;
        this.virtualViewerConnector = true;
        this.virtualConnectorUsername = virtualConnectorUsername;
        this.inboxDirectory = inboxDirectory;
        this.authenticationInterface = authenticationInterface;
        this.tempPath = null;
        this.webInfPath = null;
        this.connectorFile = null;
        this.jpegPreparation = null;
        this.mountType = SourceConnectorType.STATIC;
        this.enabled = true;
        this.accessPermissons.put(authenticationInterface.getGroups().get("public"), ps);
    }

    public boolean isVirtualViewerConnector() {
        return this.virtualViewerConnector;
    }

    public String getVirtualConnectorUsername() {
        return this.virtualConnectorUsername;
    }

    public PathCached getSourceConnectorFile() {
        return this.connectorFile;
    }

    public String getPrefix() {
        return this.name;
    }

    public TileCompression getTileFormat() {
        return this.tileCompression;
    }

    public int getTileSize() {
        return 384;
    }

    public LevelQuality getLevelQuality() {
        return this.levelQuality;
    }

    public boolean getMakeHistogram() {
        return this.makeHistogram;
    }

    public int getQuality() {
        return this.jpegQuality;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean hasError() {
        return this.hasErrors;
    }

    public String getErrorMessage() {
        return this.errorMessage != null ? this.errorMessage : "";
    }

    public long getHash() {
        return this.lastModified ^ (long)this.name.hashCode();
    }

    public long getLastModfied() {
        return this.lastModified;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public PathCached getInboxDirectory() {
        return this.inboxDirectory;
    }

    public String getHeadersName() {
        return this.headers;
    }

    public String getForceHeadersName() {
        return this.forceHeaders;
    }

    public SourceConnectorType getMountType() {
        return this.mountType;
    }

    public SourceConnector getSourceConnectorDefinition() {
        return this.sourceConnectorDefinition;
    }

    private void readSourceConnectorFromFile() throws IOException {
        Document doc = FileOperations.getXMLFileContent(this.logger, this.connectorFile.getPath());
        String xml = XMLOperations.elementNamesToLowerCase(this.logger, doc);
        this.sourceConnectorDefinition = XMLOperations.unmarshalJAXB(xml, SourceConnector.class);
        if (this.sourceConnectorDefinition.origin == null || this.sourceConnectorDefinition.conversion == null) {
            this.hasErrors = true;
        } else {
            this.enabled = this.sourceConnectorDefinition.enabled;
            if (this.sourceConnectorDefinition.comment != null) {
                this.comment = this.sourceConnectorDefinition.comment.trim();
            }
            if (this.sourceConnectorDefinition.type != null) {
                try {
                    this.mountType = SourceConnectorType.valueOf(this.sourceConnectorDefinition.type.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.hasErrors = true;
                    this.errorMessage = e.getLocalizedMessage();
                    this.logger.log(2501, this.name, "not using profile because of invalid type: " + this.sourceConnectorDefinition.type);
                }
            } else {
                this.mountType = SourceConnectorType.STORAGE;
            }
            this.headers = this.sourceConnectorDefinition.headers;
            this.forceHeaders = this.sourceConnectorDefinition.forceheaders;
            this.copyrigthNotice = this.sourceConnectorDefinition.copyrightnotice;
            if (!this.name.equals("_downloads")) {
                if (this.mountType != SourceConnectorType.STORAGEAPI && (this.sourceConnectorDefinition.origin.location == null || this.sourceConnectorDefinition.origin.location.trim().length() == 0)) {
                    this.hasErrors = true;
                    this.logger.log(2501, this.name, "not using source connector because of invalid location declaration: " + this.sourceConnectorDefinition.origin.location);
                } else if (this.mountType != SourceConnectorType.STORAGEAPI) {
                    Path tmp = this.getPathFromConnectorDefinition();
                    if (Files.isReadable(tmp)) {
                        this.inboxDirectory = new PathCached(tmp);
                    } else {
                        this.hasErrors = true;
                        this.logger.log(2501, this.name, "not using source connector because of inaccessible location: " + tmp);
                    }
                } else if (this.mountType == SourceConnectorType.STORAGEAPI) {
                    this.inboxDirectory = new PathCached(this.tempPath);
                }
                if (this.mountType == SourceConnectorType.STORAGE || this.mountType == SourceConnectorType.STORAGEAPI) {
                    if (this.sourceConnectorDefinition.conversion.format != null) {
                        try {
                            this.tileCompression = TileCompression.valueOf(this.sourceConnectorDefinition.conversion.format.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            this.hasErrors = true;
                            this.logger.log(2501, this.name, "not using source connector because of invalid conversion format: " + this.sourceConnectorDefinition.conversion.format.toUpperCase());
                        }
                    }
                    this.jpegQuality = this.sourceConnectorDefinition.conversion.quality;
                    if (this.jpegQuality < 0 || this.jpegQuality > 100) {
                        this.hasErrors = true;
                        this.logger.log(2501, this.name, "not using source connector because of quality value out of range: " + this.sourceConnectorDefinition.conversion.quality);
                    }
                    if (this.sourceConnectorDefinition.conversion.levelquality != null) {
                        try {
                            this.levelQuality = LevelQuality.valueOf(this.sourceConnectorDefinition.conversion.levelquality.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            this.hasErrors = true;
                            this.logger.log(2501, this.name, "not using profile because of invalid Level format: " + this.sourceConnectorDefinition.conversion.levelquality.toUpperCase());
                        }
                    }
                    if (this.sourceConnectorDefinition.conversion.chromasubsampling != null) {
                        String csRaw = this.sourceConnectorDefinition.conversion.chromasubsampling;
                        if (csRaw.equals("4:4:4")) {
                            this.chromaSubsampling = JPEGPreparation.ChromaSubsampling.CS444;
                        } else if (csRaw.equals("4:2:2")) {
                            this.chromaSubsampling = JPEGPreparation.ChromaSubsampling.CS422;
                        } else if (csRaw.equals("4:2:0")) {
                            this.chromaSubsampling = JPEGPreparation.ChromaSubsampling.CS420;
                        } else {
                            this.hasErrors = true;
                            this.logger.log(2501, this.name, "not using profile because of invalid ChromaSubsampling format: " + this.sourceConnectorDefinition.conversion.chromasubsampling);
                        }
                    }
                    this.makeHistogram = this.sourceConnectorDefinition.conversion.histogram;
                }
            }
            if (this.sourceConnectorDefinition.access == null) {
                this.addDefaultPermissions();
            } else {
                for (SourceConnector.GroupEntry ge : this.sourceConnectorDefinition.access.groupEntries) {
                    boolean validGroup = this.authenticationInterface.getGroups().containsKey(ge.groupname);
                    if (!validGroup) continue;
                    if (this.authenticationInterface.getPermissionSets().containsKey(ge.permissionset)) {
                        this.accessPermissons.put(this.authenticationInterface.getGroups().get(ge.groupname), this.authenticationInterface.getPermissionSets().get(ge.permissionset));
                    }
                    if (ge.propertyset == null) continue;
                    if (this.authenticationInterface.getPropertySets().containsKey(ge.propertyset)) {
                        this.accessProperties.put(this.authenticationInterface.getGroups().get(ge.groupname), ge.propertyset);
                        continue;
                    }
                    System.err.println("Unknown propertyset " + ge.propertyset + " referenced in Source Connector " + this.name);
                }
            }
        }
        if (this.hasErrors) {
            this.enabled = false;
        }
        if (this.enabled) {
            this.lastModified = Files.getLastModifiedTime(this.connectorFile.getPath(), new LinkOption[0]).toMillis();
        }
    }

    private Path getPathFromConnectorDefinition() {
        Path tmp = Paths.get(this.sourceConnectorDefinition.origin.location, new String[0]);
        tmp = !tmp.isAbsolute() ? this.webInfPath.resolve(this.sourceConnectorDefinition.origin.location) : Paths.get(this.sourceConnectorDefinition.origin.location, new String[0]);
        return tmp;
    }

    private void addDefaultPermissions() {
        this.logger.log(2034, this.name);
        this.sourceConnectorDefinition.access = new SourceConnector.AccessType();
        this.sourceConnectorDefinition.access.groupEntries = new ArrayList<SourceConnector.GroupEntry>();
        SourceConnector.GroupEntry ge1 = new SourceConnector.GroupEntry();
        ge1.groupname = "public";
        ge1.permissionset = "public";
        this.sourceConnectorDefinition.access.groupEntries.add(ge1);
        SourceConnector.GroupEntry ge2 = new SourceConnector.GroupEntry();
        ge2.groupname = "users";
        ge2.permissionset = "rw";
        this.sourceConnectorDefinition.access.groupEntries.add(ge2);
        this.accessPermissons.put(this.authenticationInterface.getGroups().get("public"), this.authenticationInterface.getPermissionSets().get("public"));
        this.accessPermissons.put(this.authenticationInterface.getGroups().get("authenticated"), this.authenticationInterface.getPermissionSets().get("rw"));
    }

    public Map<Group, PermissionSet> getAccessPermissions() {
        return this.accessPermissons;
    }

    public Map<Group, String> getAccessProperties() {
        return this.accessProperties;
    }

    public long getCurrentImageCount() {
        return this.currentImageCount;
    }

    public void setCurrentImageCount(long currentImageCount) {
        this.currentImageCount = currentImageCount;
    }

    public JPEGPreparation getJPEGPreparation() {
        return this.jpegPreparation;
    }

    public PathCached getSourceFileFromAssetURLPath(String assetURLPath) {
        StringTokenizer st = new StringTokenizer(assetURLPath, "/");
        int slashCount = st.countTokens();
        if (slashCount > 1) {
            StringBuilder sb = new StringBuilder();
            st.nextElement();
            int count = 0;
            while (st.hasMoreTokens()) {
                String e = (String)st.nextElement();
                if (e.equals("") || e.equals(".")) continue;
                if (e.equals("..")) {
                    throw new WebApplicationException(Response.Status.FORBIDDEN);
                }
                sb.append(e);
                if (++count >= slashCount) continue;
                sb.append(File.separatorChar);
            }
            return new PathCached(this.getInboxDirectory().resolve(sb.toString()));
        }
        if (slashCount == 1 && !assetURLPath.equals("/..")) {
            return this.getInboxDirectory();
        }
        return null;
    }

    public boolean equals(Object other) {
        SourceConnectorReader otherConnector;
        return other instanceof SourceConnectorReader && this.inboxDirectory.equals((otherConnector = (SourceConnectorReader)other).getInboxDirectory()) && this.name.equals(otherConnector.getPrefix());
    }

    public int hashCode() {
        return this.inboxDirectory.hashCode() ^ this.name.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getCanonicalName());
        sb.append("Name:" + this.name);
        sb.append(' ');
        sb.append("Type:" + (Object)((Object)this.mountType));
        return sb.toString();
    }

    public final String getComment() {
        return this.comment;
    }

    public final String getImageCopyright() {
        return this.copyrigthNotice;
    }

    public static enum LevelQuality {
        ULTRA,
        HIGH,
        NORMAL;

    }

    public static enum SourceConnectorType {
        STORAGE,
        STORAGEAPI,
        MULTIRESOLUTION,
        STATIC;

    }
}

