/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;

public final class StorageHelperV1001 {
    private static final int currentPoolVersion = 1001;
    private static final String versionPrefix = 'V' + Integer.toString(1001) + '/';

    private StorageHelperV1001() {
    }

    public static String getVersionPrefix() {
        return versionPrefix;
    }

    public static String getStoragePrefix(String assetURLPath) {
        int hash;
        String ss1;
        int ss1len;
        int hashcode;
        if (!(assetURLPath = assetURLPath.replace(File.separator, "/")).startsWith("/")) {
            assetURLPath = '/' + assetURLPath;
        }
        if ((hashcode = assetURLPath.hashCode()) == Integer.MIN_VALUE) {
            ++hashcode;
        }
        if ((ss1len = (ss1 = Integer.toString(hash = Math.abs(hashcode), 36)).length()) < 4) {
            ss1 = String.format("%0" + (4 - ss1len) + "d", 0) + ss1;
            ss1len = 4;
        }
        StringBuilder result = new StringBuilder();
        result.append(ss1.substring(ss1len - 1));
        if (ss1len >= 4) {
            result.append(ss1.substring(ss1len - 2, ss1len - 1));
            result.append('/');
            result.append(ss1.substring(ss1len - 3, ss1len - 2));
            result.append(ss1.substring(ss1len - 4, ss1len - 3));
        } else {
            result.append("0/0");
            result.append(ss1.substring(ss1len - 2, ss1len - 1));
        }
        String resultstr = versionPrefix + result.toString() + "/";
        return resultstr;
    }

    public static boolean isStorageDirectory(Path storageLocation, String assetURLPath) {
        Path f = storageLocation.resolve(StorageHelperV1001.getStoragePrefix(assetURLPath)).resolve(assetURLPath + "dirlist");
        return Files.exists(f, new LinkOption[0]);
    }
}

