/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.concurrent.LockerReadWrite;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiframework.security.BytesToAscii36;
import com.neptunelabs.fsiframework.security.HexConverter;
import com.neptunelabs.fsiframework.security.Sha160;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISChainReader;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.NotAValidEISFileException;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageManager;
import com.neptunelabs.fsiserver.utils.EISEnvironment;
import com.neptunelabs.fsiserver.utils.FileLockHandler;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import java.util.zip.CRC32;

public final class StorageHelperV1002 {
    private static final Charset hasherCharset = Charset.forName("UTF-16LE");
    private final Hasher hasher;
    private static final int currentPoolVersion = 1002;
    private static final String versionPrefix = 'V' + Integer.toString(1002);
    private static final String metricsSubDir = ".metrics";
    private static final String trashSubDir = ".trash";
    private static final String downloadSubDir = ".downloads";
    private static final String rootSubDir = ".root";
    private static final String viewerSubDir = "_viewer";
    private final Path storageLocation;
    private String storageID = null;
    private String storageKey = null;

    public StorageHelperV1002(Hasher hasher, Path storageLocation) {
        this.hasher = hasher;
        this.storageLocation = storageLocation;
    }

    public static String getVersionPrefix() {
        return versionPrefix;
    }

    public Path getMetricsDir() throws NotConfiguredException {
        if (this.storageLocation == null) {
            throw new NotConfiguredException("StorageHelper not configured.");
        }
        return this.storageLocation.resolve(metricsSubDir);
    }

    public Path getProfileStorageBase(String profileName) throws NotConfiguredException {
        if (this.storageLocation == null) {
            throw new NotConfiguredException("StorageHelper not configured.");
        }
        if (profileName == null || profileName.length() == 0) {
            throw new IllegalArgumentException();
        }
        return this.storageLocation.resolve(versionPrefix).resolve(profileName);
    }

    public Path getTrashFolder(SourceConnectorReader sourceConnector) throws NotConfiguredException {
        if (sourceConnector.isVirtualViewerConnector()) {
            if (this.storageLocation == null) {
                throw new NotConfiguredException("StorageHelper not configured.");
            }
            return this.storageLocation.resolve(versionPrefix).resolve(viewerSubDir).resolve(sourceConnector.getVirtualConnectorUsername());
        }
        return this.getProfileStorageBase(sourceConnector.getPrefix()).resolve(trashSubDir);
    }

    public Path getDownloadsFolder() throws NotConfiguredException {
        if (this.storageLocation == null) {
            throw new NotConfiguredException("StorageHelper not configured.");
        }
        return this.storageLocation.resolve(downloadSubDir);
    }

    public Path getEisFile(String assetURLPathIn) throws NotConfiguredException {
        if (this.storageLocation == null) {
            throw new NotConfiguredException("StorageHelper not configured.");
        }
        String assetURLPath = StorageHelperV1002.cleanAssetURLPath(assetURLPathIn);
        if (assetURLPath.length() == 0) {
            throw new IllegalArgumentException();
        }
        String[] splitSource = StorageHelperV1002.splitAssetURLPath(assetURLPath);
        String hash = this.calculateStorageHash("/" + splitSource[1]);
        return this.storageLocation.resolve(versionPrefix).resolve(splitSource[0]).resolve("i" + hash.charAt(0)).resolve(hash.substring(1, 3)).resolve("e" + hash.substring(3) + ".eis");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Path getRealEisFile(String assetURLPath, FileLockHandler fileLockHandler) throws NotConfiguredException, NoSuchFileException, NotAValidEISFileException, IOException {
        Path eisFile = this.getEisFile(assetURLPath);
        LockerReadWrite.Value<String> eisLock = fileLockHandler.readLock(eisFile.toString());
        try (ReaderChannel draf = new ReaderChannel(eisFile, StandardOpenOption.READ);){
            byte[] magic = new byte[8];
            draf.read(magic);
            if (Arrays.equals(magic, EISEnvironment.EIS_CHAIN_MAGIC)) {
                int foundChainNumber = EISChainReader.findChainEntryNumber(draf, assetURLPath);
                draf.close();
                if (foundChainNumber == -1) {
                    throw new NoSuchFileException("No such entry for " + assetURLPath + " in chain");
                }
                eisFile = StorageManager.getChainedDestination(eisFile, foundChainNumber);
            }
        }
        finally {
            fileLockHandler.unlockRead(eisLock);
        }
        return eisFile;
    }

    public Path getDirectoryFile(String assetURLPath) throws NotConfiguredException {
        if (this.storageLocation == null) {
            throw new NotConfiguredException("StorageHelper not configured.");
        }
        if ((assetURLPath = StorageHelperV1002.cleanAssetURLPath(assetURLPath)).length() == 0) {
            return this.storageLocation.resolve(rootSubDir).resolve("root.dir");
        }
        String[] splitSource = StorageHelperV1002.splitAssetURLPath(assetURLPath);
        String hash = this.calculateStorageHash("/" + splitSource[1]);
        return this.storageLocation.resolve(versionPrefix).resolve(splitSource[0]).resolve("d" + hash.charAt(0)).resolve(hash.substring(1, 3)).resolve("d" + hash.substring(3) + ".dir");
    }

    public String calculateTrashFileHash(String assetURLPath) {
        String hash = this.calculateStorageHash(assetURLPath);
        return hash.charAt(0) + "/" + hash.substring(1, 2) + "/t" + hash.substring(3);
    }

    public static String[] splitAssetURLPath(String assetURLPath) {
        assetURLPath = StorageHelperV1002.cleanAssetURLPath(assetURLPath);
        String[] parts = new String[2];
        int slashPos = assetURLPath.indexOf(47);
        if (slashPos >= 0) {
            parts[0] = assetURLPath.substring(0, slashPos);
            parts[1] = assetURLPath.substring(slashPos + 1);
        } else {
            parts[0] = assetURLPath;
            parts[1] = "";
        }
        return parts;
    }

    public boolean isStorageDirectory(String assetURLPath) throws NotConfiguredException {
        if (!(assetURLPath = FileOperations.convertBackslash(assetURLPath)).endsWith("/")) {
            assetURLPath = assetURLPath + '/';
        }
        return Files.exists(this.getDirectoryFile(assetURLPath), new LinkOption[0]);
    }

    public static String cleanAssetURLPath(String assetURLPath) {
        String result = FileOperations.convertBackslash(assetURLPath);
        result = FileOperations.trim(result, '/');
        return result;
    }

    private String calculateStorageHash(String filename) {
        byte[] digest;
        if (this.hasher == Hasher.CRC32) {
            CRC32 crc = new CRC32();
            crc.update(filename.getBytes(hasherCharset));
            int h = (int)crc.getValue();
            digest = new byte[4];
            for (int c = 0; c < 4; ++c) {
                digest[c] = (byte)(h >> c * 8 & 0xFF);
            }
        } else if (this.hasher == Hasher.HASH32) {
            int h = filename.hashCode();
            digest = new byte[4];
            for (int c = 0; c < 4; ++c) {
                digest[c] = (byte)(h >> c * 8 & 0xFF);
            }
        } else if (this.hasher == Hasher.SHA160) {
            Sha160 algorithm = new Sha160();
            digest = algorithm.digest(filename.getBytes(hasherCharset));
        } else if (this.hasher == Hasher.HASHCRASH) {
            int value = filename.hashCode();
            digest = new byte[]{(byte)(value >>> 24 & 5), (byte)(value >>> 16 & 5), (byte)(value >>> 8 & 5), (byte)(value & 5)};
        } else {
            digest = null;
        }
        return BytesToAscii36.encode(digest);
    }

    public String getStorageID() {
        return this.storageID;
    }

    public String getStorageKey() {
        return this.storageKey;
    }

    public void evaluateStorageID() throws IOException {
        int lineNumber = 0;
        String storageIDFile = null;
        String storageKeyFile = null;
        try (BufferedReader br = Files.newBufferedReader(this.storageLocation.resolve(".FSIServerStorage"), FileOperations.charsetUTF8);){
            String line;
            while ((line = br.readLine()) != null) {
                if (lineNumber == 0) {
                    storageIDFile = line.trim();
                } else {
                    if (lineNumber != true) break;
                    storageKeyFile = line.trim();
                }
                ++lineNumber;
            }
        }
        if (storageIDFile != null && storageKeyFile != null) {
            byte[] hashBytes = HexConverter.hexStringToByteArray(storageIDFile);
            byte[] keyBytes = HexConverter.hexStringToByteArray(storageKeyFile);
            if (hashBytes != null && keyBytes != null) {
                int len2 = keyBytes.length / 2;
                CRC32 crc = new CRC32();
                crc.update(keyBytes, 0, len2);
                int crc1 = (int)crc.getValue();
                crc.reset();
                crc.update(keyBytes, len2, len2);
                int crc2 = (int)crc.getValue();
                String storageHashCheck = String.format("%04X", crc1) + String.format("%04X", crc2);
                if (storageIDFile.equals(storageHashCheck)) {
                    this.storageID = storageIDFile;
                    this.storageKey = storageKeyFile;
                }
            }
        }
    }

    public boolean setupStorageID() throws IOException {
        Path storageIdFile = this.storageLocation.resolve(".FSIServerStorage");
        Path storageIdFilePrepare = this.storageLocation.resolve(".FSIServerStorage.Prepare");
        boolean writeNewFile = false;
        int count = 5;
        while (count-- > 0 && Files.notExists(storageIdFile, new LinkOption[0])) {
            if (Files.exists(storageIdFilePrepare, new LinkOption[0])) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            writeNewFile = true;
            break;
        }
        if (Files.exists(storageIdFile, new LinkOption[0])) {
            try {
                this.evaluateStorageID();
                if (this.storageID == null) {
                    writeNewFile = true;
                }
            }
            catch (IOException e) {
                writeNewFile = true;
            }
        }
        if (writeNewFile) {
            Path parent = storageIdFilePrepare.getParent();
            if (Files.notExists(parent, new LinkOption[0])) {
                Files.createDirectories(parent, new FileAttribute[0]);
                Files.createFile(storageIdFilePrepare, new FileAttribute[0]);
            }
            Random rand = new Random();
            byte[] keyBytes = new byte[64];
            int len2 = keyBytes.length / 2;
            rand.nextBytes(keyBytes);
            CRC32 crc = new CRC32();
            crc.update(keyBytes, 0, len2);
            int crc1 = (int)crc.getValue();
            crc.reset();
            crc.update(keyBytes, len2, len2);
            int crc2 = (int)crc.getValue();
            this.storageID = String.format("%04X", crc1) + String.format("%04X", crc2);
            this.storageKey = HexConverter.byteArrayToHexString(keyBytes);
            StringBuilder sb = new StringBuilder();
            sb.append(this.storageID);
            sb.append(FileOperations.getNewLine());
            sb.append(this.storageKey);
            String storageText = sb.toString();
            FileOperations.writeFile(storageIdFilePrepare, storageText.getBytes(FileOperations.charsetUTF8));
            FileOperations.move(storageIdFilePrepare, storageIdFile);
        }
        return true;
    }

    public static enum Hasher {
        HASH32,
        CRC32,
        SHA160,
        HASHCRASH;

    }
}

