/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiservletframework.settings.ServletXMLSettings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Random;

public class StorageMetrics {
    private final Random random;
    private final Path metricsfile;
    private long images = 0L;
    private long totalSize = 0L;
    private boolean imagesCounted = false;
    private long lastReadModified = 0L;
    private final ServletXMLSettings settings;

    public StorageMetrics(SourceManagerSettings settings, Path metricsfile) {
        this.metricsfile = metricsfile;
        this.random = new Random();
        this.settings = settings;
        this.readFromFile();
    }

    public void setValues(long images, long totalSize) {
        this.images = images;
        this.totalSize = totalSize;
        this.imagesCounted = true;
    }

    public boolean saveToFile() {
        long licenceLongHash = this.settings.getLicence().getLongHash();
        boolean result = false;
        if (this.imagesCounted) {
            long master1 = this.nextMinimumLong(238930234092340984L);
            long master2 = this.nextMinimumLong(234923498778723483L);
            long imagesHashed = this.images ^ licenceLongHash ^ master1;
            long imagesHashedChkSum = imagesHashed ^ master1 ^ 0x916FBC58AE797EDL;
            long totalSizeHashed = this.totalSize ^ licenceLongHash ^ master2;
            long totalSizeHashedChkSum = totalSizeHashed ^ master2 ^ 0x1B82C035D431B89L;
            StringBuilder metricsStr = new StringBuilder();
            metricsStr.append(String.format("%02X", 1));
            metricsStr.append(String.format("%016X", master1));
            metricsStr.append(String.format("%016X", master2));
            metricsStr.append('\n');
            metricsStr.append(String.format("%02X", 2));
            metricsStr.append(String.format("%016X", imagesHashed));
            metricsStr.append(String.format("%016X", imagesHashedChkSum));
            metricsStr.append('\n');
            metricsStr.append(String.format("%02X", 3));
            metricsStr.append(String.format("%016X", totalSizeHashed));
            metricsStr.append(String.format("%016X", totalSizeHashedChkSum));
            result = FileOperations.writeTextFileContent(this.settings.getFSILogger(), this.metricsfile, metricsStr.toString(), FileOperations.charsetUTF8);
        }
        return result;
    }

    private void readFromFile() {
        long licenceLongHash = this.settings.getLicence().getLongHash();
        long lmMetricsFile = FileOperations.getSafeLastModified(this.metricsfile);
        if (Files.exists(this.metricsfile, new LinkOption[0]) && lmMetricsFile != this.lastReadModified) {
            long imageCount = -1L;
            long imageSize = -1L;
            try {
                String line;
                String metricsRaw = FileOperations.getTextFileContent(this.metricsfile, FileOperations.charsetUTF8);
                StringReader sr = new StringReader(metricsRaw);
                BufferedReader br = new BufferedReader(sr);
                long random1 = 0L;
                long random2 = 0L;
                while ((line = br.readLine()) != null) {
                    if (line.length() != 34) continue;
                    try {
                        long check;
                        long ic1;
                        int marker = Integer.valueOf(line.substring(0, 2), 16);
                        long valueRaw = Long.valueOf(line.substring(2, 18), 16);
                        long hashRaw = Long.valueOf(line.substring(18, 34), 16);
                        if (marker == 1) {
                            random1 = valueRaw;
                            random2 = hashRaw;
                            continue;
                        }
                        if (marker == 2) {
                            ic1 = valueRaw ^ licenceLongHash ^ random1;
                            check = valueRaw ^ random1 ^ 0x916FBC58AE797EDL;
                            if (check != hashRaw) continue;
                            imageCount = ic1;
                            continue;
                        }
                        if (marker != 3) continue;
                        ic1 = valueRaw ^ licenceLongHash ^ random2;
                        check = valueRaw ^ random2 ^ 0x1B82C035D431B89L;
                        if (check != hashRaw) continue;
                        imageSize = ic1;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
            catch (IOException e) {
                this.settings.getFSILogger().log(3184, this.metricsfile, e.getLocalizedMessage());
            }
            this.lastReadModified = lmMetricsFile;
            this.images = imageCount;
            this.totalSize = imageSize;
            this.imagesCounted = true;
        }
    }

    private long nextMinimumLong(long minimumValue) {
        long result = 0L;
        while (result < minimumValue) {
            result = this.random.nextLong();
        }
        return result;
    }
}

