/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.io.FileEventCursor;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiframework.security.DigestUtils;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.Groups;
import com.neptunelabs.fsiserver.authentication.PermissionSet;
import com.neptunelabs.fsiserver.authentication.PropertySet;
import com.neptunelabs.fsiserver.authentication.PublishingSet;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.mbeans.SystemMonitor;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.sourcemanager.small.FSIKerberosConfig;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.StorageLogger;
import com.neptunelabs.fsiserver.utils.Defines;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.SourceConnectorReader;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiservletframework.utils.ServletFileEventCursor;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.w3c.dom.Document;

public abstract class UserAuthenticationInterface {
    public final FSIServerSettings settings;
    public final StorageHelperV1002 storageHelper;
    private final Map<String, String> activeSessions = new HashMap<String, String>();
    public static Lock permissionLock = new ReentrantLock();
    public final Set<Users.User> users = new HashSet<Users.User>();
    public final Map<String, Group> groups = new HashMap<String, Group>();
    public final Map<String, PermissionSet> permissionSets = new HashMap<String, PermissionSet>();
    public final Map<String, PropertySet> propertySets = new HashMap<String, PropertySet>();
    public final Map<String, PublishingSet> publishingSets = new HashMap<String, PublishingSet>();
    public final Map<String, PermissionSet> rawPermissionSets = new HashMap<String, PermissionSet>();
    public PermissionSet globalPermissions = null;
    public PropertySet globalProperties = null;
    protected Path permissionsetsDirectory;
    protected Path propertySetsDirectory;
    protected Path publishingSetsDirectory;
    protected final List<FileEventCursor.RegisteredPath> fileMonitorTasks = new ArrayList<FileEventCursor.RegisteredPath>();
    private static final PermissionSet trashPermissions = PermissionSet.getAllForbiddenPermissionsClone();
    private static final PermissionSet configsPermissions = PermissionSet.getAllForbiddenPermissionsClone();
    private final Map<String, Map<String, PermissionSet>> userConnectorPermissions;
    private final Map<String, Map<String, PropertySet>> userConnectorProperties;
    private final Map<String, Map<String, PublishingSet>> userPublishingSets;
    private boolean useKerberosAuthentication;
    private Configuration krbConfig;

    public UserAuthenticationInterface(FSIServerSettings settings) {
        UserAuthenticationInterface.trashPermissions.read.basicMetadata = true;
        UserAuthenticationInterface.trashPermissions.read.renderedImages = true;
        UserAuthenticationInterface.trashPermissions.read.files = true;
        UserAuthenticationInterface.trashPermissions.list.files = true;
        UserAuthenticationInterface.trashPermissions.write.delete = true;
        UserAuthenticationInterface.configsPermissions.read.basicMetadata = true;
        UserAuthenticationInterface.configsPermissions.read.renderedImages = true;
        UserAuthenticationInterface.configsPermissions.read.files = true;
        UserAuthenticationInterface.configsPermissions.list.files = true;
        UserAuthenticationInterface.configsPermissions.list.directories = true;
        this.userConnectorPermissions = new HashMap<String, Map<String, PermissionSet>>();
        this.userConnectorProperties = new HashMap<String, Map<String, PropertySet>>();
        this.userPublishingSets = new HashMap<String, Map<String, PublishingSet>>();
        this.useKerberosAuthentication = false;
        this.settings = settings;
        this.storageHelper = settings.getStorageHelper();
        this.useKerberosAuthentication = settings.getPrefsBoolean("application", "usekrb");
        if (this.useKerberosAuthentication) {
            this.krbConfig = new FSIKerberosConfig(settings.getPrefsBoolean("application", "krbdebug"));
        }
    }

    protected void setupMonitoring(String callbackMethod, Path[] files, Path[] directories) {
        ServletFileEventCursor fileEventCursor = this.settings.getServletFileEventCursor();
        FileEventCallback monitorCallback = new FileEventCallback(this, callbackMethod, null);
        ArrayList<FileEventCallback> cL = new ArrayList<FileEventCallback>();
        cL.add(monitorCallback);
        if (files != null && files.length > 0) {
            for (Path f : files) {
                try {
                    this.fileMonitorTasks.add(fileEventCursor.addPathMonitor(f, cL));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (directories != null && directories.length > 0) {
            for (Path d : directories) {
                try {
                    this.fileMonitorTasks.add(fileEventCursor.addPathMonitor(d, null, false, cL));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean isPasswordChangePossible() {
        return !this.useKerberosAuthentication;
    }

    public abstract boolean isUserModificationPossible();

    public void readPermissionConfig() {
        try {
            permissionLock.lock();
            this.settings.getFSILogger().log(2047, new Object[0]);
            this.readPermissionSets();
            this.readUsers();
            this.readGroups();
            SystemMonitor sysmon = this.settings.getSystemMonitor();
            if (sysmon != null) {
                this.settings.getSystemMonitor().setGroupCount(this.getGroupCount());
            }
        }
        finally {
            permissionLock.unlock();
        }
    }

    public void readPropertyConfig() {
        this.readPublishingSets();
        boolean changeDetected = this.readPropertySets();
        if (changeDetected && ((SourceManagerSettings)this.settings).getStorageManager() != null) {
            ((SourceManagerSettings)this.settings).getStorageManager().getStorageLogger().log('D', StorageLogger.LogCMD.U, "/");
        }
    }

    public PropertySet getProperties(SourceConnectorReader connector, HttpSession session) {
        String sessionid;
        PropertySet result = new PropertySet();
        this.mergePropertiesOverwriteIfNotProtected(result, this.globalProperties);
        if (session != null && this.validateSession(sessionid = (String)session.getAttribute("id")) == SessionStatus.VALID) {
            Map<String, PropertySet> connectorProperties;
            String username = this.getUser(sessionid);
            Users.User u = this.getUserByName(username);
            this.mergePropertiesOverwriteIfNotProtected(result, this.propertySets.get(u.propertySet));
            PropertySet groupProperties = new PropertySet();
            for (Group g : this.getGroupsForUser(username)) {
                groupProperties = this.mergePropertiesEqually(groupProperties, this.propertySets.get(g.getPropertySet()));
            }
            this.mergePropertiesOverwriteIfNotProtected(result, groupProperties);
            if (connector != null && (connectorProperties = this.userConnectorProperties.get(username)) != null) {
                this.mergePropertiesOverwriteIfNotProtected(result, connectorProperties.get(connector.getPrefix()));
            }
        }
        return result;
    }

    public Map<String, PublishingSet> getUserPublishingSets(HttpSession session) {
        String username = this.getUser((String)session.getAttribute("id"));
        return this.userPublishingSets.get(username);
    }

    public List<PublishingSet> getAllUserPublishingSets() {
        ArrayList<PublishingSet> result = new ArrayList<PublishingSet>();
        for (Map<String, PublishingSet> entry : this.userPublishingSets.values()) {
            for (PublishingSet ps : entry.values()) {
                result.add(ps);
            }
        }
        return result;
    }

    public PermissionSet getPermissions(String assetURLPath, HttpSession session, boolean fullSet) throws NotConfiguredException {
        if (assetURLPath.equals("_trash")) {
            if (session != null) {
                return trashPermissions;
            }
            return PermissionSet.getAllForbiddenPermissionSet();
        }
        if (assetURLPath.startsWith("_configs") || assetURLPath.startsWith("_viewers")) {
            return configsPermissions;
        }
        SourceConnectorReader connector = this.settings.getSourceConnectorFromAssetURLPath(assetURLPath, session);
        return this.getPermissions(connector, session, fullSet);
    }

    public PermissionSet getPermissions(SourceConnectorReader connector, HttpSession session, boolean fullSet) {
        String sessionid;
        PermissionSet result = new PermissionSet();
        this.mergePermissionsIfNotSet(result, this.globalPermissions);
        if (session != null && this.validateSession(sessionid = (String)session.getAttribute("id")) == SessionStatus.VALID) {
            String username = this.getUser(sessionid);
            Users.User u = this.getUserByName(username);
            this.mergePermissionsIfNotSet(result, this.permissionSets.get(u.permissionSet));
            PermissionSet groupPermissions = new PermissionSet();
            for (Group g : this.getGroupsForUser(username)) {
                this.mergePermissionsIfTrue(groupPermissions, this.permissionSets.get(g.getPermissionSet()));
            }
            this.mergePermissionsIfNotSet(result, groupPermissions);
            if (connector != null) {
                Map<String, PermissionSet> connectorPerms = this.userConnectorPermissions.get(username);
                if (connectorPerms != null) {
                    this.mergePermissionsIfNotSet(result, connectorPerms.get(connector.getPrefix()));
                }
            } else {
                if (result.read.renderedImages == null) {
                    result.read.renderedImages = true;
                }
                if (result.read.basicMetadata == null) {
                    result.read.basicMetadata = true;
                }
            }
        }
        PermissionSet publicPermissions = new PermissionSet();
        this.mergePermissionsIfNotSet(publicPermissions, this.permissionSets.get("public"));
        if (connector != null) {
            PermissionSet publicConnectorPerms = null;
            for (Map.Entry<Group, PermissionSet> entry : connector.getAccessPermissions().entrySet()) {
                if (!entry.getKey().equals(this.groups.get("public"))) continue;
                publicConnectorPerms = entry.getValue();
                break;
            }
            this.mergePermissionsIfNotSet(publicPermissions, publicConnectorPerms);
        } else {
            if (result.read.renderedImages == null) {
                result.read.renderedImages = true;
            }
            if (result.read.basicMetadata == null) {
                result.read.basicMetadata = true;
            }
        }
        this.mergePermissionsIfTrue(result, publicPermissions);
        if (result.isEmpty()) {
            if (fullSet) {
                return PermissionSet.getAllForbiddenPermissionSet();
            }
            return null;
        }
        if (fullSet) {
            this.mergePermissionsIfNotSet(result, PermissionSet.getAllForbiddenPermissionSet());
        }
        return result;
    }

    private Set<Group> getGroupsForUser(String username) {
        HashSet<Group> result = new HashSet<Group>();
        for (Group g : this.groups.values()) {
            if (!g.containsUser(username)) continue;
            result.add(g);
        }
        return result;
    }

    public Set<String> getGroupNamesForUser(String username) {
        HashSet<String> result = new HashSet<String>();
        for (Group group : this.groups.values()) {
            if (!group.containsUser(username)) continue;
            result.add(group.getName());
        }
        return result;
    }

    private PropertySet mergePropertiesEqually(PropertySet set1, PropertySet set2) {
        if (set1 == null && set2 == null) {
            return null;
        }
        if (set1 == null) {
            return set2;
        }
        if (set2 == null) {
            return set1;
        }
        PropertySet result = new PropertySet();
        result.general = this.mergePropertyItemListEqually(set1.general, set2.general);
        result.custommetadatafields = this.mergePropertyItemListEqually(set1.custommetadatafields, set2.custommetadatafields);
        result.publishingsets = this.mergePropertyItemListEqually(set1.publishingsets, set2.publishingsets);
        result.hideApps = this.mergePropertyItemListEqually(set1.hideApps, set2.hideApps);
        result.hidePublishingTabs = this.mergePropertyItemListEqually(set1.hidePublishingTabs, set2.hidePublishingTabs);
        result.custom = this.mergePropertyItemListEqually(set1.custom, set2.custom);
        return result;
    }

    private List<PropertySet.ItemType> mergePropertyItemListEqually(List<PropertySet.ItemType> list1, List<PropertySet.ItemType> list2) {
        HashMap<String, PropertySet.ItemType> resultMap = new HashMap<String, PropertySet.ItemType>();
        for (PropertySet.ItemType item : list1) {
            resultMap.put(item.name, item);
        }
        for (PropertySet.ItemType item : list2) {
            PropertySet.ItemType existingItem = (PropertySet.ItemType)resultMap.get(item.name);
            if (existingItem == null) {
                resultMap.put(item.name, item);
                continue;
            }
            if (existingItem.isProtected && item.isProtected || !existingItem.isProtected && !item.isProtected) {
                if (!item.value) continue;
                existingItem.value = true;
                continue;
            }
            if (existingItem.isProtected) continue;
            resultMap.put(item.name, item);
        }
        return new ArrayList<PropertySet.ItemType>(resultMap.values());
    }

    private void mergePropertiesOverwriteIfNotProtected(PropertySet work, PropertySet merge) {
        if (merge == null) {
            return;
        }
        this.mergePropertyItemListOverwriteIfNotProtected(work.general, merge.general);
        this.mergePropertyItemListOverwriteIfNotProtected(work.custommetadatafields, merge.custommetadatafields);
        this.mergePropertyItemListOverwriteIfNotProtected(work.hideApps, merge.hideApps);
        this.mergePropertyItemListOverwriteIfNotProtected(work.hidePublishingTabs, merge.hidePublishingTabs);
        this.mergePropertyItemListOverwriteIfNotProtected(work.publishingsets, merge.publishingsets);
        this.mergePropertyItemListOverwriteIfNotProtected(work.custom, merge.custom);
    }

    private void mergePropertyItemListOverwriteIfNotProtected(List<PropertySet.ItemType> work, List<PropertySet.ItemType> merge) {
        for (PropertySet.ItemType item : merge) {
            PropertySet.ItemType foundItem = null;
            for (PropertySet.ItemType i : work) {
                if (!i.name.equals(item.name)) continue;
                foundItem = i;
                break;
            }
            if (foundItem == null) {
                work.add(item);
                continue;
            }
            if (foundItem.isProtected) continue;
            work.remove(foundItem);
            work.add(item);
        }
    }

    private void mergePermissionsIfTrue(PermissionSet work, PermissionSet merge) {
        if (merge == null) {
            return;
        }
        if (merge.general.readLicence != null && merge.general.readLicence.booleanValue()) {
            work.general.readLicence = true;
        }
        if (merge.general.writeLicence != null && merge.general.writeLicence.booleanValue()) {
            work.general.writeLicence = true;
        }
        if (merge.general.changePassword != null && merge.general.changePassword.booleanValue()) {
            work.general.changePassword = true;
        }
        if (merge.general.writePreferences != null && merge.general.writePreferences.booleanValue()) {
            work.general.writePreferences = true;
        }
        if (merge.general.switchUser != null && merge.general.switchUser.booleanValue()) {
            work.general.switchUser = true;
        }
        if (merge.read.renderedImages != null && merge.read.renderedImages.booleanValue()) {
            work.read.renderedImages = true;
        }
        if (merge.read.basicMetadata != null && merge.read.basicMetadata.booleanValue()) {
            work.read.basicMetadata = true;
        }
        if (merge.read.extendedMetadata != null && merge.read.extendedMetadata.booleanValue()) {
            work.read.extendedMetadata = true;
        }
        if (merge.read.files != null && merge.read.files.booleanValue()) {
            work.read.files = true;
        }
        if (merge.read.downloadSource != null && merge.read.downloadSource.booleanValue()) {
            work.read.downloadSource = true;
        }
        if (merge.read.copy != null && merge.read.copy.booleanValue()) {
            work.read.copy = true;
        }
        if (merge.read.iccProfiles != null && merge.read.iccProfiles.booleanValue()) {
            work.read.iccProfiles = true;
        }
        if (merge.read.totalAssetsCount != null && merge.read.totalAssetsCount.booleanValue()) {
            work.read.totalAssetsCount = true;
        }
        if (merge.read.storageStatus != null && merge.read.storageStatus.booleanValue()) {
            work.read.storageStatus = true;
        }
        if (merge.list.files != null && merge.list.files.booleanValue()) {
            work.list.files = true;
        }
        if (merge.list.directories != null && merge.list.directories.booleanValue()) {
            work.list.directories = true;
        }
        if (merge.list.connector != null && merge.list.connector.booleanValue()) {
            work.list.connector = true;
        }
        if (merge.list.searchResults != null && merge.list.searchResults.booleanValue()) {
            work.list.searchResults = true;
        }
        if (merge.write.createDirectory != null && merge.write.createDirectory.booleanValue()) {
            work.write.createDirectory = true;
        }
        if (merge.write.upload != null && merge.write.upload.booleanValue()) {
            work.write.upload = true;
        }
        if (merge.write.paste != null && merge.write.paste.booleanValue()) {
            work.write.paste = true;
        }
        if (merge.write.delete != null && merge.write.delete.booleanValue()) {
            work.write.delete = true;
        }
        if (merge.write.moveToTrash != null && merge.write.moveToTrash.booleanValue()) {
            work.write.moveToTrash = true;
        }
        if (merge.write.rename != null && merge.write.rename.booleanValue()) {
            work.write.rename = true;
        }
        if (merge.write.overwrite != null && merge.write.overwrite.booleanValue()) {
            work.write.overwrite = true;
        }
        if (merge.write.moveWithinConnector != null && merge.write.moveWithinConnector.booleanValue()) {
            work.write.moveWithinConnector = true;
        }
        if (merge.write.extendedMetadata != null && merge.write.extendedMetadata.booleanValue()) {
            work.write.extendedMetadata = true;
        }
        if (merge.tasks.batchRendering != null && merge.tasks.batchRendering.booleanValue()) {
            work.tasks.batchRendering = true;
        }
        if (merge.tasks.createArchive != null && merge.tasks.createArchive.booleanValue()) {
            work.tasks.createArchive = true;
        }
        if (merge.tasks.reimportFiles != null && merge.tasks.reimportFiles.booleanValue()) {
            work.tasks.reimportFiles = true;
        }
    }

    private void mergePermissionsIfNotSet(PermissionSet higherPriority, PermissionSet lowerPriority) {
        if (lowerPriority == null) {
            return;
        }
        if (higherPriority.general.readLicence == null) {
            higherPriority.general.readLicence = lowerPriority.general.readLicence;
        }
        if (higherPriority.general.writeLicence == null) {
            higherPriority.general.writeLicence = lowerPriority.general.writeLicence;
        }
        if (higherPriority.general.changePassword == null) {
            higherPriority.general.changePassword = lowerPriority.general.changePassword;
        }
        if (higherPriority.general.writePreferences == null) {
            higherPriority.general.writePreferences = lowerPriority.general.writePreferences;
        }
        if (higherPriority.general.switchUser == null) {
            higherPriority.general.switchUser = lowerPriority.general.switchUser;
        }
        if (higherPriority.read.renderedImages == null) {
            higherPriority.read.renderedImages = lowerPriority.read.renderedImages;
        }
        if (higherPriority.read.basicMetadata == null) {
            higherPriority.read.basicMetadata = lowerPriority.read.basicMetadata;
        }
        if (higherPriority.read.extendedMetadata == null) {
            higherPriority.read.extendedMetadata = lowerPriority.read.extendedMetadata;
        }
        if (higherPriority.read.files == null) {
            higherPriority.read.files = lowerPriority.read.files;
        }
        if (higherPriority.read.downloadSource == null) {
            higherPriority.read.downloadSource = lowerPriority.read.downloadSource;
        }
        if (higherPriority.read.copy == null) {
            higherPriority.read.copy = lowerPriority.read.copy;
        }
        if (higherPriority.read.iccProfiles == null) {
            higherPriority.read.iccProfiles = lowerPriority.read.iccProfiles;
        }
        if (higherPriority.read.totalAssetsCount == null) {
            higherPriority.read.totalAssetsCount = lowerPriority.read.totalAssetsCount;
        }
        if (higherPriority.read.storageStatus == null) {
            higherPriority.read.storageStatus = lowerPriority.read.storageStatus;
        }
        if (higherPriority.list.files == null) {
            higherPriority.list.files = lowerPriority.list.files;
        }
        if (higherPriority.list.directories == null) {
            higherPriority.list.directories = lowerPriority.list.directories;
        }
        if (higherPriority.list.connector == null) {
            higherPriority.list.connector = lowerPriority.list.connector;
        }
        if (higherPriority.list.searchResults == null) {
            higherPriority.list.searchResults = lowerPriority.list.searchResults;
        }
        if (higherPriority.write.createDirectory == null) {
            higherPriority.write.createDirectory = lowerPriority.write.createDirectory;
        }
        if (higherPriority.write.upload == null) {
            higherPriority.write.upload = lowerPriority.write.upload;
        }
        if (higherPriority.write.paste == null) {
            higherPriority.write.paste = lowerPriority.write.paste;
        }
        if (higherPriority.write.delete == null) {
            higherPriority.write.delete = lowerPriority.write.delete;
        }
        if (higherPriority.write.moveToTrash == null) {
            higherPriority.write.moveToTrash = lowerPriority.write.moveToTrash;
        }
        if (higherPriority.write.rename == null) {
            higherPriority.write.rename = lowerPriority.write.rename;
        }
        if (higherPriority.write.overwrite == null) {
            higherPriority.write.overwrite = lowerPriority.write.overwrite;
        }
        if (higherPriority.write.extendedMetadata == null) {
            higherPriority.write.extendedMetadata = lowerPriority.write.extendedMetadata;
        }
        if (higherPriority.write.moveWithinConnector == null) {
            higherPriority.write.moveWithinConnector = lowerPriority.write.moveWithinConnector;
        }
        if (higherPriority.tasks.batchRendering == null) {
            higherPriority.tasks.batchRendering = lowerPriority.tasks.batchRendering;
        }
        if (higherPriority.tasks.createArchive == null) {
            higherPriority.tasks.createArchive = lowerPriority.tasks.createArchive;
        }
        if (higherPriority.tasks.reimportFiles == null) {
            higherPriority.tasks.reimportFiles = lowerPriority.tasks.reimportFiles;
        }
    }

    private void dumpGroupsAndUsers() {
        System.err.println("Users/Groups setup");
        for (Map.Entry<String, Group> e : this.groups.entrySet()) {
            System.err.println(" - " + e.getValue().getName() + ": " + e.getValue().getPermissionSet());
        }
    }

    protected abstract void readGroups();

    protected abstract void readUsers();

    public abstract boolean duplicateGroup(String var1, String var2);

    protected void readPermissionSets() {
        this.permissionSets.clear();
        this.globalPermissions = null;
        this.setupDefaultPermissionSets();
        if (!Files.exists(this.permissionsetsDirectory, new LinkOption[0])) {
            this.settings.getFSILogger().log(2078, this.permissionsetsDirectory.toFile().getAbsolutePath());
        } else {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.permissionsetsDirectory, "*.xml");){
                for (Path permissionSetFile : stream) {
                    String filename = permissionSetFile.getFileName().toString();
                    String pSetName = filename.substring(0, filename.length() - 4);
                    try {
                        Document doc = FileOperations.getXMLFileContent(this.settings.getFSILogger(), permissionSetFile);
                        String xml = XMLOperations.elementNamesToLowerCase(this.settings.getFSILogger(), doc);
                        PermissionSet pset = XMLOperations.unmarshalJAXB(xml, PermissionSet.class);
                        pset.setName(pSetName);
                        this.rawPermissionSets.put(pSetName, pset);
                        PermissionSet productionPSet = pset.clone();
                        productionPSet.applyDefaults();
                        this.permissionSets.put(pSetName, productionPSet);
                        this.settings.getFSILogger().log(2077, pSetName);
                    }
                    catch (DataBindingException dbe) {
                        this.settings.getFSILogger().log(2061, permissionSetFile);
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {}
                }
            }
            catch (IOException | DirectoryIteratorException e) {
                this.settings.getFSILogger().logException(e, 2071, this.permissionsetsDirectory.toString());
            }
        }
    }

    protected boolean readPropertySets() {
        int psChecksum = this.propertySets.hashCode();
        this.propertySets.clear();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.propertySetsDirectory, "*.xml");){
            for (Path propertySetFile : stream) {
                String filename = propertySetFile.getFileName().toString();
                try {
                    String pSetName = filename.substring(0, filename.length() - 4);
                    Document doc = FileOperations.getXMLFileContent(this.settings.getFSILogger(), propertySetFile);
                    String xml = XMLOperations.elementNamesToLowerCase(this.settings.getFSILogger(), doc);
                    PropertySet pSet = XMLOperations.unmarshalJAXB(xml, PropertySet.class);
                    pSet.setName(pSetName);
                    if (this.propertySetValid(pSet)) {
                        this.propertySets.put(pSetName, pSet);
                        this.settings.getFSILogger().log(2075, pSetName);
                        continue;
                    }
                    this.settings.getFSILogger().log(2076, pSetName);
                }
                catch (DataBindingException dbe) {
                    this.settings.getFSILogger().log(2061, propertySetFile);
                }
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            this.settings.getFSILogger().log(2072, this.propertySetsDirectory.toString());
        }
        return this.propertySets.hashCode() != psChecksum;
    }

    private boolean propertySetValid(PropertySet ps) {
        return this.itemListValid(ps.general) && this.itemListValid(ps.custommetadatafields) && this.itemListValid(ps.hideApps) && this.itemListValid(ps.hidePublishingTabs) && this.itemListValid(ps.publishingsets) && this.itemListValid(ps.custom);
    }

    private boolean itemListValid(List<PropertySet.ItemType> list) {
        boolean inheritFound = false;
        for (PropertySet.ItemType item : list) {
            if (!item.inherit) continue;
            if (inheritFound) {
                return false;
            }
            inheritFound = true;
        }
        return true;
    }

    protected void readPublishingSets() {
        this.publishingSets.clear();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.publishingSetsDirectory, "*.{xml}");){
            for (Path publishingSetFile : stream) {
                String filename = publishingSetFile.getFileName().toString();
                String pSetName = filename.substring(0, filename.length() - 4);
                try {
                    Document doc = FileOperations.getXMLFileContent(this.settings.getFSILogger(), publishingSetFile);
                    String xml = XMLOperations.elementNamesToLowerCase(this.settings.getFSILogger(), doc);
                    PublishingSet pset = XMLOperations.unmarshalJAXB(xml, PublishingSet.class);
                    pset.setName(pSetName);
                    this.publishingSets.put(pSetName, pset);
                    this.settings.getFSILogger().log(2074, pSetName);
                }
                catch (IOException dbe) {
                    this.settings.getFSILogger().log(2061, publishingSetFile);
                }
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            this.settings.getFSILogger().log(2073, this.publishingSetsDirectory.toString());
        }
    }

    public void updateSourceConnectorAccessRules() {
        this.readPermissionConfig();
        this.readPropertyConfig();
        if (this.settings instanceof SourceManagerSettings) {
            ((SourceManagerSettings)this.settings).updateSourceConnectorAccessRules();
        }
    }

    private Users.User getUserByName(String username) {
        Users.User u = null;
        for (Users.User user : this.users) {
            if (!user.name.equals(username)) continue;
            u = user;
            break;
        }
        return u;
    }

    public AuthenticationCode validateCredentials(String username, String password, String salt) {
        if (this.users == null) {
            return AuthenticationCode.ERROR;
        }
        Users.User u = this.getUserByName(username);
        if (u == null) {
            return AuthenticationCode.UNKNOWN_USER;
        }
        if (this.useKerberosAuthentication) {
            try {
                LoginContext lc = new LoginContext("primaryLoginContext", null, new UserNamePasswordCallbackHandler(username, password), this.krbConfig);
                lc.login();
                lc.logout();
                return AuthenticationCode.OK;
            }
            catch (LoginException e) {
                Throwable t = e.getCause();
                if (t == null) {
                    this.settings.getFSILogger().log(3266, e.getLocalizedMessage());
                    return AuthenticationCode.ERROR;
                }
                if (t instanceof SocketTimeoutException) {
                    this.settings.getFSILogger().log(3265, t.getLocalizedMessage());
                    return AuthenticationCode.ERROR;
                }
                if (t instanceof Exception) {
                    this.settings.getFSILogger().log(3267, username, t.getLocalizedMessage());
                    return AuthenticationCode.KERBEROS_AUTHENTICATION_FAILED;
                }
                this.settings.getFSILogger().log(3266, e.getLocalizedMessage());
                return AuthenticationCode.ERROR;
            }
        }
        if (u.hash != null && u.hash.length() > 0) {
            if (password != null && password.equals(DigestUtils.sha256(salt + u.hash, FileOperations.charsetUTF8))) {
                return AuthenticationCode.OK;
            }
            return AuthenticationCode.WRONG_PASSWORD;
        }
        if (u.plain != null && u.plain.length() > 0) {
            if (password != null && password.equals(DigestUtils.sha256(salt + DigestUtils.sha256(u.plain, FileOperations.charsetUTF8), FileOperations.charsetUTF8))) {
                return AuthenticationCode.OK;
            }
            return AuthenticationCode.WRONG_PASSWORD;
        }
        this.settings.getFSILogger().log(3268, username);
        return AuthenticationCode.WRONG_PASSWORD;
    }

    public boolean isKerberosAuthenticationEnabled() {
        return this.useKerberosAuthentication;
    }

    public String registerSession(String username) {
        String sessionid = null;
        sessionid = DigestUtils.sha256(System.currentTimeMillis() + username, FileOperations.charsetUTF8);
        this.activeSessions.put(sessionid, username);
        return sessionid;
    }

    public void logout(String sessionid) {
        if (this.activeSessions.containsKey(sessionid)) {
            this.activeSessions.remove(sessionid);
        }
    }

    public SessionStatus validateSession(String sessionid) {
        SessionStatus result = SessionStatus.INVALID;
        if (this.activeSessions.containsKey(sessionid)) {
            result = SessionStatus.VALID;
        }
        return result;
    }

    public String getUser(String sessionid) {
        String result = null;
        if (this.activeSessions.containsKey(sessionid)) {
            result = this.activeSessions.get(sessionid);
        }
        return result;
    }

    public boolean changeUser(String sessionid, String username) {
        boolean result = false;
        if (sessionid != null && username != null && this.activeSessions.containsKey(sessionid)) {
            this.activeSessions.put(sessionid, username);
            result = true;
        }
        return result;
    }

    public Set<String> getUsers() {
        HashSet<String> usernames = new HashSet<String>();
        for (Users.User user : this.users) {
            usernames.add(user.name);
        }
        return usernames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setUserPassword(String username, String password) {
        boolean result = false;
        permissionLock.lock();
        try {
            Users.User found = null;
            for (Users.User u : this.users) {
                if (!u.name.equals(username)) continue;
                found = u;
                break;
            }
            if (found != null) {
                found.plain = null;
                found.hash = DigestUtils.sha256(password, FileOperations.charsetUTF8);
                result = this.saveUsers();
            }
        }
        finally {
            permissionLock.unlock();
        }
        return result;
    }

    public boolean setUserPasswordHash(String username, String passwordHash) {
        boolean result = false;
        Users.User found = null;
        for (Users.User u : this.users) {
            if (!u.name.equals(username)) continue;
            found = u;
            break;
        }
        if (found != null) {
            found.plain = null;
            found.hash = passwordHash;
            result = this.saveUsers();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addUser(String username, String password) {
        boolean result = false;
        permissionLock.lock();
        try {
            boolean found = false;
            for (Users.User u : this.users) {
                if (!u.name.equals(username)) continue;
                found = true;
                break;
            }
            if (found) {
                this.settings.getFSILogger().log(3206, username);
                result = false;
            } else {
                Users.User newUser = new Users.User();
                newUser.name = username;
                newUser.hash = DigestUtils.sha256(password, FileOperations.charsetUTF8);
                this.users.add(newUser);
                result = this.saveUsers();
                this.groups.get("authenticated").getUsers().add(username);
                result = this.saveGroups();
            }
        }
        finally {
            permissionLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteUser(String username) {
        boolean result = false;
        permissionLock.lock();
        try {
            Users.User found = null;
            for (Users.User u : this.users) {
                if (!u.name.equals(username)) continue;
                found = u;
                break;
            }
            if (found != null) {
                this.users.remove(found);
                result = this.saveUsers();
            }
        }
        finally {
            permissionLock.unlock();
        }
        return result;
    }

    public boolean addGroup(String groupname, Set<String> usersValue, String permissionSet, String propertySet) {
        boolean success = false;
        if (!this.groups.containsKey(groupname)) {
            Group newgroup = new Group(groupname);
            if (permissionSet != null) {
                newgroup.setPermissionSet(permissionSet);
            }
            if (propertySet != null) {
                newgroup.setPropertySet(propertySet);
            }
            newgroup.setUsers(usersValue);
            this.groups.put(groupname, newgroup);
            success = this.saveGroups();
        }
        if (success) {
            this.settings.getFSILogger().log(3216, groupname);
        } else {
            this.settings.getFSILogger().log(3217, groupname);
        }
        return success;
    }

    public boolean addPropertySet(String setname, PropertySet propertySet) {
        Path psetFile = this.propertySetsDirectory.resolve(setname + ".xml");
        try {
            JAXB.marshal((Object)propertySet, (File)psetFile.toFile());
            this.propertySets.put(setname, propertySet);
            return true;
        }
        catch (DataBindingException e) {
            return false;
        }
    }

    public boolean addPublishingSet(String setname, String viewerDir) {
        PublishingSet pset = new PublishingSet();
        pset.setName(setname);
        pset.viewerpath = new PublishingSet.ValueType();
        pset.viewerpath.value = viewerDir;
        pset.viewerpath.isProtected = false;
        return this.addPublishingSet(pset);
    }

    public boolean addPublishingSet(PublishingSet set) {
        Path psetFile = this.publishingSetsDirectory.resolve(set.getName() + ".xml");
        try {
            JAXB.marshal((Object)set, (File)psetFile.toFile());
            this.publishingSets.put(set.getName(), set);
            return true;
        }
        catch (DataBindingException ioe) {
            return false;
        }
    }

    public boolean deleteGroup(String groupname) {
        boolean success = false;
        if (this.groups.containsKey(groupname)) {
            this.groups.remove(groupname);
            success = this.saveGroups();
        }
        return success;
    }

    public boolean addUserGroupAssignment(String groupname, String username) {
        Group g = this.groups.get(groupname);
        g.getUsers().add(username);
        boolean success = this.updateGroup(groupname, g);
        if (success) {
            this.updateUserPublishingSets();
        }
        return success;
    }

    public boolean updateGroup(String groupname, Group group) {
        boolean success = false;
        if (this.groups.containsKey(groupname)) {
            this.groups.put(groupname, group);
            success = this.saveGroups();
        }
        return success;
    }

    public boolean removeUserGroupAssignment(String groupname, String username) {
        Group g;
        boolean success = false;
        if (this.groups.containsKey(groupname) && (g = this.groups.get(groupname)).getUsers().remove(username)) {
            success = this.saveGroups();
        }
        return success;
    }

    public Map<String, Group> getGroups() {
        return this.groups;
    }

    public int getGroupCount() {
        int count = 0;
        for (Map.Entry<String, Group> entry : this.groups.entrySet()) {
            String name = entry.getValue().getName();
            boolean found = false;
            for (String ug : Defines.UNCOUNTED_GROUPS) {
                if (!name.equalsIgnoreCase(ug)) continue;
                found = true;
                break;
            }
            if (found) continue;
            ++count;
        }
        return count;
    }

    public Map<String, PermissionSet> getPermissionSets() {
        return this.permissionSets;
    }

    public Map<String, PropertySet> getPropertySets() {
        return this.propertySets;
    }

    public Map<String, PublishingSet> getPublishingSets() {
        return this.publishingSets;
    }

    public boolean addPermissionSet(String setname, PermissionSet set) {
        boolean success = true;
        if (!this.rawPermissionSets.containsKey(setname)) {
            this.rawPermissionSets.put(setname, set);
            success &= this.savePermissionSets();
        }
        try {
            PermissionSet productionSet = set.clone();
            productionSet.applyDefaults();
            if (!this.permissionSets.containsKey(setname)) {
                this.permissionSets.put(setname, productionSet);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.settings.getCacheManager().clearAll();
        return success;
    }

    public boolean updatePermissionSet(String setname, PermissionSet set) {
        boolean success = true;
        this.rawPermissionSets.put(setname, set);
        success &= this.savePermissionSets();
        try {
            PermissionSet productionSet = set.clone();
            productionSet.applyDefaults();
            this.permissionSets.put(setname, productionSet);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        this.settings.getCacheManager().clearAll();
        return success;
    }

    public boolean deletePermissionSet(String setname) {
        boolean success = false;
        if (this.rawPermissionSets.containsKey(setname)) {
            this.rawPermissionSets.remove(setname);
            success = this.savePermissionSets();
        }
        if (this.permissionSets.containsKey(setname)) {
            this.permissionSets.remove(setname);
        }
        this.settings.getCacheManager().clearAll();
        return success;
    }

    public boolean deletePropertySet(String setname) {
        boolean success = false;
        if (this.propertySets.containsKey(setname)) {
            this.propertySets.remove(setname);
            Path propertySetFile = this.propertySetsDirectory.resolve(setname + ".xml");
            try {
                success = Files.deleteIfExists(propertySetFile);
            }
            catch (IOException e) {
                success = false;
            }
        }
        return success;
    }

    public boolean deletePublishingSet(String setname) {
        boolean success = false;
        if (this.publishingSets.containsKey(setname)) {
            this.publishingSets.remove(setname);
            Path publishingSetFile = this.publishingSetsDirectory.resolve(setname + ".xml");
            try {
                success = Files.deleteIfExists(publishingSetFile);
            }
            catch (IOException e) {
                success = false;
            }
        }
        return success;
    }

    public Map<String, Map<String, Object>> getDetailedUserList() {
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
        for (Users.User user : this.users) {
            HashMap<String, String> details = new HashMap<String, String>();
            details.put("name", user.name);
            result.put(user.name, details);
        }
        return result;
    }

    protected void setupDefaultPermissionSets() {
        PermissionSet publicImagesPermissions = new PermissionSet("public_images");
        publicImagesPermissions.read.storageStatus = true;
        publicImagesPermissions.read.renderedImages = true;
        publicImagesPermissions.read.basicMetadata = true;
        publicImagesPermissions.read.extendedMetadata = true;
        publicImagesPermissions.list.files = true;
        publicImagesPermissions.list.searchResults = true;
        this.permissionSets.put(publicImagesPermissions.getName(), publicImagesPermissions);
        PermissionSet publicStaticsPermissions = new PermissionSet("public_statics");
        publicStaticsPermissions.read.storageStatus = true;
        publicStaticsPermissions.read.files = true;
        publicStaticsPermissions.read.basicMetadata = true;
        publicStaticsPermissions.read.extendedMetadata = true;
        publicStaticsPermissions.list.files = true;
        publicStaticsPermissions.list.searchResults = true;
        this.permissionSets.put(publicStaticsPermissions.getName(), publicStaticsPermissions);
        PermissionSet readOnly = new PermissionSet("read_only");
        readOnly.setFullReadPermissionsEnabled(true);
        this.permissionSets.put(readOnly.getName(), readOnly);
        PermissionSet readWrite = new PermissionSet("read_write");
        readWrite.setFullReadPermissionsEnabled(true);
        readWrite.setFullWritePermissionsEnabled(true);
        this.permissionSets.put(readWrite.getName(), readWrite);
        PermissionSet administrator = new PermissionSet("administrator");
        administrator.general.defaultValue = true;
        administrator.read.defaultValue = true;
        administrator.list.defaultValue = true;
        administrator.write.defaultValue = true;
        administrator.tasks.defaultValue = true;
        administrator.applyDefaults();
        this.permissionSets.put(administrator.getName(), administrator);
    }

    protected void setupDefaultGroups() {
        Group publicGroup = new Group("public");
        this.groups.put("public", publicGroup);
        Group administratorsGroup = new Group("administrators");
        this.groups.put("administrators", administratorsGroup);
        Group authenticatedGroup = new Group("authenticated");
        HashSet<String> allUsers = new HashSet<String>();
        for (Users.User user : this.users) {
            allUsers.add(user.name);
        }
        authenticatedGroup.setUsers(allUsers);
        this.groups.put("authenticated", authenticatedGroup);
    }

    protected abstract boolean saveUsers();

    protected abstract boolean saveGroups();

    protected abstract boolean savePermissionSets();

    public void updateSourceConnectors(Map<String, SourceConnectorReader> sourceConnectors) {
        this.userConnectorPermissions.clear();
        this.userConnectorProperties.clear();
        for (Users.User user : this.users) {
            HashMap<String, PermissionSet> userConnectorsPermissionSets = new HashMap<String, PermissionSet>();
            HashMap<String, PropertySet> userConnectorsPropertySets = new HashMap<String, PropertySet>();
            for (SourceConnectorReader connector : sourceConnectors.values()) {
                Map<Group, PermissionSet> groupPermissions = connector.getAccessPermissions();
                for (Map.Entry<Group, PermissionSet> gps : groupPermissions.entrySet()) {
                    if (!gps.getKey().containsUser(user.name)) continue;
                    userConnectorsPermissionSets.put(connector.getPrefix(), gps.getValue());
                }
                Map<Group, String> groupProperties = connector.getAccessProperties();
                for (Map.Entry<Group, String> gps : groupProperties.entrySet()) {
                    if (!gps.getKey().containsUser(user.name)) continue;
                    userConnectorsPropertySets.put(connector.getPrefix(), this.getPropertySets().get(gps.getValue()));
                }
            }
            this.userConnectorPermissions.put(user.name, userConnectorsPermissionSets);
            this.userConnectorProperties.put(user.name, userConnectorsPropertySets);
        }
        HashMap<String, PermissionSet> userConnectorsPSets = new HashMap<String, PermissionSet>();
        for (SourceConnectorReader connector : sourceConnectors.values()) {
            PermissionSet ps = connector.getAccessPermissions().get(this.groups.get("public"));
            userConnectorsPSets.put(connector.getPrefix(), ps);
        }
        this.userConnectorPermissions.put("public", userConnectorsPSets);
        this.updateUserPublishingSets();
    }

    private void updateUserPublishingSets() {
        this.userPublishingSets.clear();
        for (Users.User user : this.users) {
            Map<String, PropertySet> map;
            ArrayList<PublishingSet> inheritanceChain = new ArrayList<PublishingSet>();
            HashMap<String, Object> pSets = new HashMap<String, Object>();
            if (this.globalProperties != null) {
                for (PropertySet.ItemType item : this.globalProperties.publishingsets) {
                    PublishingSet pSet = this.publishingSets.get(item.name);
                    if (pSet == null) {
                        this.settings.getFSILogger().log(2064, item.name);
                        continue;
                    }
                    if (item.inherit) {
                        PublishingSet publishingSet = pSet.clone();
                        if (item.isProtected) {
                            publishingSet.protectAll(true);
                        }
                        inheritanceChain.add(publishingSet);
                        continue;
                    }
                    pSets.put(item.name, pSet);
                }
            }
            if (user.propertySet != null) {
                PropertySet properties = this.propertySets.get(user.propertySet);
                PublishingSet newInheritanceSet = null;
                for (PropertySet.ItemType itemType : properties.publishingsets) {
                    PublishingSet pSet = this.publishingSets.get(itemType.name);
                    if (pSet == null) {
                        this.settings.getFSILogger().log(2065, itemType.name, user.name);
                        continue;
                    }
                    if (itemType.inherit) {
                        newInheritanceSet = pSet.clone();
                        if (!itemType.isProtected) continue;
                        newInheritanceSet.protectAll(true);
                        continue;
                    }
                    pSets.put(itemType.name, this.applyInheritanceChain(pSet, inheritanceChain));
                }
                if (newInheritanceSet != null) {
                    inheritanceChain.add(newInheritanceSet);
                }
            }
            Set<Group> userGroups = this.getGroupsForUser(user.name);
            boolean inheritanceConflict = false;
            PublishingSet newInheritanceSet = null;
            for (Group g : userGroups) {
                String groupPropertySetname = g.getPropertySet();
                if (groupPropertySetname == null) continue;
                PropertySet ps = this.propertySets.get(groupPropertySetname);
                if (ps == null) {
                    this.settings.getFSILogger().log(2066, groupPropertySetname, g.getName());
                    continue;
                }
                for (PropertySet.ItemType item : ps.publishingsets) {
                    PublishingSet pSet = this.publishingSets.get(item.name);
                    if (pSet == null) {
                        this.settings.getFSILogger().log(2067, item.name, groupPropertySetname);
                        continue;
                    }
                    if (item.inherit) {
                        if (newInheritanceSet != null) {
                            this.settings.getFSILogger().log(2068, user.name);
                            inheritanceConflict = true;
                            continue;
                        }
                        newInheritanceSet = pSet.clone();
                        if (!item.isProtected) continue;
                        newInheritanceSet.protectAll(true);
                        continue;
                    }
                    pSets.put(item.name, this.applyInheritanceChain(pSet, inheritanceChain));
                }
            }
            if (!inheritanceConflict && newInheritanceSet != null) {
                inheritanceChain.add(newInheritanceSet);
            }
            if ((map = this.userConnectorProperties.get(user.name)) != null) {
                for (PropertySet propSet : map.values()) {
                    for (PropertySet.ItemType item : propSet.publishingsets) {
                        PublishingSet pSet = this.publishingSets.get(item.name);
                        if (pSet == null) {
                            this.settings.getFSILogger().log(2069, item.name);
                            continue;
                        }
                        if (item.inherit) {
                            this.settings.getFSILogger().log(2070, item.name);
                            continue;
                        }
                        pSets.put(item.name, this.applyInheritanceChain(pSet, inheritanceChain));
                    }
                }
            }
            this.userPublishingSets.put(user.name, pSets);
        }
    }

    private PublishingSet applyInheritanceChain(PublishingSet set, List<PublishingSet> chain) {
        PublishingSet result = set.clone();
        for (int i = chain.size() - 1; i >= 0; ++i) {
            PublishingSet inheritSet = chain.get(i);
            if (result.viewerpath == null || inheritSet.viewerpath != null && inheritSet.viewerpath.isProtected) {
                result.viewerpath = inheritSet.viewerpath;
            }
            if (result.proxyURL == null || inheritSet.proxyURL != null && inheritSet.proxyURL.isProtected) {
                result.proxyURL = inheritSet.proxyURL;
            }
            if (result.proxyServerPattern == null || inheritSet.proxyServerPattern != null && inheritSet.proxyServerPattern.isProtected) {
                result.proxyServerPattern = inheritSet.proxyServerPattern;
            }
            if (result.proxyStaticPattern == null || inheritSet.proxyStaticPattern != null && inheritSet.proxyStaticPattern.isProtected) {
                result.proxyStaticPattern = inheritSet.proxyStaticPattern;
            }
            if (result.proxyJSPath == null || inheritSet.proxyJSPath != null && inheritSet.proxyJSPath.isProtected) {
                result.proxyJSPath = inheritSet.proxyJSPath;
            }
            if (result.proxyViewerPath == null || inheritSet.proxyViewerPath != null && inheritSet.proxyViewerPath.isProtected) {
                result.proxyViewerPath = inheritSet.proxyViewerPath;
            }
            if (result.proxyUserViewerBase != null && (inheritSet.proxyUserViewerBase == null || !inheritSet.proxyUserViewerBase.isProtected)) continue;
            result.proxyUserViewerBase = inheritSet.proxyUserViewerBase;
        }
        return result;
    }

    protected void setFileMonitorTasksSuspended(boolean state) {
        for (FileEventCursor.RegisteredPath rp : this.fileMonitorTasks) {
            rp.setSuspended(state);
        }
    }

    public boolean saveUsersToFile(Path targetFile) {
        boolean success = false;
        Users userlist = new Users();
        userlist.users = new HashSet<Users.User>();
        for (Users.User user : this.users) {
            userlist.users.add(user);
        }
        try (OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);){
            JAXB.marshal((Object)userlist, (OutputStream)out);
            success = true;
        }
        catch (IOException ioe) {
            this.settings.getFSILogger().log(2048, targetFile.toString(), ioe.getLocalizedMessage());
        }
        catch (DataBindingException dbe) {
            this.settings.getFSILogger().log(2048, targetFile.toString(), dbe.getLocalizedMessage());
        }
        return success;
    }

    public boolean saveGroupsToFile(Path targetFile) {
        boolean success = false;
        Groups root = new Groups();
        ArrayList<Group> grouplist = new ArrayList<Group>();
        for (Map.Entry<String, Group> entry : this.groups.entrySet()) {
            if (entry.getKey().equals("public") || entry.equals("authenticated")) continue;
            grouplist.add(entry.getValue());
        }
        root.setGroups(grouplist);
        try (OutputStream out = Files.newOutputStream(targetFile, new OpenOption[0]);){
            JAXB.marshal((Object)root, (OutputStream)out);
            success = true;
        }
        catch (IOException | DataBindingException e) {
            this.settings.getFSILogger().log(2048, targetFile.toString(), e.getLocalizedMessage());
        }
        return success;
    }

    private static class UserNamePasswordCallbackHandler
    implements CallbackHandler {
        private final String _userName;
        private final char[] _password;

        public UserNamePasswordCallbackHandler(String userName, String password) {
            this._userName = userName;
            this._password = password != null ? password.toCharArray() : null;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback && this._userName != null) {
                    ((NameCallback)callback).setName(this._userName);
                    continue;
                }
                if (!(callback instanceof PasswordCallback) || this._password == null) continue;
                ((PasswordCallback)callback).setPassword(this._password);
            }
        }
    }

    public static enum SessionStatus {
        VALID,
        INVALID;

    }

    public static enum AuthenticationCode {
        OK,
        UNKNOWN_USER,
        WRONG_PASSWORD,
        KERBEROS_AUTHENTICATION_FAILED,
        ERROR;

    }
}

