/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.io.XMLOperations;
import com.neptunelabs.fsiserver.authentication.Group;
import com.neptunelabs.fsiserver.authentication.Groups;
import com.neptunelabs.fsiserver.authentication.Users;
import com.neptunelabs.fsiserver.sourcemanager.SourceManagerSettings;
import com.neptunelabs.fsiserver.utils.UserAuthenticationInterface;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.w3c.dom.Document;

public class XMLFileAuthentication
extends UserAuthenticationInterface {
    private final Path configHome;
    private final Path usersfile;
    private final Path groupsfile;

    public XMLFileAuthentication(SourceManagerSettings settings) {
        super(settings);
        this.configHome = settings.getConfigHome();
        this.usersfile = this.configHome.resolve("users.xml");
        this.groupsfile = this.configHome.resolve("groups.xml");
        this.permissionsetsDirectory = this.configHome.resolve("permissionsets");
        this.propertySetsDirectory = this.configHome.resolve("propertysets");
        this.publishingSetsDirectory = this.configHome.resolve("publishingsets");
        this.readPropertyConfig();
        this.readPermissionConfig();
        Path[] permissionRelevantFiles = new Path[]{this.usersfile, this.groupsfile};
        Path[] permissionRelevantDirectories = new Path[]{this.permissionsetsDirectory};
        this.setupMonitoring("updateSourceConnectorAccessRules", permissionRelevantFiles, permissionRelevantDirectories);
        Path[] propertiesRelevantDirectories = new Path[]{this.propertySetsDirectory, this.publishingSetsDirectory};
        this.setupMonitoring("updateSourceConnectorAccessRules", null, propertiesRelevantDirectories);
    }

    @Override
    protected void readGroups() {
        this.groups.clear();
        this.setupDefaultGroups();
        try {
            Document doc = FileOperations.getXMLFileContent(this.settings.getFSILogger(), this.groupsfile);
            String xml = XMLOperations.elementNamesToLowerCase(this.settings.getFSILogger(), doc);
            Groups rawgroups = XMLOperations.unmarshalJAXB(xml, Groups.class);
            if (rawgroups != null && rawgroups.getGroups() != null) {
                for (Group group : rawgroups.getGroups()) {
                    String groupname = group.getName();
                    if (!groupname.equalsIgnoreCase("authenticated") && !groupname.equals("public")) {
                        this.groups.put(group.getName(), group);
                        continue;
                    }
                    if (group.getPermissionSet() != null && this.groups.get(group.getName()) != null) {
                        ((Group)this.groups.get(group.getName())).setPermissionSet(group.getPermissionSet());
                    }
                    if (group.getPropertySet() == null || this.groups.get(group.getName()) == null) continue;
                    ((Group)this.groups.get(group.getName())).setPropertySet(group.getPropertySet());
                }
            }
        }
        catch (IOException dbe) {
            this.settings.getFSILogger().log(2048, this.groupsfile, dbe.getLocalizedMessage());
        }
    }

    @Override
    protected void readUsers() {
        this.users.clear();
        try {
            Document doc = FileOperations.getXMLFileContent(this.settings.getFSILogger(), this.usersfile);
            String xml = XMLOperations.elementNamesToLowerCase(this.settings.getFSILogger(), doc);
            Users userlist = XMLOperations.unmarshalJAXB(xml, Users.class);
            if (userlist.users != null) {
                Group authenticatedGroup = (Group)this.groups.get("authenticated");
                if (authenticatedGroup != null) {
                    HashSet<String> allUsers = new HashSet<String>();
                    for (Users.User u : userlist.users) {
                        allUsers.add(u.name);
                    }
                    authenticatedGroup.setUsers(allUsers);
                }
                for (Users.User user : userlist.users) {
                    this.users.add(user);
                }
            }
        }
        catch (IOException dbe) {
            this.settings.getFSILogger().log(2048, this.usersfile, dbe.getLocalizedMessage());
        }
    }

    @Override
    protected synchronized boolean savePermissionSets() {
        permissionLock.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean success = false;
        try {
            HashSet<Path> permissionSetFiles = new HashSet<Path>();
            for (PathCached pathCached : FileOperations.listFiles(this.permissionsetsDirectory, "*.xml")) {
                permissionSetFiles.add(pathCached.getPath());
            }
            for (Map.Entry entry : this.rawPermissionSets.entrySet()) {
                Path targetFile = this.permissionsetsDirectory.resolve((String)entry.getKey() + ".xml");
                try {
                    JAXB.marshal(entry.getValue(), (File)targetFile.toFile());
                    permissionSetFiles.remove(targetFile);
                    success &= true;
                }
                catch (DataBindingException dbe) {
                    this.settings.getFSILogger().log(2048, targetFile, dbe.getLocalizedMessage());
                }
            }
            for (Path path : permissionSetFiles) {
                Files.delete(path);
            }
            success = true;
        }
        catch (IOException e) {
            success = false;
        }
        this.setFileMonitorTasksSuspended(false);
        permissionLock.unlock();
        return success;
    }

    @Override
    public boolean duplicateGroup(String source, String target) {
        boolean success = false;
        if (this.groups.containsKey(source) && !this.groups.containsKey(target)) {
            Group newgroup = new Group(target);
            HashSet<String> usersValue = new HashSet<String>();
            usersValue.addAll(((Group)this.groups.get(source)).getUsers());
            newgroup.setUsers(usersValue);
            this.groups.put(target, newgroup);
            success = this.saveGroups();
        }
        return success;
    }

    @Override
    protected synchronized boolean saveGroups() {
        boolean result = false;
        permissionLock.lock();
        this.setFileMonitorTasksSuspended(true);
        result = this.saveGroupsToFile(this.groupsfile);
        this.setFileMonitorTasksSuspended(false);
        permissionLock.unlock();
        return result;
    }

    @Override
    protected synchronized boolean saveUsers() {
        permissionLock.lock();
        this.setFileMonitorTasksSuspended(true);
        boolean success = this.saveUsersToFile(this.usersfile);
        this.setFileMonitorTasksSuspended(false);
        permissionLock.unlock();
        return success;
    }

    public Path getUsersFile() {
        return this.usersfile;
    }

    public Path getGroupsFile() {
        return this.groupsfile;
    }

    public Path getPermissionSetsDirectory() {
        return this.permissionsetsDirectory;
    }

    @Override
    public boolean isUserModificationPossible() {
        return true;
    }
}

