/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.cache;

import com.neptunelabs.fsiframework.cache.BlockCache;
import com.neptunelabs.fsiframework.cache.CacheKey;
import com.neptunelabs.fsiframework.cache.CacheLoad;
import com.neptunelabs.fsiframework.cache.CacheManager;
import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.helpers.URLEncoderFast;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheBrowser
extends HttpServlet {
    private static final long serialVersionUID = -1506027446584153143L;
    private ServletContext servletContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletContext = config.getServletContext();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setDateHeader("Last-Modified", System.currentTimeMillis());
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0, post-check=0, pre-check=0");
        resp.setHeader("Pragma", "no-cache");
        Object o = this.servletContext.getAttribute("CacheManager");
        CacheManager cm = o != null ? (CacheManager)o : null;
        try (PrintWriter pw = resp.getWriter();){
            if (req.getParameter("delkey") != null) {
                this.delCacheEntries(cm, req.getParameter("delkey"));
            }
            pw.append("<!DOCTYPE html>\n");
            pw.append("<head>\n");
            pw.append("<title>Cache Brower</title>\n");
            pw.append("</head>\n");
            pw.append("<body><tt>\n");
            pw.append("******************<br/>\n");
            pw.append("* Cache Manager: *<br/>\n");
            pw.append("******************<br/>\n");
            this.printCacheEntries(pw, cm);
            pw.append("</tt></body>\n");
            pw.append("</html>\n");
            pw.flush();
        }
    }

    private void delCacheEntries(CacheManager cm, String cacheKeyStr) {
        if (cm != null && cacheKeyStr != null) {
            CacheKey cacheKey = CacheKey.getInstance(cacheKeyStr);
            cm.touchChangedFile(cacheKey);
        }
    }

    private void printCacheEntries(PrintWriter pw, CacheManager cm) {
        if (cm == null) {
            pw.append("No CacheManager found, sorry.<br/>\n");
        } else {
            long size;
            CacheLoad cl2;
            CacheLoad cl1;
            TreeSet<String> cacheKeysL1 = new TreeSet<String>();
            for (Map.Entry<String, SoftReference<CacheableData<?>>> entry : cm.getL1EntrySet()) {
                cacheKeysL1.add(entry.getKey());
            }
            BlockCache bc = cm.getBlockCache();
            Set<String> cacheKeysUnsortedL2 = bc.getKeys();
            TreeSet<String> cacheKeysL2 = new TreeSet<String>(cacheKeysUnsortedL2);
            pw.append("<h1>L1</h1>\n");
            pw.append("\nCurrent Objects L1: " + cacheKeysL1.size());
            pw.append("<h1>L2</h1>\n");
            pw.append("\n" + bc.toStatisticsString().replaceAll("\n", "<br/>"));
            pw.append("<hr/>\n");
            pw.append("<table border=\"1\">\n");
            pw.append("<tr>");
            pw.append("<td>Key</td>");
            pw.append("<td>L1 Type</td>");
            pw.append("<td>L2 Type</td>");
            pw.append("<td>Size</td>");
            pw.append("</tr>\n");
            URLEncoderFast encoder = new URLEncoderFast("", false);
            for (String key : cacheKeysL1) {
                pw.append("<tr>\n");
                cl1 = cm.getL1Load(key);
                cl2 = bc.loadObject(key);
                pw.append("<td><a href=\"?delkey=");
                pw.append(encoder.escape(key));
                pw.append("\" title=\"Delete Key\">");
                pw.append(key);
                pw.append("</a></td>");
                pw.append("<td>");
                pw.append(cl1.requestedL1Object.toString());
                pw.append("</td>");
                if (cl2 != null) {
                    pw.append("<td>");
                    pw.append(cl2.type.toString());
                    pw.append("</td>");
                } else {
                    pw.append("<td>");
                    pw.append("</td>");
                }
                if (cl2 != null) {
                    size = bc.getObjectSize(key);
                    pw.append("<td>");
                    pw.append(Long.toString(size));
                    pw.append("</td>");
                } else {
                    pw.append("<td>");
                    pw.append("</td>");
                }
                pw.append("\n");
                pw.append("</tr>\n");
            }
            for (String key : cacheKeysL2) {
                cl1 = cm.getL1Load(key);
                cl2 = bc.loadObject(key);
                pw.append("<tr>\n");
                pw.append("<td>");
                pw.append(key);
                pw.append("</td>");
                pw.append("<td>");
                pw.append("</td>");
                pw.append("<td>");
                pw.append(cl2.type.toString());
                pw.append("</td>");
                size = bc.getObjectSize(key);
                pw.append("<td>");
                pw.append(Long.toString(size));
                pw.append("</td>");
                pw.append("\n");
                pw.append("</tr>\n");
            }
            pw.append("</table>\n");
        }
    }
}

