/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.cache;

import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.utils.ETag;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public final class CacheableHttpServletResponse
extends HttpServletResponseWrapper
implements CacheableData<CacheableHttpServletResponse> {
    private volatile boolean cachable = true;
    private long assetURLHash = 0L;
    private long queryHash = 0L;
    private String contentType = null;
    private String characterEncoding = null;
    private long pixels = 0L;
    private int status = 0;
    private long requestStartTime = 0L;
    private long lastModified = 0L;
    private boolean notModifiedSent = false;
    private final ServletOutputStream output;
    private ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast(500);
    private boolean isClosed = false;
    private final HashMap<String, String> addHeaderMap = new HashMap();
    private final HashMap<String, Long> addDateHeaderMap = new HashMap();
    private final AtomicInteger cLength = new AtomicInteger(0);
    private final ETag eTag;
    private byte[] buffer = null;

    public CacheableHttpServletResponse(HttpServletResponse response, long assetURLHash, long queryHash) throws IOException {
        super(response);
        this.assetURLHash = assetURLHash;
        this.queryHash = queryHash;
        this.output = super.getOutputStream();
        this.eTag = new ETag();
    }

    public void setStatus(int status) {
        super.setStatus(status);
        this.status = status;
        if (status != 200 && status != 304) {
            this.cachable = false;
        }
    }

    public int getStatus() {
        return this.status;
    }

    public void sendError(int sc, String msg) throws IOException {
        super.sendError(sc, msg);
        this.cachable = false;
    }

    public void setContentType(String type) {
        super.setContentType(type);
        this.contentType = type;
    }

    public void setContentLength(int len) {
        super.setContentLength(len);
    }

    public void setCachable(boolean state) {
        this.cachable = state;
    }

    public void setPixels(long value) {
        this.pixels = value;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public ETag getETag() {
        return this.eTag;
    }

    public void setETag() {
        if (this.eTag.hasModifier()) {
            String tag = this.eTag.getStrongTag(this.assetURLHash, this.queryHash);
            this.addHeader("ETag", tag);
        }
    }

    public void setLastModified(long lm) {
        this.lastModified = lm / 1000L * 1000L;
    }

    public void setRequestStartTime(long value) {
        this.requestStartTime = value;
    }

    public long getRequestStartTime() {
        return this.requestStartTime;
    }

    public void addHeader(String name, String value) {
        if (!this.addHeaderMap.containsKey(name)) {
            super.setHeader(name, value);
            this.addHeaderMap.put(name, value);
        }
    }

    public void addDateHeader(String name, long value) {
        if (!this.addDateHeaderMap.containsKey(name)) {
            super.setDateHeader(name, value);
            this.addDateHeaderMap.put(name, value);
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("getOutputStream unsupported");
    }

    public void setCharacterEncoding(String arg0) {
        super.setCharacterEncoding(arg0);
        this.characterEncoding = arg0;
    }

    public void write(byte[] bytes, boolean cacheOnly) throws IOException {
        this.cLength.addAndGet(bytes.length);
        if (this.cachable) {
            this.baos.write(bytes);
        }
        if (!cacheOnly) {
            this.output.write(bytes);
        }
    }

    public void write(byte[] b, int off, int len, boolean cacheOnly) throws IOException {
        this.cLength.addAndGet(len);
        if (this.cachable) {
            this.baos.write(b, off, len);
        }
        if (!cacheOnly) {
            this.output.write(b, off, len);
        }
    }

    public void close() throws IOException {
        this.output.close();
        this.baos.close();
        this.buffer = this.baos.toByteArray();
        this.baos = null;
        this.isClosed = true;
    }

    public boolean isCachable() {
        return this.cachable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public HashMap<String, String> getHeaderMap() {
        return this.addHeaderMap;
    }

    public HashMap<String, Long> getDateHeaderMap() {
        return this.addDateHeaderMap;
    }

    public int getContentLength() {
        return this.buffer != null ? this.buffer.length : this.cLength.get();
    }

    public long getPixels() {
        return this.pixels;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getEncoding() {
        return this.characterEncoding;
    }

    public long getAssetURLHash() {
        return this.assetURLHash;
    }

    public void setAssetURLHash(long v) {
        this.assetURLHash = v;
    }

    public void setQueryHash(long v) {
        this.queryHash = v;
    }

    public long getQueryHash() {
        return this.queryHash;
    }

    public byte[] getContent() {
        return this.buffer;
    }

    public void sendError(int sc) throws IOException {
        if (sc == 304) {
            this.notModifiedSent = true;
        }
        super.sendError(sc);
    }

    public boolean isNotModifiedSent() {
        return this.notModifiedSent;
    }

    public void setContent(byte[] bytes) {
        this.buffer = new byte[bytes.length];
        System.arraycopy(bytes, 0, this.buffer, 0, bytes.length);
    }

    @Override
    public CacheableData<CacheableHttpServletResponse> copy() {
        throw new UnsupportedOperationException();
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] pack() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final CacheableHttpServletResponse unpack(byte[] bytes, HttpServletResponse hsr) {
        ByteArrayWalker bb = ByteArrayWalker.wrap(bytes, ByteOrder.nativeOrder());
        try {
            int contentEncodingBytesCount;
            CacheableHttpServletResponse chsr = new CacheableHttpServletResponse(hsr, 0L, 0L);
            chsr.setStatus(bb.getInt());
            int headerCount = bb.getInt();
            for (int h = 0; h < headerCount; ++h) {
                int keyCount = bb.getInt();
                byte[] keyBytes = new byte[keyCount];
                bb.get(keyBytes);
                String key = new String(keyBytes, FileOperations.charsetUTF8);
                int valueCount = bb.getInt();
                byte[] valueBytes = new byte[valueCount];
                bb.get(valueBytes);
                String value = new String(valueBytes, FileOperations.charsetUTF8);
                chsr.getHeaderMap().put(key, value);
            }
            int dateHeaderCount = bb.getInt();
            for (int h = 0; h < dateHeaderCount; ++h) {
                int keyCount = bb.getInt();
                byte[] keyBytes = new byte[keyCount];
                bb.get(keyBytes);
                String key = new String(keyBytes, FileOperations.charsetUTF8);
                long value = bb.getLong();
                chsr.getDateHeaderMap().put(key, value);
            }
            long lastModified = bb.getLong();
            chsr.setLastModified(lastModified);
            int contentTypeBytesCount = bb.getInt();
            if (contentTypeBytesCount > 0) {
                byte[] contentTypeBytes = new byte[contentTypeBytesCount];
                bb.get(contentTypeBytes);
                String contentType = new String(contentTypeBytes, FileOperations.charsetUTF8);
                chsr.setContentType(contentType);
            }
            if ((contentEncodingBytesCount = bb.getInt()) > 0) {
                byte[] contentEncodingBytes = new byte[contentEncodingBytesCount];
                bb.get(contentEncodingBytes);
                String contentEncoding = new String(contentEncodingBytes, FileOperations.charsetUTF8);
                chsr.setCharacterEncoding(contentEncoding);
            }
            chsr.setAssetURLHash(bb.getLong());
            chsr.setQueryHash(bb.getLong());
            int etagBytesCount = bb.getInt();
            if (etagBytesCount > 0) {
                byte[] etagBytes = new byte[etagBytesCount];
                bb.get(etagBytes);
                String etagStr = new String(etagBytes, FileOperations.charsetUTF8);
                ETag etag = chsr.getETag();
                etag.setStrongETag(etagStr);
            }
            int contentLength = bb.getInt();
            chsr.setContentLength(contentLength);
            int contentSize = bb.getInt();
            if (contentSize > 0) {
                byte[] content = new byte[contentSize];
                bb.get(content);
                chsr.setContent(content);
            }
            return chsr;
        }
        catch (BufferUnderflowException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.RESPONSE;
    }
}

