/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.comparators;

import com.neptunelabs.fsiserver.utils.PoolDirectoryEntry;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import java.util.Comparator;

public final class PoolDirectoryEntryComparator
implements Comparator<PoolDirectoryEntry> {
    private final PoolEntrySortingField field;
    private final Comparator<String> stringComparator;
    private final SortDirection order;

    public PoolDirectoryEntryComparator(PoolEntrySortingField field, Comparator<String> comparator, SortDirection order) {
        this.field = field;
        this.stringComparator = comparator;
        this.order = order;
    }

    public PoolEntrySortingField getPoolEntrySortingField() {
        return this.field;
    }

    @Override
    public int compare(PoolDirectoryEntry as, PoolDirectoryEntry bs) {
        int result = 0;
        switch (this.field) {
            case LASTMODIFIED: {
                if (as.lastmodified < bs.lastmodified) {
                    result = -1;
                    break;
                }
                if (as.lastmodified <= bs.lastmodified) break;
                result = 1;
                break;
            }
            default: {
                result = this.stringComparator.compare(as.name, bs.name);
            }
        }
        if (this.order == SortDirection.DESC && this.field != PoolEntrySortingField.FILENAME) {
            result = -result;
        }
        if (result == 0 && this.field != PoolEntrySortingField.FILENAME) {
            result = this.stringComparator.compare(as.name, bs.name);
        }
        return result;
    }
}

