/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.comparators;

import com.neptunelabs.fsiserver.utils.PoolFileEntry;
import com.neptunelabs.fsiserver.utils.comparators.PoolEntrySortingField;
import com.neptunelabs.fsiserver.utils.comparators.SortDirection;
import java.util.Comparator;

public final class PoolFileEntryComparator
implements Comparator<PoolFileEntry> {
    private final PoolEntrySortingField field;
    private final Comparator<String> stringComparator;
    private final SortDirection order;

    public PoolFileEntryComparator(PoolEntrySortingField field, Comparator<String> comparator, SortDirection order) {
        this.field = field;
        this.stringComparator = comparator;
        this.order = order;
    }

    public PoolEntrySortingField getPoolEntrySortingField() {
        return this.field;
    }

    @Override
    public int compare(PoolFileEntry as, PoolFileEntry bs) {
        int result = 0;
        switch (this.field) {
            case FILESIZE: {
                if (as.filesize < bs.filesize) {
                    result = -1;
                    break;
                }
                if (as.filesize <= bs.filesize) break;
                result = 1;
                break;
            }
            case LASTMODIFIED: {
                if (as.lastmodified < bs.lastmodified) {
                    result = -1;
                    break;
                }
                if (as.lastmodified <= bs.lastmodified) break;
                result = 1;
                break;
            }
            case RESOLUTION: {
                result = this.compareInts(as.width * as.height, bs.width * bs.height);
                break;
            }
            case DIMENSION: {
                result = this.compareInts(Math.min(as.width, as.height), Math.min(bs.width, bs.height));
                break;
            }
            case IMPORTSTATUS: {
                result = this.compareInts(as.importStatus, bs.importStatus);
                break;
            }
            case HEIGHT: {
                result = this.compareInts(as.height, bs.height);
                if (result != 0) break;
                result = this.compareInts(as.width, bs.width);
                break;
            }
            case WIDTH: {
                result = this.compareInts(as.width, bs.width);
                if (result != 0) break;
                result = this.compareInts(as.height, bs.height);
                break;
            }
            default: {
                result = this.stringComparator.compare(as.name, bs.name);
            }
        }
        if (this.order == SortDirection.DESC && this.field != PoolEntrySortingField.FILENAME) {
            result = -result;
        }
        if (result == 0 && this.field != PoolEntrySortingField.FILENAME) {
            result = this.stringComparator.compare(as.name, bs.name);
        }
        return result;
    }

    private int compareInts(int a, int b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }
}

