/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.custommetadata;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.custommetadata.CustomMetaDataFileHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class CustomMetaDataFileReader
extends CustomMetaDataFileHandler {
    public CustomMetaDataFileReader(FSIServerSettings settings, Path metaDataFile) {
        super(settings.getByteOrder(), metaDataFile);
    }

    public Map<String, String> getDataSet() throws NoSuchFileException, IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        byte[] bytes = FileOperations.readFile(this.metaDataFile);
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        byte[] readmagic = new byte[8];
        bais.read(readmagic);
        if (!Arrays.equals(magic, readmagic)) {
            throw new IOException("Invalid File Format");
        }
        while (bais.available() > 0) {
            int keyLength = this.readInt(bais);
            int valueLength = this.readInt(bais);
            byte[] keyBytes = new byte[keyLength];
            bais.read(keyBytes);
            String key = new String(keyBytes, FileOperations.charsetUTF8);
            if (valueLength > 0) {
                byte[] valueBytes = new byte[valueLength];
                bais.read(valueBytes);
                String value = new String(valueBytes, FileOperations.charsetUTF8);
                result.put(key, value);
                continue;
            }
            if (valueLength == 0) {
                result.put(key, "");
                continue;
            }
            result.put(key, null);
        }
        return result;
    }

    private int readInt(InputStream is) throws IOException {
        int result = this.byteOrder == ByteOrder.LITTLE_ENDIAN ? is.read() << 24 | is.read() << 16 | is.read() << 8 | is.read() : is.read() | is.read() << 8 | is.read() << 16 | is.read() << 24;
        return result;
    }
}

