/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.custommetadata;

import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.utils.FSIServerSettings;
import com.neptunelabs.fsiserver.utils.custommetadata.CustomMetaDataFileHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public final class CustomMetaDataFileWriter
extends CustomMetaDataFileHandler {
    public CustomMetaDataFileWriter(FSIServerSettings settings, Path metaDataFile) {
        super(settings.getByteOrder(), metaDataFile);
    }

    public final void setData(Map<String, String> metadata) throws IOException {
        if (metadata == null || metadata.isEmpty()) {
            try {
                Files.delete(this.metaDataFile);
            }
            catch (NoSuchFileException noSuchFileException) {}
        } else {
            try (ByteArrayOutputStreamFast baos = new ByteArrayOutputStreamFast();){
                baos.write(magic);
                for (Map.Entry<String, String> dataset : metadata.entrySet()) {
                    byte[] keyBytes = dataset.getKey().getBytes(FileOperations.charsetUTF8);
                    this.writeInt(keyBytes.length, baos);
                    if (dataset.getValue() != null) {
                        byte[] valueBytes = dataset.getValue().getBytes(FileOperations.charsetUTF8);
                        this.writeInt(valueBytes.length, baos);
                        baos.write(keyBytes);
                        baos.write(valueBytes);
                        continue;
                    }
                    this.writeInt(-1, baos);
                    baos.write(keyBytes);
                }
                Path parentPath = this.metaDataFile.getParent();
                if (!Files.exists(parentPath, new LinkOption[0])) {
                    Files.createDirectories(parentPath, new FileAttribute[0]);
                }
                baos.flush();
                FileOperations.writeFile(this.metaDataFile, baos.toByteArray());
            }
        }
    }

    private void writeInt(int value, OutputStream out) throws IOException {
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            out.write(value >>> 24 & 0xFF);
            out.write(value >> 16 & 0xFF);
            out.write(value >> 8 & 0xFF);
            out.write(value & 0xFF);
        } else {
            out.write(value & 0xFF);
            out.write(value >> 8 & 0xFF);
            out.write(value >> 16 & 0xFF);
            out.write(value >>> 24 & 0xFF);
        }
    }
}

