/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.histogram;

import com.neptunelabs.fsiframework.io.ReaderAbstract;
import com.neptunelabs.fsiframework.io.ReaderChannel;
import com.neptunelabs.fsiserver.utils.SPXEnvironment;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;

@Deprecated
public final class HistogramLoader {
    private HistogramLoader() {
    }

    public static Histogram load(Path histFile) throws IOException {
        Histogram result = null;
        if (histFile != null && Files.isReadable(histFile)) {
            try (ReaderChannel reader = new ReaderChannel(histFile, StandardOpenOption.READ);){
                result = new Histogram();
                HistogramLoader.readAndCheckMagicNumber(reader);
                ByteOrder bo = ((ReaderAbstract)reader).readByte() == 0 ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
                reader.setByteOrder(bo);
                ((ReaderAbstract)reader).readShort();
                int tagCounter = 0;
                boolean endReached = false;
                while (!endReached && tagCounter < 50) {
                    ++tagCounter;
                    short tag = -1;
                    try {
                        tag = ((ReaderAbstract)reader).readShort();
                    }
                    catch (BufferUnderflowException e) {
                        endReached = true;
                    }
                    if (endReached) continue;
                    endReached = HistogramLoader.handleTag(tag, reader, result);
                }
            }
        }
        return result;
    }

    private static boolean handleTag(short tag, ReaderAbstract reader, Histogram result) throws IOException {
        boolean endReached = false;
        int tagContentLength = reader.readInt();
        switch (tag) {
            case 101: {
                result.statisticRed = HistogramLoader.readFloats(reader, tagContentLength);
                break;
            }
            case 102: {
                result.statisticGreen = HistogramLoader.readFloats(reader, tagContentLength);
                break;
            }
            case 103: {
                result.statisticBlue = HistogramLoader.readFloats(reader, tagContentLength);
                break;
            }
            case 105: {
                result.statisticHue = HistogramLoader.readFloats(reader, tagContentLength);
                break;
            }
            case 106: {
                result.statisticSaturation = HistogramLoader.readFloats(reader, tagContentLength);
                break;
            }
            case 107: {
                result.statisticBrightness = HistogramLoader.readFloats(reader, tagContentLength);
                break;
            }
            case 121: {
                result.redFraction = reader.readFloat();
                break;
            }
            case 122: {
                result.greenFraction = reader.readFloat();
                break;
            }
            case 123: {
                result.blueFraction = reader.readFloat();
                break;
            }
            case 131: {
                result.redMin = reader.readByte();
                break;
            }
            case 132: {
                result.greenMin = reader.readByte();
                break;
            }
            case 133: {
                result.blueMin = reader.readByte();
                break;
            }
            case 136: {
                result.saturationMin = reader.readByte();
                break;
            }
            case 137: {
                result.brightnessMin = reader.readByte();
                break;
            }
            case 141: {
                result.redMax = reader.readByte();
                break;
            }
            case 142: {
                result.greenMax = reader.readByte();
                break;
            }
            case 143: {
                result.blueMax = reader.readByte();
                break;
            }
            case 146: {
                result.saturationMax = reader.readByte();
                break;
            }
            case 147: {
                result.brightnessMax = reader.readByte();
                break;
            }
            case 3854: {
                endReached = true;
                break;
            }
            default: {
                reader.skip(tagContentLength);
            }
        }
        return endReached;
    }

    private static float[] readFloats(ReaderAbstract reader, int num) throws IOException {
        float[] result = new float[num];
        for (int c = 0; c < num; ++c) {
            result[c] = reader.readFloat();
        }
        return result;
    }

    private static void readAndCheckMagicNumber(ReaderAbstract reader) throws IOException {
        byte[] magicNumber = new byte[8];
        reader.read(magicNumber);
        if (!Arrays.equals(magicNumber, SPXEnvironment.HISTOGRAM_MAGIC)) {
            throw new IOException("Invalid Histogram File");
        }
    }
}

