/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.histogram;

import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiserver.utils.SPXParserUtils;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.io.IOException;
import java.nio.ByteOrder;

public class HistogramUtils {
    public static Histogram readHistogramFromByteBuffer(ByteArrayWalker input) {
        Histogram result = new Histogram();
        block22: while (input.remaining() > 0) {
            short tag = input.getShort();
            int tagContentLength = input.getInt();
            switch (tag) {
                case 100: {
                    result.pixel = input.getLong();
                    continue block22;
                }
                case 101: {
                    result.statisticRed = SPXParserUtils.getTagContentAsFloatArray(input, tagContentLength);
                    continue block22;
                }
                case 102: {
                    result.statisticGreen = SPXParserUtils.getTagContentAsFloatArray(input, tagContentLength);
                    continue block22;
                }
                case 103: {
                    result.statisticBlue = SPXParserUtils.getTagContentAsFloatArray(input, tagContentLength);
                    continue block22;
                }
                case 105: {
                    result.statisticHue = SPXParserUtils.getTagContentAsFloatArray(input, tagContentLength);
                    continue block22;
                }
                case 106: {
                    result.statisticSaturation = SPXParserUtils.getTagContentAsFloatArray(input, tagContentLength);
                    continue block22;
                }
                case 107: {
                    result.statisticBrightness = SPXParserUtils.getTagContentAsFloatArray(input, tagContentLength);
                    continue block22;
                }
                case 121: {
                    result.redFraction = input.getFloat();
                    continue block22;
                }
                case 122: {
                    result.greenFraction = input.getFloat();
                    continue block22;
                }
                case 123: {
                    result.blueFraction = input.getFloat();
                    continue block22;
                }
                case 131: {
                    result.redMin = input.get();
                    continue block22;
                }
                case 132: {
                    result.greenMin = input.get();
                    continue block22;
                }
                case 133: {
                    result.blueMin = input.get();
                    continue block22;
                }
                case 136: {
                    result.saturationMin = input.get();
                    continue block22;
                }
                case 137: {
                    result.brightnessMin = input.get();
                    continue block22;
                }
                case 141: {
                    result.redMax = input.get();
                    continue block22;
                }
                case 142: {
                    result.greenMax = input.get();
                    continue block22;
                }
                case 143: {
                    result.blueMax = input.get();
                    continue block22;
                }
                case 146: {
                    result.saturationMax = input.get();
                    continue block22;
                }
                case 147: {
                    result.brightnessMax = input.get();
                    continue block22;
                }
            }
            input.position(input.position() + tagContentLength);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    private static byte[] writeHistogramToByteArray(Histogram histogram, ByteOrder byteOrder) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static ByteArrayWalker writeHistogramToByteBuffer(Histogram histogram, ByteOrder byteOrder) throws IOException {
        ByteArrayWalker result = null;
        if (histogram != null) {
            byte[] histogramData = HistogramUtils.writeHistogramToByteArray(histogram, byteOrder);
            result = ByteArrayWalker.wrap(histogramData, byteOrder);
        }
        return result;
    }
}

