/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.metadata;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.sourcemanager.storage.V1002.EISReader;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.exif.ExifParser;
import com.neptunelabs.imagereader.exif.ExifTag;
import com.neptunelabs.imagereader.iptc.IptcDirectory;
import com.neptunelabs.imagereader.iptc.IptcDirectoryReader;
import com.neptunelabs.imagereader.metareader.FSIMetaData;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ImageMetaData
extends FileMetaData {
    private short minorVersion;
    private short formatVersion;
    private byte importStatus = 0;
    private int width = -1;
    private int height = -1;
    private Level[] zoomLevels = null;
    private double[] zoomFactors = null;
    private int tileSize = -1;
    private boolean hasAlpha = false;
    private ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    private byte tileFormat = (byte)-1;
    private List<byte[]> iptc;
    private byte[] xmp = null;
    private byte[] exif = null;
    private byte[] selections = null;
    private String[] alphaNames = null;
    private byte[] alphaTypes = null;
    private int extraAlphaCount = 0;
    private Histogram histogram = null;
    private ICCProfileWrap icc = null;
    private ColorType colorType = ColorType.UNKNOWN;
    private String importModuleName = null;
    private String importModuleVersion = null;
    private long importTime = 0L;
    private byte[] keyHook = null;
    private int readerVersion = -1;
    private volatile EISReader eisReaderHook = null;

    public static ImageMetaData getInstance(FSIMetaData fsiMetaData) {
        ImageMetaData imd = new ImageMetaData();
        imd.colorType = fsiMetaData.colorType;
        imd.lastModified = fsiMetaData.lastModified;
        imd.sourceFileSize = fsiMetaData.filesize;
        imd.byteOrder = fsiMetaData.byteOrder;
        imd.hasAlpha = fsiMetaData.hasAlpha;
        imd.histogram = fsiMetaData.histogram;
        imd.width = fsiMetaData.getWidth();
        imd.height = fsiMetaData.getHeight();
        imd.exif = fsiMetaData.getExif();
        byte[] iptc = fsiMetaData.getIPTC();
        if (iptc != null) {
            imd.iptc = new ArrayList<byte[]>();
            imd.iptc.add(iptc);
        }
        imd.xmp = fsiMetaData.getXMP();
        imd.selections = fsiMetaData.getSelections();
        imd.icc = fsiMetaData.getICC();
        return imd;
    }

    public boolean basicDataComplete() {
        boolean result = true;
        if (this.importStatus != 3) {
            if (this.width == -1 || this.height == -1 || this.lastModified == -1L || this.sourceFileSize == -1L || this.tileFormat == -1 || this.importStatus == 1 && this.zoomLevels == null) {
                result = false;
            }
        } else if (this.lastModified == -1L || this.sourceFileSize == -1L) {
            result = false;
        }
        return result;
    }

    public void setContainterMinorVersion(short minor) {
        this.minorVersion = minor;
    }

    public void setImportStatus(byte status) {
        this.importStatus = status;
    }

    public byte getImportStatus() {
        return this.importStatus;
    }

    public void setFormatVersion(short version) {
        this.formatVersion = version;
    }

    public void setZoomLevels(Level[] zoomlevels) {
        this.zoomLevels = zoomlevels;
    }

    @Deprecated
    public void setZoomFactors(double[] zoomFactors) {
        this.zoomFactors = zoomFactors;
    }

    @Deprecated
    public void setTileSize(int tileSize) {
        this.tileSize = tileSize;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public boolean hasAlpha() {
        return this.hasAlpha;
    }

    public void setHasAlpha(boolean alpha) {
        this.hasAlpha = alpha;
    }

    public void setExtraAlphaCount(int ea) {
        this.extraAlphaCount = ea;
    }

    public int getExtraAlphaCount() {
        return this.extraAlphaCount;
    }

    public void setTileFormat(byte tileFormat) {
        this.tileFormat = tileFormat;
    }

    public void addIPTCData(byte[] iptcbytes) {
        if (iptcbytes != null) {
            if (this.iptc == null) {
                this.iptc = new ArrayList<byte[]>();
            }
            this.iptc.add(iptcbytes);
        }
    }

    public void setColorType(ColorType value) {
        this.colorType = value;
    }

    public ColorType getColorType() {
        return this.colorType;
    }

    public void setXMP(byte[] xmpbytes) {
        this.xmp = xmpbytes;
    }

    public byte[] getXMP() {
        return this.xmp;
    }

    public void setSelections(byte[] selectionsbytes) {
        this.selections = selectionsbytes;
    }

    public byte[] getSelections() {
        return this.selections;
    }

    public void setAlphaTypes(byte[] alphaTypes) {
        this.alphaTypes = alphaTypes;
    }

    public byte[] getAlphaTypes() {
        return this.alphaTypes;
    }

    public void setAlphaNames(String[] alphaNames) {
        this.alphaNames = alphaNames;
    }

    public String[] getAlphaNames() {
        return this.alphaNames;
    }

    public void setEXIF(byte[] exifbytes) {
        this.exif = exifbytes;
    }

    public void setHistogram(Histogram histogram) {
        this.histogram = histogram;
    }

    public Histogram getHistogram() {
        return this.histogram;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ICCProfileWrap getICC() {
        return this.icc;
    }

    public void setICC(ICCProfileWrap ipw) {
        this.icc = ipw;
    }

    public Level[] getZoomLevels() {
        return this.zoomLevels;
    }

    @Deprecated
    public double[] getZoomFactors() {
        return this.zoomFactors;
    }

    @Deprecated
    public int getTileSize() {
        return this.tileSize;
    }

    public byte getTileFormat() {
        return this.tileFormat;
    }

    public List<byte[]> getIPTCRaw() {
        return this.iptc;
    }

    public void setIPTCRaw(List<byte[]> iptcRaw) {
        this.iptc = iptcRaw;
    }

    @Override
    public List<Pair<String, String>> getSortedIPTCList() {
        Map<String, String> customIPTCData;
        Map<String, String> unsortedResult = null;
        if (this.iptc != null) {
            int length = 0;
            for (byte[] iptcbytes : this.iptc) {
                if (iptcbytes == null) continue;
                length += iptcbytes.length;
            }
            byte[] b = new byte[length];
            int offset = 0;
            for (byte[] iptcbytes : this.iptc) {
                if (iptcbytes == null) continue;
                System.arraycopy(iptcbytes, 0, b, offset, iptcbytes.length);
                offset += iptcbytes.length;
            }
            unsortedResult = IptcDirectoryReader.getIptcSimpleMap(b);
        }
        if (unsortedResult == null) {
            unsortedResult = new HashMap<String, String>();
        }
        if ((customIPTCData = this.getUnSortedIPTCMap()) != null) {
            HashSet iptcFieldsToRemove = new HashSet();
            for (Map.Entry entry : unsortedResult.entrySet()) {
                if (!customIPTCData.containsKey(entry.getKey())) continue;
                String newValue = customIPTCData.get(entry.getKey());
                if (newValue == null) {
                    iptcFieldsToRemove.add(entry.getKey());
                } else {
                    entry.setValue(newValue);
                }
                customIPTCData.remove(entry.getKey());
            }
            for (String string : iptcFieldsToRemove) {
                unsortedResult.remove(string);
            }
            for (Map.Entry<Object, Object> entry : customIPTCData.entrySet()) {
                unsortedResult.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return IptcDirectory.getSortedListFromMap(unsortedResult);
    }

    public byte[] getExifRaw() {
        return this.exif;
    }

    public Map<Pair<String, String>, String> getExifFullMap(FSILogger logger, String sourceName, boolean doLong) {
        List<ExifTag> customTags;
        HashMap<Pair<String, String>, String> result = new HashMap<Pair<String, String>, String>();
        if (this.exif != null) {
            ExifParser exifParser = ExifParser.getInstance(logger);
            exifParser.setName(sourceName);
            exifParser.scanExif(this.exif);
            List<ExifTag> exifData = exifParser.getExifTags();
            for (ExifTag exifField : exifData) {
                Pair<String, Object> key = new Pair<String, Object>(doLong ? exifField.getLongDescription() : exifField.getShortDescription(), null);
                result.put(key, exifField.getValueAsText());
            }
        }
        if ((customTags = this.getCustomExifTagList()) != null) {
            for (ExifTag exifField : customTags) {
                Pair<String, Object> key = new Pair<String, Object>(doLong ? exifField.getLongDescription() : exifField.getShortDescription(), null);
                result.put(key, exifField.getValueAsText());
            }
        }
        return result;
    }

    @Override
    public Map<Integer, Pair<String, String>> getExifSortedMap(FSILogger logger, String sourceName, boolean useLongDescription) {
        List<ExifTag> customTags;
        ArrayList<ExifTag> exifData = new ArrayList<ExifTag>();
        if (this.exif != null && this.exif.length > 0) {
            ExifParser exifParser = ExifParser.getInstance(logger);
            exifParser.setName(sourceName);
            exifParser.scanExif(this.exif);
            List<ExifTag> exifDataFromFile = exifParser.getExifTags();
            exifData.addAll(exifDataFromFile);
        }
        if ((customTags = this.getCustomExifTagList()).size() > 0) {
            if (exifData.size() == 0) {
                exifData.addAll(customTags);
            } else {
                ArrayList<ExifTag> fileTagsToDelete = new ArrayList<ExifTag>();
                block0: for (ExifTag fileTag : exifData) {
                    for (ExifTag customTag : customTags) {
                        if (!fileTag.getShortDescription().equals(customTag.getShortDescription())) continue;
                        fileTagsToDelete.add(fileTag);
                        continue block0;
                    }
                }
                exifData.removeAll(fileTagsToDelete);
                for (ExifTag customTag : customTags) {
                    String tagValue = customTag.getValueAsText();
                    if (tagValue == null) continue;
                    exifData.add(customTag);
                }
            }
        }
        return this.convertExifListToSortedMap(exifData, useLongDescription, logger, sourceName);
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    public short getFormatVersion() {
        return this.formatVersion;
    }

    @Override
    public String toString() {
        String result = "ImageMetaData: ";
        result = result + " Source: " + this.getAssetURLPath();
        result = result + "; Import Status: " + this.getImportStatus();
        result = result + "; Width: " + this.getWidth();
        result = result + "; Height: " + this.getHeight();
        if (this.getZoomLevels() != null) {
            result = result + "; ZoomLevels: " + this.getZoomLevels().length;
            if (this.getZoomLevels().length > 0) {
                result = result + " [";
                Level[] levels = this.getZoomLevels();
                for (int c = 0; c < levels.length; ++c) {
                    result = result + levels[c].width + "x";
                    result = result + levels[c].height + "@";
                    result = result + levels[c].tileSizeX + "x";
                    result = result + levels[c].tileSizeY;
                    if (c + 1 >= levels.length) continue;
                    result = result + " ";
                }
                result = result + "]";
            }
        } else {
            result = result + "; ZoomLevels: null";
        }
        result = result + "; LastModified: " + this.getLastModified();
        result = result + "; Source Size: " + this.getSourceFileSize();
        result = result + "; TileFormat: " + this.getTileFormat();
        result = result + "; has Alpha: " + this.hasAlpha();
        return result;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void setImportModuleName(String value) {
        this.importModuleName = value;
    }

    public String getImportModuleName() {
        return this.importModuleName;
    }

    public void setImportModuleVersion(String value) {
        this.importModuleVersion = value;
    }

    public String getImportModuleVersion() {
        return this.importModuleVersion;
    }

    public void setImportTime(long value) {
        this.importTime = value;
    }

    public long getImportTime() {
        return this.importTime;
    }

    public void setImageReaderVersion(int version) {
        this.readerVersion = version;
    }

    public int getImageReaderVersion() {
        return this.readerVersion;
    }

    public void setKeyHook(byte[] value) {
        this.keyHook = value;
    }

    public byte[] getKeyHook() {
        return this.keyHook;
    }

    public void setEISReaderHook(EISReader eisReader) {
        this.eisReaderHook = eisReader;
    }

    public synchronized EISReader getEISReaderHook() {
        EISReader result = this.eisReaderHook;
        this.eisReaderHook = null;
        return result;
    }
}

