/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserver.utils.metadata;

import com.neptunelabs.fsiframework.cache.CacheType;
import com.neptunelabs.fsiframework.cache.CacheableData;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.collections.PairComparator;
import com.neptunelabs.fsiframework.io.ByteArrayWalker;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.utils.metadata.DirectoryMetaData;
import com.neptunelabs.fsiserver.utils.metadata.FileMetaData;
import com.neptunelabs.fsiserver.utils.metadata.ImageMetaData;
import com.neptunelabs.fsiserver.utils.metadata.Level;
import com.neptunelabs.imagereader.converter.ColorType;
import com.neptunelabs.imagereader.converter.ICCProfileWrap;
import com.neptunelabs.imagereader.exif.ExifParser;
import com.neptunelabs.imagereader.exif.ExifTag;
import com.neptunelabs.imagereader.exif.ExifTagMapping;
import com.neptunelabs.imagereader.exif.ExifValueType;
import com.neptunelabs.imagereader.metrics.Histogram;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MetaData
implements CacheableData<MetaData> {
    private String assetURLPath;
    protected long lastModified = -1L;
    private Map<String, String> customMetaData;
    private static final byte TYPE_BASE = 0;
    private static final byte TYPE_FILE = 1;
    private static final byte TYPE_DIR = 2;
    private static final byte TYPE_IMAGE = 3;

    public MetaData() {
    }

    private MetaData(MetaData me) {
        this.assetURLPath = me.getAssetURLPath();
        this.lastModified = me.getLastModified();
        HashMap srcmap = (HashMap)me.getCustomMetaData();
        this.customMetaData = (Map)srcmap.clone();
    }

    public final void setAssetURLPath(String assetURLPath) {
        this.assetURLPath = assetURLPath;
    }

    public final void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public final String getAssetURLPath() {
        return this.assetURLPath;
    }

    public final long getLastModified() {
        return this.lastModified;
    }

    public void setCustomMetaData(Map<String, String> customMetaData) {
        this.customMetaData = customMetaData;
    }

    public Map<String, String> getCustomMetaData() {
        return this.customMetaData;
    }

    public Map<Integer, Pair<String, String>> getExifSortedMap(FSILogger logger, String sourceName, boolean useLongDescription) {
        List<ExifTag> exifList = this.getCustomExifTagList();
        return this.convertExifListToSortedMap(exifList, useLongDescription, logger, sourceName);
    }

    protected List<ExifTag> getCustomExifTagList() {
        ArrayList<ExifTag> result = new ArrayList<ExifTag>();
        Map<String, String> map = this.getUnSortedMapByPrefix("exif.");
        if (map != null && map.size() > 0) {
            ExifTagMapping tagMapping = ExifTagMapping.getInstance();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                Pair<Integer, Integer> exifid = tagMapping.getTagIDByLongName(entry.getKey());
                if (exifid == null) continue;
                String shortName = tagMapping.getShortName(exifid.getItem1(), exifid.getItem2());
                String longName = tagMapping.getLongName(exifid.getItem1(), exifid.getItem2());
                ExifTag tag = new ExifTag(exifid.getItem2(), shortName, longName, ExifValueType.Text, entry.getValue(), null);
                result.add(tag);
            }
        }
        return result;
    }

    public List<Pair<String, String>> getSortedFSIList() {
        Map<String, String> map = this.getUnSortedFSIMap();
        List<Pair<String, String>> result = this.mapToList(map);
        Collections.sort(result, new PairComparator());
        return result;
    }

    public List<Pair<String, String>> getSortedIPTCList() {
        Map<String, String> map = this.getUnSortedIPTCMap();
        List<Pair<String, String>> result = this.mapToList(map);
        Collections.sort(result, new PairComparator());
        return result;
    }

    protected Map<String, String> getUnSortedIPTCMap() {
        return this.getUnSortedMapByPrefix("iptc.");
    }

    private Map<String, String> getUnSortedFSIMap() {
        return this.getUnSortedMapByPrefix("fsi.");
    }

    private Map<String, String> getUnSortedMapByPrefix(String prefix) {
        if (this.customMetaData != null) {
            return this.filterCustomMetaDataByPrefix(prefix);
        }
        return null;
    }

    protected Map<Integer, Pair<String, String>> convertExifListToSortedMap(List<ExifTag> exifList, boolean useLongDescription, FSILogger logger, String sourceName) {
        TreeMap<Integer, Pair<String, String>> result = new TreeMap<Integer, Pair<String, String>>();
        ExifParser exifParser = ExifParser.getInstance(logger);
        List<Integer> exitTagSortList = exifParser.getTagSortMap();
        Collections.sort(exifList);
        int order = 1;
        boolean found = false;
        for (Integer searchId : exitTagSortList) {
            ExifTag delExifField = null;
            for (ExifTag exifField : exifList) {
                if (searchId.intValue() != exifField.getTag()) continue;
                this.transferExif(result, exifField, useLongDescription, order++);
                delExifField = exifField;
                found = true;
                break;
            }
            if (!found || delExifField == null) continue;
            exifList.remove(delExifField);
            found = false;
        }
        for (ExifTag exifField : exifList) {
            this.transferExif(result, exifField, useLongDescription, order++);
        }
        return result;
    }

    private void transferExif(Map<Integer, Pair<String, String>> result, ExifTag exifField, boolean useLongDescription, int order) {
        if (!useLongDescription) {
            result.put(order, new Pair<String, String>(exifField.getShortDescription(), exifField.getValueAsText()));
        } else {
            result.put(order, new Pair<String, String>(exifField.getLongDescription(), exifField.getValueAsText()));
        }
    }

    private List<Pair<String, String>> mapToList(Map<String, String> theMap) {
        ArrayList<Pair<String, String>> result = new ArrayList<Pair<String, String>>();
        if (theMap != null) {
            for (Map.Entry<String, String> entry : theMap.entrySet()) {
                result.add(new Pair<String, String>(entry.getKey(), entry.getValue()));
            }
        }
        return result;
    }

    private Map<String, String> filterCustomMetaDataByPrefix(String prefix) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> centry : this.customMetaData.entrySet()) {
            if (!centry.getKey().startsWith(prefix)) continue;
            result.put(centry.getKey().substring(prefix.length()), centry.getValue());
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] pack() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static final MetaData unpack(byte[] inData) {
        MetaData metaData;
        ByteArrayWalker bb = ByteArrayWalker.wrap(inData, ByteOrder.nativeOrder());
        try {
            byte type = bb.get();
            metaData = type == 1 ? new FileMetaData() : (type == 2 ? new DirectoryMetaData() : (type == 3 ? new ImageMetaData() : new MetaData()));
            int len = bb.getInt();
            if (len > 0) {
                byte[] data = new byte[len];
                bb.get(data);
                metaData.setAssetURLPath(new String(data, FileOperations.charsetUTF8));
            }
            metaData.setLastModified(bb.getLong());
            len = bb.getInt();
            if (len > 0) {
                HashMap<String, String> cmd = new HashMap<String, String>();
                for (int l = 0; l < len; ++l) {
                    String value;
                    String key;
                    int klen = bb.getInt();
                    if (klen > 0) {
                        byte[] kData = new byte[klen];
                        bb.get(kData);
                        key = new String(kData, FileOperations.charsetUTF8);
                    } else {
                        key = null;
                    }
                    int vlen = bb.getInt();
                    if (vlen > 0) {
                        byte[] vData = new byte[vlen];
                        bb.get(vData);
                        value = new String(vData, FileOperations.charsetUTF8);
                    } else {
                        value = null;
                    }
                    cmd.put(key, value);
                }
            }
            if (type == 3) {
                byte[] data;
                int l;
                byte booleanByte;
                ImageMetaData imd = (ImageMetaData)metaData;
                imd.setContainterMinorVersion(bb.getShort());
                imd.setFormatVersion(bb.getShort());
                imd.setImportStatus(bb.get());
                imd.setWidth(bb.getInt());
                imd.setHeight(bb.getInt());
                len = bb.getInt();
                if (len > 0) {
                    Level[] zoomlevels = new Level[len];
                    for (int l2 = 0; l2 < len; ++l2) {
                        Level level = new Level();
                        level.tileSizeX = bb.getInt();
                        level.tileSizeY = bb.getInt();
                        level.width = bb.getInt();
                        level.height = bb.getInt();
                        zoomlevels[l2] = level;
                    }
                    imd.setZoomLevels(zoomlevels);
                }
                imd.setHasAlpha((booleanByte = bb.get()) == 1);
                int bo = bb.getInt();
                imd.setByteOrder(bo == 0 ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN);
                imd.setTileFormat(bb.get());
                len = bb.getInt();
                if (len > 0) {
                    ArrayList<byte[]> iptcEntries = new ArrayList<byte[]>();
                    for (l = 0; l < len; ++l) {
                        int iLen = bb.getInt();
                        if (iLen <= 0) continue;
                        byte[] iData = new byte[iLen];
                        bb.get(iData);
                        iptcEntries.add(iData);
                    }
                    imd.setIPTCRaw(iptcEntries);
                }
                if ((len = bb.getInt()) > 0) {
                    data = new byte[len];
                    bb.get(data);
                    imd.setXMP(data);
                }
                if ((len = bb.getInt()) > 0) {
                    data = new byte[len];
                    bb.get(data);
                    imd.setEXIF(data);
                }
                if ((len = bb.getInt()) > 0) {
                    data = new byte[len];
                    bb.get(data);
                    imd.setSelections(data);
                }
                if ((len = bb.getInt()) > 0) {
                    String[] alphaNames = new String[len];
                    for (l = 0; l < len; ++l) {
                        int sLen = bb.getInt();
                        if (sLen <= 0) continue;
                        byte[] data2 = new byte[sLen];
                        bb.get(data2);
                        alphaNames[l] = new String(data2, FileOperations.charsetUTF8);
                    }
                    imd.setAlphaNames(alphaNames);
                }
                if ((len = bb.getInt()) > 0) {
                    data = new byte[len];
                    bb.get(data);
                    imd.setAlphaTypes(data);
                }
                imd.setExtraAlphaCount(bb.getInt());
                len = bb.getInt();
                if (len > 0) {
                    data = new byte[len];
                    bb.get(data);
                    imd.setHistogram(Histogram.unserialize(data));
                }
                if ((len = bb.getInt()) > 0) {
                    data = new byte[len];
                    bb.get(data);
                    ICCProfileWrap ipw = new ICCProfileWrap(data);
                    imd.setICC(ipw);
                }
                imd.setColorType(ColorType.values()[bb.getInt()]);
                imd.setImageReaderVersion(bb.getInt());
                len = bb.getInt();
                if (len > 0) {
                    data = new byte[len];
                    bb.get(data);
                    imd.setImportModuleName(new String(data, FileOperations.charsetUTF8));
                }
                if ((len = bb.getInt()) > 0) {
                    data = new byte[len];
                    bb.get(data);
                    imd.setImportModuleVersion(new String(data, FileOperations.charsetUTF8));
                }
                imd.setImportTime(bb.getLong());
                len = bb.getInt();
                if (len > 0) {
                    data = new byte[len];
                    bb.get(data);
                    imd.setKeyHook(data);
                }
            } else if (type == 1) {
                ((FileMetaData)metaData).setSourceFileSize(bb.getLong());
            } else if (type == 2) {
                ((DirectoryMetaData)metaData).setFiles(bb.getInt());
                ((DirectoryMetaData)metaData).setSubdirectories(bb.getInt());
            }
        }
        catch (BufferUnderflowException e) {
            metaData = null;
        }
        return metaData;
    }

    @Override
    public CacheableData<MetaData> copy() {
        return new MetaData(this);
    }

    @Override
    public CacheType getCacheType() {
        return CacheType.METADATA;
    }

    public int hashCode() {
        StringBuilder hashCodeBuilder = this.assetURLPath != null ? new StringBuilder(this.assetURLPath) : new StringBuilder("null");
        hashCodeBuilder.append(this.lastModified);
        if (this.customMetaData != null) {
            for (Map.Entry<String, String> entry : this.customMetaData.entrySet()) {
                hashCodeBuilder.append(entry.getKey());
                hashCodeBuilder.append(entry.getValue());
            }
        }
        String base = hashCodeBuilder.toString();
        return base.hashCode();
    }
}

