/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public final class Formatter {
    private static final DecimalFormat dblZero = new DecimalFormat("00");
    public static final int lineLength = 68;

    public static String secToTime(float seconds, boolean preciseTime, boolean plusSecs) {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        DecimalFormat floatRest = new DecimalFormat("00.##", dfs);
        StringBuilder sb = new StringBuilder();
        long secsLong = Math.round(seconds);
        String secsRest = floatRest.format(seconds);
        if (secsLong <= 90L) {
            if (preciseTime) {
                sb.append(secsRest);
            } else {
                sb.append(dblZero.format(secsLong));
            }
            sb.append(" sec");
        } else if (secsLong < 3600L) {
            int min = (int)Math.floor((float)secsLong / 60.0f);
            int sec = (int)secsLong - min * 60;
            sb.append(dblZero.format(min) + ":" + dblZero.format(sec) + " min");
            if (plusSecs) {
                sb.append(" (");
                if (preciseTime) {
                    sb.append(secsRest);
                } else {
                    sb.append(secsLong);
                }
                sb.append(" sec)");
            }
        } else {
            int hour = (int)Math.floor((float)secsLong / 3600.0f);
            int min = (int)Math.floor((float)(secsLong - (long)(hour * 3600)) / 60.0f);
            int sec = (int)secsLong - min * 60 - hour * 3600;
            sb.append(dblZero.format(hour) + ":" + dblZero.format(min) + ":" + dblZero.format(sec) + " h");
            if (plusSecs) {
                sb.append(" (");
                if (preciseTime) {
                    sb.append(secsRest);
                } else {
                    sb.append(secsLong);
                }
                sb.append(" sec)");
            }
        }
        return sb.toString();
    }

    public static String printPair(String key, Object value, String delimiter, int len) {
        StringBuilder sb = new StringBuilder(key);
        sb.append(delimiter);
        for (int c = 0; c < len - key.length(); ++c) {
            sb.append(' ');
        }
        sb.append(value);
        return sb.toString();
    }

    public static String drawLine(int line) {
        StringBuilder sb = new StringBuilder();
        for (int c = 0; c < line; ++c) {
            sb.append('-');
        }
        return sb.toString();
    }
}

