/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiserver.utils.Version;
import com.neptunelabs.fsiserverbenchmark.OutputFormat;
import com.neptunelabs.fsiserverbenchmark.Tester;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class Main {
    private static final long DEFAULT_RUNTIME = 180000L;
    private static final int DEFAULT_PRIORITY = 5;
    private static final Path DEFAULT_WORKDIR = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
    private static final boolean DEFAULT_VERBOSE = false;
    private static final OutputFormat DEFAULT_FORMAT = OutputFormat.TXT;
    private static final String DEFAULT_RESULTFILE = "result.txt";

    public static void main(String[] args) {
        boolean showHelp = false;
        boolean start = false;
        int threads = Runtime.getRuntime().availableProcessors();
        long runTime = 180000L;
        int priority = 5;
        Path workDir = DEFAULT_WORKDIR;
        Path resultFile = null;
        boolean verbose = false;
        boolean doHotRun = true;
        boolean doFullRun = true;
        boolean doTestCache = true;
        boolean doTestFSIImageLimited = true;
        boolean doTestFSIImageUnlimited = true;
        boolean doTestEncoder = true;
        boolean doTestIO = true;
        boolean doTestStorage = true;
        boolean calibrate = false;
        OutputFormat format = OutputFormat.TXT;
        if (args.length == 0) {
            showHelp = true;
        } else {
            block4: for (String arg : args) {
                String[] argpair = arg.split("=", 2);
                if (arg.equalsIgnoreCase("start")) {
                    start = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("verbose")) {
                    verbose = true;
                    continue;
                }
                if (arg.equalsIgnoreCase("calibrate")) {
                    calibrate = true;
                    continue;
                }
                if (argpair.length == 2) {
                    try {
                        String[] tests;
                        if (argpair[0].equalsIgnoreCase("runTime")) {
                            runTime = Integer.valueOf(argpair[1]) * 1000;
                            if (runTime > 0L) continue;
                            showHelp = true;
                            System.out.println("Invalid runTime");
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("priority")) {
                            if (argpair[1].equalsIgnoreCase("min") || argpair[1].equalsIgnoreCase("minimal")) {
                                priority = 1;
                                continue;
                            }
                            if (argpair[1].equalsIgnoreCase("norm") || argpair[1].equalsIgnoreCase("normal")) {
                                priority = 5;
                                continue;
                            }
                            if (argpair[1].equalsIgnoreCase("max") || argpair[1].equalsIgnoreCase("maximum")) {
                                priority = 10;
                                continue;
                            }
                            showHelp = true;
                            System.out.println("Invalid priority");
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("tests")) {
                            tests = argpair[1].split(",");
                            doTestCache = false;
                            doTestFSIImageLimited = false;
                            doTestFSIImageUnlimited = false;
                            doTestEncoder = false;
                            doTestIO = false;
                            doTestStorage = false;
                            for (String test : tests) {
                                if (test.equalsIgnoreCase("all")) {
                                    doTestCache = true;
                                    doTestFSIImageLimited = true;
                                    doTestFSIImageUnlimited = true;
                                    doTestEncoder = true;
                                    doTestIO = true;
                                    doTestStorage = true;
                                    continue block4;
                                }
                                if (test.equalsIgnoreCase("cache")) {
                                    doTestCache = true;
                                    continue;
                                }
                                if (test.equalsIgnoreCase("image")) {
                                    doTestFSIImageLimited = true;
                                    continue;
                                }
                                if (test.equalsIgnoreCase("swap")) {
                                    doTestFSIImageUnlimited = true;
                                    continue;
                                }
                                if (test.equalsIgnoreCase("encoder")) {
                                    doTestEncoder = true;
                                    continue;
                                }
                                if (test.equalsIgnoreCase("io")) {
                                    doTestIO = true;
                                    continue;
                                }
                                if (test.equalsIgnoreCase("storage")) {
                                    doTestStorage = true;
                                    continue;
                                }
                                if (test.equalsIgnoreCase("none")) continue;
                                start = false;
                                System.out.println("Invalid tests");
                                continue block4;
                            }
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("subtests")) {
                            tests = argpair[1].split(",");
                            doHotRun = false;
                            doFullRun = false;
                            for (String test : tests) {
                                if (test.equalsIgnoreCase("all")) {
                                    doHotRun = true;
                                    doFullRun = true;
                                    continue block4;
                                }
                                if (test.equalsIgnoreCase("hotrun")) {
                                    doHotRun = true;
                                    continue;
                                }
                                if (test.equalsIgnoreCase("full")) {
                                    doFullRun = true;
                                    continue;
                                }
                                start = false;
                                System.out.println("Invalid subtest");
                                continue block4;
                            }
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("maxthreads")) {
                            threads = Integer.valueOf(argpair[1]);
                            if (threads > 0) continue;
                            showHelp = true;
                            System.out.println("Invalid maxThreads");
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("workDir")) {
                            workDir = Paths.get(argpair[1], new String[0]);
                            if (Files.notExists(workDir, new LinkOption[0])) {
                                showHelp = true;
                                System.out.println("Directory " + workDir.toAbsolutePath().toString() + " not found");
                            }
                            if (Files.isWritable(workDir)) continue;
                            showHelp = true;
                            System.out.println("Directory " + workDir.toAbsolutePath().toString() + " not writable");
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("resultFile")) {
                            if (argpair[1].length() <= 0) continue;
                            resultFile = Paths.get(argpair[1], new String[0]);
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("verbose")) {
                            verbose = Boolean.valueOf(argpair[1]);
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("calibrate")) {
                            calibrate = Boolean.valueOf(argpair[1]);
                            continue;
                        }
                        if (argpair[0].equalsIgnoreCase("format")) {
                            if (argpair[1].equalsIgnoreCase("txt")) {
                                format = OutputFormat.TXT;
                                continue;
                            }
                            if (argpair[1].equalsIgnoreCase("xml")) {
                                format = OutputFormat.XML;
                                continue;
                            }
                            start = false;
                            System.out.println("Invalid format");
                            break;
                        }
                        System.out.println("Unknown parameter " + argpair[0]);
                        showHelp = true;
                    }
                    catch (NumberFormatException e) {
                        showHelp = true;
                    }
                    continue;
                }
                System.out.println("Unknown parameter " + arg);
                showHelp = true;
            }
            long availSpace = FileOperations.getUsableSpace(workDir);
            if (doTestStorage && availSpace < 15000000000L) {
                showHelp = true;
                System.out.println("Insufficient space left in workDir:" + workDir.toAbsolutePath().toString());
            }
        }
        if (!start) {
            showHelp = true;
        }
        if (showHelp) {
            Main.printUsage();
            System.exit(0);
        }
        try {
            Tester testMain = new Tester();
            testMain.setThreads(threads);
            testMain.setPriority(priority);
            testMain.setOutputFormat(format);
            testMain.setRunTime(runTime);
            testMain.setDoHotRun(doHotRun);
            testMain.setDoFullRun(doFullRun);
            testMain.setDoTestCache(doTestCache);
            testMain.setDoTestFSIImageLimited(doTestFSIImageLimited);
            testMain.setDoTestSwap(doTestFSIImageUnlimited);
            testMain.setDoTestEncoder(doTestEncoder);
            testMain.setDoTestIO(doTestIO);
            testMain.setDoTestStorage(doTestStorage);
            testMain.setWorkDirBase(workDir);
            testMain.setResultFile(resultFile);
            testMain.setVerbose(verbose);
            testMain.setCalibrate(calibrate);
            testMain.setDoOutput(true);
            testMain.benchmark();
        }
        catch (OutOfMemoryError e) {
            System.out.println("Out of memory: " + e.getLocalizedMessage());
            System.out.println("Please increase heap space with java option -Xmx");
            System.exit(1);
        }
    }

    private static void printUsage() {
        StringBuilder sb = new StringBuilder();
        SoftwareVersion.setSoftware(null, new Version());
        String vmOptions = "-Djava.awt.headless=true -server -Xss256k -Xms1g -Xmx1g -XX:+UseConcMarkSweepGC -XX:+UseParNewGC";
        sb.append(SoftwareVersion.getSoftware(true)).append(" - Benchmark").append("\n");
        sb.append("Parameters:").append("\n");
        sb.append('\t').append("start - start benchmark").append("\n");
        sb.append('\t').append("runTime=secs per test - default: ").append(180L).append("\n");
        sb.append('\t').append("priority=min|norm|max - default: norm").append("\n");
        sb.append('\t').append("tests=cache,image,encoder,swap,io,storage,all - default: all").append("\n");
        sb.append('\t').append("subtests=hotrun,full,all - default: all").append("\n");
        sb.append('\t').append("maxThreads=n - default: ").append(Runtime.getRuntime().availableProcessors()).append("\n");
        sb.append('\t').append("workDir=dir | default: ").append(DEFAULT_WORKDIR.toAbsolutePath()).append("\n");
        sb.append('\t').append("verbose=boolean | default: ").append(false).append("\n");
        sb.append('\t').append("resultFile=file | e.g.: ").append(DEFAULT_RESULTFILE).append("\n");
        sb.append('\t').append("format=txt|xml | default: ").append((Object)DEFAULT_FORMAT).append("\n");
        sb.append('\n');
        sb.append("Recommended Java Options (64 Bit):").append("\n");
        sb.append(vmOptions).append("\n");
        sb.append('\n');
        sb.append("Example - Standard Test:").append("\n");
        sb.append("java " + vmOptions + " -jar fsi.jar start workdir=/path/to/storage/dir").append("\n");
        sb.append('\n');
        System.out.println(sb.toString());
    }
}

