/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserverbenchmark.SingleTestResult;
import com.neptunelabs.fsiserverbenchmark.ThreadSettings;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Random;

abstract class TestBenchmarkFramework {
    protected int threads;
    private long hotRunTime;
    private long runTime;
    final ByteOrder byteOrder;
    final FSILogger logger;
    final String name;
    final ThreadSettings threadSettings;
    boolean doHotRun = true;
    boolean doFullRun = true;
    boolean verbose = false;
    boolean calibrate = false;
    long priority = 0L;
    final float gaugeMasterIndex = 0.5625f;
    boolean stop = false;
    String message;
    Random rand = new Random(4366831L);
    private final long startTimeTotal;
    private final SingleTestResult testResult;
    boolean error = false;
    String errorMessage;

    TestBenchmarkFramework(String name, FSILogger logger, ThreadSettings threadSettings) {
        System.out.print("Starting Test " + name + " ");
        System.out.print("[");
        this.startTimeTotal = System.nanoTime();
        this.byteOrder = ByteOrder.nativeOrder();
        this.name = name;
        this.logger = logger;
        this.testResult = new SingleTestResult(name);
        this.threadSettings = threadSettings;
    }

    void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    void setCalibrate(boolean state) {
        this.calibrate = state;
    }

    void setThreads(int threads) {
        this.threads = threads;
    }

    void setHotRunTime(long hotRunTime) {
        this.hotRunTime = hotRunTime;
    }

    void setRunTime(long runTime) {
        this.runTime = runTime;
    }

    void stop() {
        this.stop = true;
    }

    boolean hasError() {
        return this.error;
    }

    String getError() {
        return this.errorMessage;
    }

    void setThreadSettings(boolean doHotRun, boolean doFullRun) {
        this.doHotRun = doHotRun;
        this.doFullRun = doFullRun;
    }

    void test() throws IOException {
        if (this.doHotRun && !this.stop) {
            this.doInnerTest(this.threadSettings.hotrunThreads, this.hotRunTime, true);
            this.message = null;
            System.gc();
        }
        if (this.doFullRun && !this.stop) {
            SubTestResult sResult = this.doInnerTest(this.threadSettings.fullThreads, this.runTime, false);
            this.testResult.index = sResult.index;
            this.testResult.testTime = sResult.testTime;
            this.testResult.passesTotal = sResult.passesTotal;
            this.testResult.threadPassesPerSec = this.calcPassesPerSec(sResult.passes, sResult.runTimes);
            this.message = null;
            System.gc();
        }
        this.testResult.timeTotal = System.nanoTime() - this.startTimeTotal;
    }

    public SingleTestResult getBenchmarkResult() {
        return this.testResult;
    }

    public void dispose() {
        System.gc();
        System.out.print("]");
        System.out.println();
    }

    protected int calcIndex(long[] passes, long[] runTimes, int[] gaugeIndex, boolean calibrateValue) {
        int subIndex = 0;
        float[] passesPerSec = this.calcPassesPerSec(passes, runTimes);
        float lastPPS = 0.0f;
        for (int i = 0; i < passesPerSec.length; ++i) {
            float diffPass = passesPerSec[i] - lastPPS;
            float pF = ((float)(i + 1) / 2.0f + 0.5f) / (float)(i + 1);
            subIndex = (int)((float)subIndex + diffPass * pF);
            lastPPS = passesPerSec[i];
        }
        if (calibrateValue) {
            return subIndex;
        }
        int avgGauge = 0;
        for (int gI : gaugeIndex) {
            avgGauge += gI;
        }
        return subIndex * 1000 / (avgGauge /= gaugeIndex.length);
    }

    private float[] calcPassesPerSec(long[] passes, long[] runTimes) {
        float[] result = new float[passes.length];
        for (int i = 0; i < passes.length; ++i) {
            result[i] = (float)passes[i] / ((float)runTimes[i] / 1000.0f);
        }
        return result;
    }

    abstract SubTestResult doInnerTest(int var1, long var2, boolean var4) throws IOException;

    static class SubTestResult {
        long[] passes;
        long passesTotal;
        long[] runTimes;
        int index;
        long testTime;
        boolean error;

        SubTestResult() {
        }
    }
}

