/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserverbenchmark.TestBenchmarkFramework;
import com.neptunelabs.fsiserverbenchmark.ThreadSettings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class TestCache
extends TestBenchmarkFramework {
    private static final int cacheSizePerThread = 0x1000000;
    private ByteBuffer cache;
    private final int[] gaugeIndex = new int[]{42072, 41979, 40860, 40620};
    private CacheTestThread[] t = null;

    public TestCache(String name, FSILogger logger, ThreadSettings threadSettings) {
        super(name, logger, threadSettings);
        this.cache = ByteBuffer.allocateDirect(threadSettings.fullThreads * 0x1000000);
        this.cache.order(ByteOrder.nativeOrder());
    }

    @Override
    public void dispose() {
        this.cache = null;
        super.dispose();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.t != null) {
            for (CacheTestThread thread : this.t) {
                if (thread == null) continue;
                thread.halt();
            }
            for (CacheTestThread thread : this.t) {
                try {
                    if (thread == null) continue;
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    TestBenchmarkFramework.SubTestResult doInnerTest(int testThreads, long runTime, boolean isHotrun) throws IOException {
        int i;
        int i2;
        long cTime;
        TestBenchmarkFramework.SubTestResult result = new TestBenchmarkFramework.SubTestResult();
        this.t = new CacheTestThread[testThreads];
        result.passes = new long[testThreads];
        result.runTimes = new long[testThreads];
        long startTime = System.currentTimeMillis();
        long stopTime = System.currentTimeMillis() + runTime;
        int usedThreads = 0;
        long nextThreadTime = System.currentTimeMillis();
        long subTime = 0L;
        long subStartTime = 0L;
        float slice = (float)runTime / (float)testThreads;
        boolean hasPrintedHotrunSymbols = false;
        while ((cTime = System.currentTimeMillis()) < stopTime || this.stop) {
            if (cTime > nextThreadTime) {
                int i3;
                if (isHotrun && !hasPrintedHotrunSymbols) {
                    System.out.print("H");
                    hasPrintedHotrunSymbols = true;
                } else if (!isHotrun) {
                    String x = Integer.toHexString(usedThreads + 1);
                    System.out.print(x.substring(x.length() - 1).toUpperCase());
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    this.t[i3].halt();
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    try {
                        this.t[i3].join();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (usedThreads > 0) {
                    subTime = System.currentTimeMillis() - subStartTime;
                }
                long passes = 0L;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    passes += this.t[i2].passes;
                }
                if (usedThreads > 0) {
                    result.passes[usedThreads - 1] = passes;
                    result.runTimes[usedThreads - 1] = subTime;
                }
                ++usedThreads;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2] = new CacheTestThread(this.cache.slice(), i2);
                }
                nextThreadTime = startTime + (long)((float)usedThreads * slice);
                subStartTime = System.currentTimeMillis();
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2].start();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException passes) {
                // empty catch block
            }
            Thread.yield();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            this.t[i].halt();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            try {
                this.t[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (usedThreads > 0) {
            subTime = System.currentTimeMillis() - subStartTime;
        }
        long passes = 0L;
        for (i2 = 0; i2 < usedThreads; ++i2) {
            passes += this.t[i2].passes;
        }
        if (usedThreads > 0) {
            result.passes[usedThreads - 1] = passes;
            result.runTimes[usedThreads - 1] = subTime;
        }
        long totalTime = System.currentTimeMillis() - startTime;
        long sum = 0L;
        for (int i4 = 0; i4 < result.passes.length; ++i4) {
            sum += result.passes[i4];
        }
        result.passesTotal = sum;
        if (!isHotrun) {
            result.index = this.calcIndex(result.passes, result.runTimes, this.gaugeIndex, this.calibrate);
        }
        result.testTime = totalTime;
        return result;
    }

    static class CacheTestThread
    extends Thread {
        private final ByteBuffer cache;
        private final int startPos;
        long passes = 0L;
        private boolean running;

        CacheTestThread(ByteBuffer cache, int thread) {
            this.cache = cache.slice();
            this.startPos = thread * 0x1000000;
            this.setName("CacheTestThread-" + thread);
        }

        @Override
        public void run() {
            int size = 262144;
            this.running = true;
            byte[] dst = new byte[262144];
            int getMod = 0xFBFFFF;
            while (this.running) {
                if (this.passes++ % 2L == 0L) {
                    this.cache.position((int)(this.passes * 74782L % 0xFBFFFFL) + this.startPos);
                    this.cache.get(dst, 0, (int)(this.passes * 64241L % 262144L));
                    continue;
                }
                this.cache.position((int)(this.passes * 81729L % 0xFBFFFFL) + this.startPos);
                this.cache.put(dst, 0, (int)(this.passes * 34234L % 262144L));
            }
        }

        public void halt() {
            this.running = false;
        }

        public void reset() {
            this.passes = 0L;
        }
    }
}

