/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.ByteArrayOutputStreamFast;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserverbenchmark.TestBenchmarkFramework;
import com.neptunelabs.fsiserverbenchmark.ThreadSettings;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGEncoder;
import com.neptunelabs.imagemanipulator.encoder.jpeg.JPEGPreparation;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.imageio.stream.MemoryCacheImageOutputStream;

final class TestEncoder
extends TestBenchmarkFramework {
    private EncoderTestThread[] t = null;
    private final FSIImage[] images;
    private final int[] gaugeIndex = new int[]{3276, 3290, 3267};
    private static final float jpegQuality = 0.92f;
    JPEGPreparation jpegPreparation;
    private final int[] sizes = new int[]{160, 112, 71, 294, 50, 600, 224};
    private final int[] ratio = new int[]{35, 29, 27, 5, 2, 1, 1};

    public TestEncoder(String name, FSILogger logger, SwapPool swapPool, ThreadSettings threadSettings) {
        super(name, logger, threadSettings);
        try {
            this.jpegPreparation = new JPEGPreparation(0.92f, false, JPEGPreparation.ChromaSubsampling.CS420, SoftwareVersion.getSoftware(false), "Test", 0, null, true);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.images = new FSIImageLimited[this.sizes.length];
        for (int i = 0; i < this.sizes.length; ++i) {
            this.images[i] = new FSIImageLimited(logger, swapPool, this.byteOrder, this.sizes[i], this.sizes[i], null, FSIImageMode.RGB);
            for (int y = 0; y < this.sizes[i]; ++y) {
                for (int x = 0; x < this.sizes[i]; ++x) {
                    this.images[i].setSample(x, y, y % 255);
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (int tc = 0; tc < this.images.length; ++tc) {
            if (this.images[tc] == null) continue;
            this.images[tc].dispose();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.t != null) {
            for (EncoderTestThread thread : this.t) {
                if (thread == null) continue;
                thread.halt();
            }
            for (EncoderTestThread thread : this.t) {
                try {
                    if (thread == null) continue;
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    TestBenchmarkFramework.SubTestResult doInnerTest(int testThreads, long runTime, boolean isHotrun) throws IOException {
        int i;
        int i2;
        long cTime;
        TestBenchmarkFramework.SubTestResult result = new TestBenchmarkFramework.SubTestResult();
        this.t = new EncoderTestThread[testThreads];
        result.passes = new long[testThreads];
        result.runTimes = new long[testThreads];
        long startTime = System.currentTimeMillis();
        long stopTime = System.currentTimeMillis() + runTime;
        int usedThreads = 0;
        long nextThreadTime = System.currentTimeMillis();
        long subTime = 0L;
        long subStartTime = 0L;
        float slice = (float)runTime / (float)testThreads;
        boolean hasPrintedHotrunSymbols = false;
        while ((cTime = System.currentTimeMillis()) < stopTime || this.stop) {
            if (cTime > nextThreadTime) {
                int i3;
                if (isHotrun && !hasPrintedHotrunSymbols) {
                    System.out.print("H");
                    hasPrintedHotrunSymbols = true;
                } else if (!isHotrun) {
                    String x = Integer.toHexString(usedThreads + 1);
                    System.out.print(x.substring(x.length() - 1).toUpperCase());
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    this.t[i3].halt();
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    try {
                        this.t[i3].join();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (usedThreads > 0) {
                    subTime = System.currentTimeMillis() - subStartTime;
                }
                long passes = 0L;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    passes += this.t[i2].passes;
                }
                if (usedThreads > 0) {
                    result.passes[usedThreads - 1] = passes;
                    result.runTimes[usedThreads - 1] = subTime;
                }
                ++usedThreads;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2] = new EncoderTestThread(i2, this.images, this.ratio);
                }
                nextThreadTime = startTime + (long)((float)usedThreads * slice);
                subStartTime = System.currentTimeMillis();
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2].start();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException passes) {
                // empty catch block
            }
            Thread.yield();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            this.t[i].halt();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            try {
                this.t[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (usedThreads > 0) {
            subTime = System.currentTimeMillis() - subStartTime;
        }
        long passes = 0L;
        for (i2 = 0; i2 < usedThreads; ++i2) {
            passes += this.t[i2].passes;
        }
        if (usedThreads > 0) {
            result.passes[usedThreads - 1] = passes;
            result.runTimes[usedThreads - 1] = subTime;
        }
        long totalTime = System.currentTimeMillis() - startTime;
        long sum = 0L;
        for (int i4 = 0; i4 < result.passes.length; ++i4) {
            sum += result.passes[i4];
        }
        result.passesTotal = sum;
        if (!isHotrun) {
            result.index = this.calcIndex(result.passes, result.runTimes, this.gaugeIndex, this.calibrate);
        }
        result.testTime = totalTime;
        return result;
    }

    class EncoderTestThread
    extends Thread {
        private final FSIImage[] imageSelector = new FSIImage[100];
        long passes = 0L;
        private volatile boolean running;

        EncoderTestThread(int thread, FSIImage[] images, int[] ratio) {
            int h = 0;
            int s = 0;
            for (int i = 0; i < ratio.length; ++i) {
                s += ratio[i];
                FSIImage slice = images[i].createSlice();
                for (int x = h; x < s; ++x) {
                    this.imageSelector[x] = slice;
                }
                h += ratio[i];
            }
            this.setName("EncoderTestThread-" + thread);
        }

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                try {
                    int pNum = (int)(this.passes % 100L);
                    this.encodeJPEG(this.imageSelector[pNum]);
                    ++this.passes;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    break;
                }
            }
        }

        public void halt() {
            this.running = false;
        }

        public void reset() {
            this.passes = 0L;
        }

        private void encodeJPEG(FSIImage image) throws IOException {
            try (MemoryCacheImageOutputStream mcios = new MemoryCacheImageOutputStream(new ByteArrayOutputStreamFast(1024));){
                JPEGEncoder jencoder = new JPEGEncoder(TestEncoder.this.logger, TestEncoder.this.jpegPreparation);
                jencoder.setImage(image);
                jencoder.setImageOutputStream(mcios);
                jencoder.encode();
                jencoder.dispose();
            }
        }
    }
}

