/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserverbenchmark.TestBenchmarkFramework;
import com.neptunelabs.fsiserverbenchmark.ThreadSettings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.concurrent.atomic.AtomicInteger;

final class TestIO
extends TestBenchmarkFramework {
    final Path workDir;
    private final int[] gaugeIndex = new int[]{32, 32};
    final StorageHelperV1002 helper;
    AtomicInteger ioCounter = new AtomicInteger(0);
    private IOThread[] t = null;

    public TestIO(String name, FSILogger logger, Path workDir, ThreadSettings threadSettings) {
        super(name, logger, threadSettings);
        this.rand.setSeed(348723487L);
        this.workDir = workDir.resolve("io");
        this.helper = new StorageHelperV1002(StorageHelperV1002.Hasher.CRC32, this.workDir);
    }

    @Override
    public void dispose() {
        super.dispose();
        try {
            FileOperations.deleteDir(this.workDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.t != null) {
            for (IOThread thread : this.t) {
                if (thread == null) continue;
                thread.halt();
            }
            for (IOThread thread : this.t) {
                try {
                    if (thread == null) continue;
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    TestBenchmarkFramework.SubTestResult doInnerTest(int testThreads, long runTime, boolean isHotrun) throws IOException {
        int i;
        int i2;
        long cTime;
        TestBenchmarkFramework.SubTestResult result = new TestBenchmarkFramework.SubTestResult();
        this.t = new IOThread[testThreads];
        result.passes = new long[testThreads];
        result.runTimes = new long[testThreads];
        long startTime = System.currentTimeMillis();
        long stopTime = System.currentTimeMillis() + runTime;
        int usedThreads = 0;
        long nextThreadTime = System.currentTimeMillis();
        long subTime = 0L;
        long subStartTime = 0L;
        float slice = (float)runTime / (float)testThreads;
        boolean hasPrintedHotrunSymbols = false;
        while ((cTime = System.currentTimeMillis()) < stopTime || this.stop) {
            if (cTime > nextThreadTime) {
                int i3;
                if (isHotrun && !hasPrintedHotrunSymbols) {
                    System.out.print("H");
                    hasPrintedHotrunSymbols = true;
                } else if (!isHotrun) {
                    String x = Integer.toHexString(usedThreads + 1);
                    System.out.print(x.substring(x.length() - 1).toUpperCase());
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    this.t[i3].halt();
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    try {
                        this.t[i3].join();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (usedThreads > 0) {
                    subTime = System.currentTimeMillis() - subStartTime;
                }
                long passes = 0L;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    passes += this.t[i2].passes;
                    if (!this.t[i2].threadError) continue;
                    this.error = true;
                    this.stop = true;
                }
                if (usedThreads > 0) {
                    result.passes[usedThreads - 1] = passes;
                    result.runTimes[usedThreads - 1] = subTime;
                }
                ++usedThreads;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2] = new IOThread(i2);
                }
                nextThreadTime = startTime + (long)((float)usedThreads * slice);
                subStartTime = System.currentTimeMillis();
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2].start();
                }
            }
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException passes) {
                // empty catch block
            }
            Thread.yield();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            this.t[i].halt();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            try {
                this.t[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!this.error) {
            if (usedThreads > 0) {
                subTime = System.currentTimeMillis() - subStartTime;
            }
            long passes = 0L;
            for (i2 = 0; i2 < usedThreads; ++i2) {
                passes += this.t[i2].passes;
            }
            if (usedThreads > 0) {
                result.passes[usedThreads - 1] = passes;
                result.runTimes[usedThreads - 1] = subTime;
            }
            long totalTime = System.currentTimeMillis() - startTime;
            long sum = 0L;
            for (int i4 = 0; i4 < result.passes.length; ++i4) {
                sum += result.passes[i4];
            }
            result.passesTotal = sum;
            if (!isHotrun) {
                result.index = this.calcIndex(result.passes, result.runTimes, this.gaugeIndex, this.calibrate);
            }
            result.testTime = totalTime;
        } else {
            result.error = this.error;
        }
        return result;
    }

    class IOThread
    extends Thread {
        long passes = 0L;
        final int thread;
        long sysTime = 0L;
        long sysSize = 0L;
        boolean threadError = false;
        private boolean running = false;

        IOThread(int thread) {
            this.setName("IOTestThread-" + thread);
            this.thread = thread;
        }

        @Override
        public void run() {
            this.running = true;
            Path targetPath = null;
            byte[] data = new byte[262144];
            TestIO.this.rand.nextBytes(data);
            ByteBuffer bb = ByteBuffer.allocateDirect(262144);
            bb.put(data);
            bb.flip();
            Path[] paths = new Path[25];
            EnumSet<StandardOpenOption> rwSet = EnumSet.of(StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.SYNC);
            EnumSet<StandardOpenOption> roSet = EnumSet.of(StandardOpenOption.READ);
            while (this.running) {
                Throwable throwable;
                SeekableByteChannel channel;
                int c;
                Path cDir = TestIO.this.workDir.resolve(Integer.toString(TestIO.this.ioCounter.addAndGet(1)));
                for (c = 0; c < paths.length; ++c) {
                    paths[c] = cDir.resolve(c + ".tmp");
                }
                for (c = 0; c < paths.length; ++c) {
                    targetPath = paths[c];
                    try {
                        Path parentPath = targetPath.getParent();
                        if (!Files.exists(parentPath, new LinkOption[0])) {
                            Files.createDirectories(parentPath, new FileAttribute[0]);
                        }
                        channel = Files.newByteChannel(targetPath, rwSet, new FileAttribute[0]);
                        throwable = null;
                        try {
                            bb.rewind();
                            channel.write(bb);
                            bb.flip();
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (channel != null) {
                                if (throwable != null) {
                                    try {
                                        channel.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                } else {
                                    channel.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        this.threadError = true;
                        this.running = false;
                        e.printStackTrace();
                        break;
                    }
                }
                for (c = 0; c < paths.length; ++c) {
                    targetPath = paths[c];
                    try {
                        this.sysTime ^= Files.getLastModifiedTime(targetPath, new LinkOption[0]).toMillis();
                        this.sysSize ^= Files.size(targetPath);
                        continue;
                    }
                    catch (IOException e) {
                        this.threadError = true;
                        this.running = false;
                        e.printStackTrace();
                        break;
                    }
                }
                for (c = 0; c < paths.length; ++c) {
                    targetPath = paths[c];
                    try {
                        channel = Files.newByteChannel(targetPath, roSet, new FileAttribute[0]);
                        throwable = null;
                        try {
                            bb.rewind();
                            channel.read(bb);
                            bb.flip();
                            continue;
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (channel != null) {
                                if (throwable != null) {
                                    try {
                                        channel.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    channel.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        this.threadError = true;
                        this.running = false;
                        e.printStackTrace();
                        break;
                    }
                }
                for (c = 0; c < paths.length; ++c) {
                    targetPath = paths[c];
                    try {
                        Files.delete(targetPath);
                        continue;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                try {
                    Files.delete(cDir);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++this.passes;
            }
        }

        public void halt() {
            this.running = false;
        }
    }
}

