/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserverbenchmark.TestBenchmarkFramework;
import com.neptunelabs.fsiserverbenchmark.ThreadSettings;
import com.neptunelabs.imagereader.image.FSIImage;
import com.neptunelabs.imagereader.image.FSIImageLimited;
import com.neptunelabs.imagereader.image.FSIImageMode;
import com.neptunelabs.imagereader.image.FSIImageUnlimited;
import java.io.IOException;

final class TestImage
extends TestBenchmarkFramework {
    private ImageTestThread[] t = null;
    private final FSIImage[] images;
    private final int width = 2048;
    private final int height = 2048;
    private final int[] gaugeIndex = new int[]{2065, 2065, 2067};

    public TestImage(String name, FSILogger logger, SwapPool swapPool, ThreadSettings threadSettings) {
        super(name, logger, threadSettings);
        this.images = new FSIImage[threadSettings.fullThreads];
        for (int ti = 0; ti < threadSettings.fullThreads; ++ti) {
            FSIImageLimited image = new FSIImageLimited(logger, swapPool, this.byteOrder, 2048, 2048, null, FSIImageMode.ARGB);
            if (image instanceof FSIImageUnlimited && this.images[ti].isMapped()) {
                this.error = true;
                this.errorMessage = "Not enought RAM for Image test";
                break;
            }
            long len = image.getIntSize();
            ((FSIImage)image).setPosition(0L);
            int p = 0;
            while ((long)p < len) {
                ((FSIImage)image).setSample(p);
                ++p;
            }
            this.images[ti] = image;
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (int tc = 0; tc < this.threadSettings.fullThreads; ++tc) {
            if (this.images[tc] == null) continue;
            this.images[tc].dispose();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.t != null) {
            for (ImageTestThread thread : this.t) {
                if (thread == null) continue;
                thread.halt();
            }
            for (ImageTestThread thread : this.t) {
                try {
                    if (thread == null) continue;
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    TestBenchmarkFramework.SubTestResult doInnerTest(int testThreads, long runTime, boolean isHotrun) throws IOException {
        int i;
        int i2;
        long cTime;
        TestBenchmarkFramework.SubTestResult result = new TestBenchmarkFramework.SubTestResult();
        this.t = new ImageTestThread[testThreads];
        result.passes = new long[testThreads];
        result.runTimes = new long[testThreads];
        long startTime = System.currentTimeMillis();
        long stopTime = System.currentTimeMillis() + runTime;
        int usedThreads = 0;
        long nextThreadTime = System.currentTimeMillis();
        long subTime = 0L;
        long subStartTime = 0L;
        float slice = (float)runTime / (float)testThreads;
        boolean hasPrintedHotrunSymbols = false;
        while ((cTime = System.currentTimeMillis()) < stopTime || this.stop) {
            if (cTime > nextThreadTime) {
                int i3;
                if (isHotrun && !hasPrintedHotrunSymbols) {
                    System.out.print("H");
                    hasPrintedHotrunSymbols = true;
                } else if (!isHotrun) {
                    String x = Integer.toHexString(usedThreads + 1);
                    System.out.print(x.substring(x.length() - 1).toUpperCase());
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    this.t[i3].halt();
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    try {
                        this.t[i3].join();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (usedThreads > 0) {
                    subTime = System.currentTimeMillis() - subStartTime;
                }
                long passes = 0L;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    passes += this.t[i2].passes;
                }
                if (usedThreads > 0) {
                    result.passes[usedThreads - 1] = passes;
                    result.runTimes[usedThreads - 1] = subTime;
                }
                ++usedThreads;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2] = new ImageTestThread(i2, this.images[i2].createSlice());
                }
                nextThreadTime = startTime + (long)((float)usedThreads * slice);
                subStartTime = System.currentTimeMillis();
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2].start();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException passes) {
                // empty catch block
            }
            Thread.yield();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            this.t[i].halt();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            try {
                this.t[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (usedThreads > 0) {
            subTime = System.currentTimeMillis() - subStartTime;
        }
        long passes = 0L;
        for (i2 = 0; i2 < usedThreads; ++i2) {
            passes += this.t[i2].passes;
        }
        if (usedThreads > 0) {
            result.passes[usedThreads - 1] = passes;
            result.runTimes[usedThreads - 1] = subTime;
        }
        long totalTime = System.currentTimeMillis() - startTime;
        long sum = 0L;
        for (int i4 = 0; i4 < result.passes.length; ++i4) {
            sum += result.passes[i4];
        }
        result.passesTotal = sum;
        if (!isHotrun) {
            result.index = this.calcIndex(result.passes, result.runTimes, this.gaugeIndex, this.calibrate);
        }
        result.testTime = totalTime;
        return result;
    }

    static class ImageTestThread
    extends Thread {
        private final FSIImage image;
        long passes = 0L;
        private volatile boolean running;

        ImageTestThread(int thread, FSIImage image) {
            this.image = image;
            this.setName("ImageTestThread-" + thread);
        }

        @Override
        public void run() {
            this.running = true;
            int lwidth = this.image.getWidth();
            int lwidth2 = this.image.getWidth() / 2;
            int lheight = this.image.getHeight();
            int ysteps = 16;
            int height16 = lheight / 16;
            int y1 = 0;
            int y2 = height16;
            while (this.running) {
                for (int ys = 0; ys < 16; ++ys) {
                    y1 = ys * height16;
                    y2 = y1 + height16;
                    int x2 = lwidth2;
                    for (int x = 0; x < lwidth; ++x) {
                        for (int y = y1; y < y2; ++y) {
                            this.image.setSample(x2, y, this.image.getSample(x, y));
                        }
                    }
                    ++this.passes;
                }
            }
        }

        public void halt() {
            this.running = false;
        }

        public void reset() {
            this.passes = 0L;
        }
    }
}

