/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserverbenchmark.TestBenchmarkFramework;
import com.neptunelabs.fsiserverbenchmark.ThreadSettings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.EnumSet;

final class TestStorage
extends TestBenchmarkFramework {
    final ArrayList<Pair<Path, Integer>> ioFileList;
    private final int[] gaugeIndex = new int[]{2438, 2471, 2437};
    private StorageThread[] t = null;

    public TestStorage(String name, FSILogger logger, ArrayList<Pair<Path, Integer>> ioFileList, ThreadSettings threadSettings) {
        super(name, logger, threadSettings);
        this.rand.setSeed(348723487L);
        this.ioFileList = ioFileList;
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void stop() {
        super.stop();
        if (this.t != null) {
            for (StorageThread thread : this.t) {
                if (thread == null) continue;
                thread.halt();
            }
            for (StorageThread thread : this.t) {
                try {
                    if (thread == null) continue;
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    TestBenchmarkFramework.SubTestResult doInnerTest(int testThreads, long runTime, boolean isHotrun) throws IOException {
        int i;
        int i2;
        long cTime;
        TestBenchmarkFramework.SubTestResult result = new TestBenchmarkFramework.SubTestResult();
        this.t = new StorageThread[testThreads];
        result.passes = new long[testThreads];
        result.runTimes = new long[testThreads];
        long startTime = System.currentTimeMillis();
        long stopTime = System.currentTimeMillis() + runTime;
        int usedThreads = 0;
        long nextThreadTime = System.currentTimeMillis();
        long subTime = 0L;
        long subStartTime = 0L;
        float slice = (float)runTime / (float)testThreads;
        boolean hasPrintedHotrunSymbols = false;
        while ((cTime = System.currentTimeMillis()) < stopTime || this.stop) {
            if (cTime > nextThreadTime) {
                int i3;
                if (isHotrun && !hasPrintedHotrunSymbols) {
                    System.out.print("H");
                    hasPrintedHotrunSymbols = true;
                } else if (!isHotrun) {
                    String x = Integer.toHexString(usedThreads + 1);
                    System.out.print(x.substring(x.length() - 1).toUpperCase());
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    this.t[i3].halt();
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    try {
                        this.t[i3].join();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (usedThreads > 0) {
                    subTime = System.currentTimeMillis() - subStartTime;
                }
                long passes = 0L;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    passes += this.t[i2].passes;
                }
                if (usedThreads > 0) {
                    result.passes[usedThreads - 1] = passes;
                    result.runTimes[usedThreads - 1] = subTime;
                }
                ++usedThreads;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2] = new StorageThread(i2);
                }
                nextThreadTime = startTime + (long)((float)usedThreads * slice);
                subStartTime = System.currentTimeMillis();
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2].start();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException passes) {}
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            this.t[i].halt();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            try {
                this.t[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (usedThreads > 0) {
            subTime = System.currentTimeMillis() - subStartTime;
        }
        long passes = 0L;
        for (i2 = 0; i2 < usedThreads; ++i2) {
            passes += this.t[i2].passes;
        }
        if (usedThreads > 0) {
            result.passes[usedThreads - 1] = passes;
            result.runTimes[usedThreads - 1] = subTime;
        }
        long totalTime = System.currentTimeMillis() - startTime;
        long sum = 0L;
        for (int i4 = 0; i4 < result.passes.length; ++i4) {
            sum += result.passes[i4];
        }
        result.passesTotal = sum;
        if (!isHotrun) {
            result.index = this.calcIndex(result.passes, result.runTimes, this.gaugeIndex, this.calibrate);
        }
        result.testTime = totalTime;
        return result;
    }

    class StorageThread
    extends Thread {
        long passes = 0L;
        long readed = 0L;
        private static final int bufferLen = 262144;
        private final ByteBuffer dst;
        private boolean running = false;

        StorageThread(int thread) {
            this.setName("StorageTestThread-" + thread);
            this.dst = ByteBuffer.allocateDirect(262144);
        }

        @Override
        public void run() {
            this.running = true;
            int maxLength = 0;
            int maxFiles = TestStorage.this.ioFileList.size();
            EnumSet<StandardOpenOption> access = EnumSet.of(StandardOpenOption.READ);
            while (this.running) {
                Pair<Path, Integer> pF = TestStorage.this.ioFileList.get(TestStorage.this.rand.nextInt(maxFiles));
                try (SeekableByteChannel channel = Files.newByteChannel(pF.getItem1(), access, new FileAttribute[0]);){
                    maxLength = pF.getItem2();
                    int count = TestStorage.this.rand.nextInt(25) + 4;
                    int startPos = TestStorage.this.rand.nextInt(maxLength - 262144 - 1);
                    channel.position(startPos);
                    for (int c = 0; c < count; ++c) {
                        this.dst.clear();
                        int read = channel.read(this.dst);
                        if (read == 0) {
                            break;
                        }
                        this.readed += (long)read;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.running = false;
                }
                ++this.passes;
            }
        }

        public void halt() {
            this.running = false;
        }
    }
}

