/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiserverbenchmark.TestBenchmarkFramework;
import com.neptunelabs.fsiserverbenchmark.ThreadSettings;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Cleaner;
import sun.nio.ch.DirectBuffer;

final class TestSwap
extends TestBenchmarkFramework {
    private SwapTestThread[] t = null;
    private Path tempFile = null;
    private FileChannel channel;
    private int filesize;
    private int fileintsize;
    private ByteBuffer buffer;
    private final int[] gaugeIndex = new int[]{256, 257, 255};

    public TestSwap(String name, FSILogger logger, Path workDir, ThreadSettings threadSettings) {
        super(name, logger, threadSettings);
        try {
            this.tempFile = Files.createTempFile(workDir, "swap", ".tmp", new FileAttribute[0]);
            this.channel = (FileChannel)Files.newByteChannel(this.tempFile, StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.DELETE_ON_CLOSE);
            this.channel.force(false);
            this.filesize = 0x40000000;
            this.fileintsize = this.filesize / 4;
            this.buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, 0L, this.filesize);
            this.buffer.order(ByteOrder.nativeOrder());
        }
        catch (IOException e) {
            this.error = true;
            this.errorMessage = e.getLocalizedMessage();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.buffer != null) {
            try {
                this.unmap(this.buffer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.tempFile != null) {
            try {
                Files.deleteIfExists(this.tempFile);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void unmap(final ByteBuffer myBuffer) throws Exception {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Cleaner cl;
                if (myBuffer instanceof DirectBuffer && (cl = ((DirectBuffer)((Object)myBuffer)).cleaner()) != null) {
                    cl.clean();
                }
                return null;
            }
        });
    }

    @Override
    public void stop() {
        super.stop();
        if (this.t != null) {
            for (SwapTestThread thread : this.t) {
                if (thread == null) continue;
                thread.halt();
            }
            for (SwapTestThread thread : this.t) {
                try {
                    if (thread == null) continue;
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    TestBenchmarkFramework.SubTestResult doInnerTest(int testThreads, long runTime, boolean isHotrun) throws IOException {
        int i;
        int i2;
        long cTime;
        TestBenchmarkFramework.SubTestResult result = new TestBenchmarkFramework.SubTestResult();
        this.t = new SwapTestThread[testThreads];
        result.passes = new long[testThreads];
        result.runTimes = new long[testThreads];
        long startTime = System.currentTimeMillis();
        long stopTime = System.currentTimeMillis() + runTime;
        int usedThreads = 0;
        long nextThreadTime = System.currentTimeMillis();
        long subTime = 0L;
        long subStartTime = 0L;
        float slice = (float)runTime / (float)testThreads;
        boolean hasPrintedHotrunSymbols = false;
        while ((cTime = System.currentTimeMillis()) < stopTime || this.stop) {
            if (cTime > nextThreadTime) {
                int i3;
                if (isHotrun && !hasPrintedHotrunSymbols) {
                    System.out.print("H");
                    hasPrintedHotrunSymbols = true;
                } else if (!isHotrun) {
                    String x = Integer.toHexString(usedThreads + 1);
                    System.out.print(x.substring(x.length() - 1).toUpperCase());
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    this.t[i3].halt();
                }
                for (i3 = 0; i3 < usedThreads; ++i3) {
                    try {
                        this.t[i3].join();
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (usedThreads > 0) {
                    subTime = System.currentTimeMillis() - subStartTime;
                }
                long passes = 0L;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    passes += this.t[i2].passes;
                }
                if (usedThreads > 0) {
                    result.passes[usedThreads - 1] = passes;
                    result.runTimes[usedThreads - 1] = subTime;
                }
                ++usedThreads;
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2] = new SwapTestThread(this.buffer.asIntBuffer().slice(), i2, this.fileintsize / testThreads * i2, this.fileintsize / testThreads);
                }
                nextThreadTime = startTime + (long)((float)usedThreads * slice);
                subStartTime = System.currentTimeMillis();
                for (i2 = 0; i2 < usedThreads; ++i2) {
                    this.t[i2].start();
                }
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException passes) {
                // empty catch block
            }
            Thread.yield();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            this.t[i].halt();
        }
        for (i = 0; i < testThreads; ++i) {
            if (this.t[i] == null) continue;
            try {
                this.t[i].join();
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (usedThreads > 0) {
            subTime = System.currentTimeMillis() - subStartTime;
        }
        long passes = 0L;
        for (i2 = 0; i2 < usedThreads; ++i2) {
            passes += this.t[i2].passes;
        }
        if (usedThreads > 0) {
            result.passes[usedThreads - 1] = passes;
            result.runTimes[usedThreads - 1] = subTime;
        }
        long totalTime = System.currentTimeMillis() - startTime;
        long sum = 0L;
        for (int i4 = 0; i4 < result.passes.length; ++i4) {
            sum += result.passes[i4];
        }
        result.passesTotal = sum;
        if (!isHotrun) {
            result.index = this.calcIndex(result.passes, result.runTimes, this.gaugeIndex, this.calibrate);
        }
        result.testTime = totalTime;
        return result;
    }

    class SwapTestThread
    extends Thread {
        private final IntBuffer threadBuffer;
        private final int startPos;
        long passes = 0L;
        private final int bufferLength = 4096;
        private final int[] readBuffer;
        private final int[] writeBuffer;
        private final int sizePerThread;
        private final int thread;
        private boolean running;

        SwapTestThread(IntBuffer buffer, int thread, int startPos, int length) {
            this.threadBuffer = buffer;
            this.thread = thread;
            this.startPos = startPos;
            this.readBuffer = new int[4096];
            this.writeBuffer = new int[4096];
            for (int x = 0; x < 4096; ++x) {
                this.writeBuffer[x] = TestSwap.this.rand.nextInt();
            }
            this.sizePerThread = length;
            this.setName("SwapTestThread-" + thread);
        }

        @Override
        public void run() {
            this.running = true;
            int getMod = this.sizePerThread - this.readBuffer.length - 1;
            int fixFactorRead = 256000 * this.thread;
            int fixFactorWrite = 384000 * this.thread;
            int vWidth = 1000;
            while (this.running) {
                for (int x = 0; x < 1000; ++x) {
                    if (x % 2 == 0) {
                        this.threadBuffer.position((int)(((long)fixFactorRead + this.passes * (long)x * 4096L) % (long)getMod) + this.startPos);
                        this.threadBuffer.get(this.readBuffer);
                        continue;
                    }
                    this.threadBuffer.position((int)(((long)fixFactorWrite + this.passes * (long)x * 4096L) % (long)getMod) + this.startPos);
                    this.threadBuffer.put(this.writeBuffer);
                }
                ++this.passes;
            }
        }

        public void halt() {
            this.running = false;
        }

        public void reset() {
            this.passes = 0L;
        }
    }
}

