/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.DateFormatter;
import com.neptunelabs.fsiframework.helpers.FormatBytes;
import com.neptunelabs.fsiframework.helpers.swap.SwapPool;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PluginLoader;
import com.neptunelabs.fsiframework.logging.ConsoleLogHandler;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiframework.systeminformation.JavaInformation;
import com.neptunelabs.fsiframework.systeminformation.SystemInformation;
import com.neptunelabs.fsiserver.utils.NotConfiguredException;
import com.neptunelabs.fsiserver.utils.StorageHelperV1002;
import com.neptunelabs.fsiserver.utils.Version;
import com.neptunelabs.fsiserverbenchmark.Formatter;
import com.neptunelabs.fsiserverbenchmark.OutputFormat;
import com.neptunelabs.fsiserverbenchmark.ShutdownThread;
import com.neptunelabs.fsiserverbenchmark.SingleTestResult;
import com.neptunelabs.fsiserverbenchmark.TestBenchmarkFramework;
import com.neptunelabs.fsiserverbenchmark.TestCache;
import com.neptunelabs.fsiserverbenchmark.TestEncoder;
import com.neptunelabs.fsiserverbenchmark.TestIO;
import com.neptunelabs.fsiserverbenchmark.TestImage;
import com.neptunelabs.fsiserverbenchmark.TestStorage;
import com.neptunelabs.fsiserverbenchmark.TestSwap;
import com.neptunelabs.fsiserverbenchmark.ThreadSettings;
import com.neptunelabs.fsiserverbenchmark.TotalTestResult;
import java.io.BufferedWriter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

public final class Tester {
    boolean stopped = false;
    FSILogger logger;
    SwapPool swapPool;
    TestBenchmarkFramework currentTest;
    ThreadSettings threadSettings;
    private static final int TEST_CACHE = 0;
    private static final int TEST_IMAGE = 1;
    private static final int TEST_ENCODER = 2;
    private static final int TEST_SWAP = 3;
    private static final int TEST_IO = 4;
    private static final int TEST_STORAGE = 5;
    private static final DecimalFormat dcdots = new DecimalFormat("###,###");
    private static final DecimalFormat dcdotsf = new DecimalFormat("###,###.00");
    private static boolean doOutput;
    private int threads;
    private int priority;
    private OutputFormat format;
    private long runTime;
    private boolean doHotRun;
    private boolean doFullRun;
    private boolean doTestCache;
    private boolean doTestFSIImageLimited;
    private boolean doTestSwap;
    private boolean doTestEncoder;
    private boolean doTestIO;
    private boolean doTestStorage;
    private Path workDirBase;
    private Path resultFile;
    private boolean verbose;
    private boolean calibrate;

    public void setThreads(int value) {
        this.threads = value;
    }

    public void setPriority(int value) {
        this.priority = value;
    }

    public void setOutputFormat(OutputFormat value) {
        this.format = value;
    }

    public void setRunTime(long value) {
        this.runTime = value;
    }

    public void setDoHotRun(boolean value) {
        this.doHotRun = value;
    }

    public void setDoFullRun(boolean value) {
        this.doFullRun = value;
    }

    public void setDoTestCache(boolean value) {
        this.doTestCache = value;
    }

    public void setDoTestFSIImageLimited(boolean value) {
        this.doTestFSIImageLimited = value;
    }

    public void setDoTestSwap(boolean value) {
        this.doTestSwap = value;
    }

    public void setDoTestEncoder(boolean value) {
        this.doTestEncoder = value;
    }

    public void setDoTestIO(boolean value) {
        this.doTestIO = value;
    }

    public void setDoTestStorage(boolean value) {
        this.doTestStorage = value;
    }

    public void setWorkDirBase(Path value) {
        this.workDirBase = value;
    }

    public void setResultFile(Path value) {
        this.resultFile = value;
    }

    public void setVerbose(boolean value) {
        this.verbose = value;
    }

    public void setCalibrate(boolean value) {
        this.calibrate = value;
    }

    public void setDoOutput(boolean value) {
        doOutput = value;
    }

    public void benchmark() {
        Path workDirWrite = this.workDirBase.resolve("benchmark_prepare");
        Path workDirRead = this.workDirBase.resolve("benchmark");
        Path storageDirWrite = workDirWrite;
        Path storageDirRead = workDirRead;
        ShutdownThread shutdownThread = new ShutdownThread(this, this.doTestStorage, workDirWrite, workDirRead);
        Runtime.getRuntime().addShutdownHook(shutdownThread);
        TotalTestResult tests = new TotalTestResult(this.runTime, this.calibrate, this.doHotRun, this.doFullRun, this.threads, this.priority, this.workDirBase);
        HashMap<String, String> strings = tests.strings;
        long hotRunTime = 10000L;
        long runTimeAdd = 0L;
        ArrayList<Pair<Path, Integer>> ioFileList = null;
        if (!this.stopped && this.doTestStorage) {
            Tester.print("Preparing Storage Test ");
            ioFileList = new ArrayList<Pair<Path, Integer>>();
            Random rand = new Random(2323L);
            ByteBuffer src = ByteBuffer.allocateDirect(0x100000);
            for (int b = 0; b < src.capacity(); ++b) {
                src.put((byte)(rand.nextInt() & 0xFF));
            }
            try {
                int fileCount = 3000;
                float nDot = 300.0f;
                Tester.print("[");
                int c = 300;
                int d = 10;
                FileOperations.deleteDir(workDirWrite);
                FileOperations.deleteDir(workDirRead);
                StorageHelperV1002 helperWrite = new StorageHelperV1002(StorageHelperV1002.Hasher.CRC32, storageDirWrite);
                StorageHelperV1002 helperRead = new StorageHelperV1002(StorageHelperV1002.Hasher.CRC32, storageDirRead);
                int f = 0;
                while (f < 3000) {
                    int maxLength;
                    String name = "testing/eis_" + rand.nextLong() + ".eis";
                    Path fileWrite = helperWrite.getEisFile(name);
                    Path fileRead = helperRead.getEisFile(name);
                    Path fileWriteParent = fileWrite.getParent();
                    if (!Files.exists(fileWriteParent, new LinkOption[0])) {
                        Files.createDirectories(fileWriteParent, new FileAttribute[0]);
                    }
                    try (SeekableByteChannel channel = Files.newByteChannel(fileWrite, EnumSet.of(StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE), new FileAttribute[0]);){
                        int x = f % 8 + 1;
                        maxLength = x * 1024 * 1024;
                        channel.position(0L);
                        for (int i = 0; i < x; ++i) {
                            src.position(0);
                            channel.write(src);
                        }
                    }
                    ioFileList.add(new Pair<Path, Integer>(fileRead, maxLength));
                    if ((float)c > 300.0f) {
                        c = 0;
                        Tester.print(--d);
                    }
                    ++f;
                    ++c;
                }
                FileOperations.move(workDirWrite, workDirRead);
                Tester.println("]");
            }
            catch (NotConfiguredException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                Tester.println("]\nIO Test preparation failed: " + e.getLocalizedMessage());
                this.stopped = true;
            }
        }
        SoftwareVersion.setSoftware(null, new Version());
        Tester.println(Formatter.printPair((String)strings.get("txtBenchmarkVersion"), strings.get("resBenchmarkVersion"), ":", 25));
        SystemInformation sysinfo = new SystemInformation();
        if (!this.stopped) {
            if (this.calibrate) {
                Tester.println(Formatter.printPair("Calibrate Mode", "on", ":", 25));
            }
            Tester.println(Formatter.printPair("Java", sysinfo.getJVMInformation(), ":", 25));
            Tester.println(Formatter.printPair("Java Version", sysinfo.getJVMVersionDetailed(), ":", 25));
            if (sysinfo.is64()) {
                Tester.println(Formatter.printPair("Data Model", "64 Bit", ":", 25));
            } else {
                Tester.println(Formatter.printPair("Data Model", "32 Bit", ":", 25));
            }
            JavaInformation ji = new JavaInformation();
            List<String> aList = ji.getStartOptions();
            StringBuilder vmOpts = new StringBuilder();
            for (int i = 0; i < aList.size(); ++i) {
                vmOpts.append(aList.get(i));
                if (i >= aList.size() - 1) continue;
                vmOpts.append(' ');
            }
            Tester.println(Formatter.printPair("VM Options", vmOpts.toString(), ":", 25));
            Tester.println(Formatter.printPair("Runtime", (int)(this.runTime / 1000L), ":", 25));
            Tester.println(Formatter.printPair("Sub tests", (this.doHotRun ? "H" : "") + (this.doFullRun ? "F" : ""), ":", 25));
            Tester.println(Formatter.drawLine(68));
            Tester.println(Formatter.printPair("OS", sysinfo.getOperationSystemString(), ":", 25));
            if (this.threads == sysinfo.getProcessors()) {
                Tester.println(Formatter.printPair("CPU Threads", Integer.toString(sysinfo.getProcessors()), ":", 25));
            } else {
                Tester.println(Formatter.printPair("CPU Threads", this.threads + "(" + Integer.toString(sysinfo.getProcessors()) + ")", ":", 25));
            }
            if (this.priority == 1) {
                Tester.println(Formatter.printPair("Thread Priority", "min", ":", 25));
            } else if (this.priority == 5) {
                Tester.println(Formatter.printPair("Thread Priority", "norm", ":", 25));
            } else if (this.priority == 10) {
                Tester.println(Formatter.printPair("Thread Priority", "max", ":", 25));
            }
            long max = Runtime.getRuntime().maxMemory();
            Tester.println(Formatter.printPair("VM RAM Max", FormatBytes.byteToString(max, 3, 1), ":", 25));
            Tester.println(Formatter.drawLine(68));
            Tester.println(Formatter.printPair("Working Dir", this.workDirBase.toAbsolutePath(), ":", 25));
            Tester.println(Formatter.drawLine(68));
            try {
                InetAddress addr = InetAddress.getLocalHost();
                Tester.println(Formatter.printPair("IP", addr.getHostAddress(), ":", 25));
                Tester.println(Formatter.printPair("Hostname", addr.getCanonicalHostName(), ":", 25));
            }
            catch (UnknownHostException addr) {
                // empty catch block
            }
            Tester.println(Formatter.printPair("Date/Time", DateFormatter.toRFC2822(System.currentTimeMillis()), ":", 25));
            Tester.println(Formatter.drawLine(68));
            int testsCount = 0;
            if (this.doTestCache) {
                ++testsCount;
            }
            if (this.doTestFSIImageLimited) {
                ++testsCount;
            }
            if (this.doTestSwap) {
                ++testsCount;
            }
            if (this.doTestEncoder) {
                ++testsCount;
            }
            if (this.doTestIO) {
                ++testsCount;
            }
            if (this.doTestStorage) {
                ++testsCount;
            }
            int subTestCount = 0;
            if (this.doFullRun) {
                ++subTestCount;
            }
            long baseTime = this.doHotRun ? 10000L * (long)testsCount : 0L;
            baseTime += (long)(testsCount * subTestCount) * this.runTime + 0L;
            baseTime = Math.round((float)baseTime / 1000.0f);
            String estTime = Formatter.secToTime(baseTime, false, true);
            Tester.println(Formatter.printPair("Estimated Benchmark Time", estTime, ":", 25));
            Tester.println(Formatter.drawLine(68));
        }
        try {
            boolean printTotalIndex;
            Path pluginBaseDir;
            ConsoleLogHandler handler = new ConsoleLogHandler();
            handler.setTalkness(false, false);
            this.logger = new FSILogger(handler, "com/neptunelabs/fsiserver/resources/log4j_codes.properties");
            this.logger.addCodes("com/neptunelabs/fsiframework/resources/log4j_codes.properties");
            this.logger.addCodes("com/neptunelabs/fsiservletframework/resources/log4j_codes.properties");
            this.logger.addCodes("com/neptunelabs/imagereader/resources/log4j_codes.properties");
            this.logger.addCodes("com/neptunelabs/imagemanipulator/resources/log4j_codes.properties");
            this.logger.start();
            this.swapPool = new SwapPool(this.logger, this.workDirBase);
            String pluginBaseDirStr = System.getProperty("com.neptunelabs.fsiserver.plugin.home");
            if (pluginBaseDirStr != null) {
                pluginBaseDir = Paths.get(pluginBaseDirStr, new String[0]);
                if (!Files.isDirectory(pluginBaseDir, new LinkOption[0])) {
                    pluginBaseDir = null;
                }
            } else {
                pluginBaseDir = null;
            }
            pluginBaseDir = Paths.get("..", new String[0]).resolve("internal").resolve("plugins");
            PluginLoader pluginLoader = new PluginLoader(this.logger, null, sysinfo);
            List<String> pluginList = PluginLoader.scanForPlugins(pluginBaseDir);
            for (String plugin : pluginList) {
                pluginLoader.loadPlugin(pluginBaseDir, plugin, "RequestProcessor");
            }
            pluginLoader.loadPlugin(Paths.get("../ImageReader/plugins", new String[0]), "turbojpeg", "SourceManager");
            this.threadSettings = new ThreadSettings(this.threads);
            int totalIndexSYS = Integer.MAX_VALUE;
            int totalIndexIO = Integer.MAX_VALUE;
            long totalTime = 0L;
            int totalTests = 0;
            if (!this.stopped && this.doTestCache) {
                this.currentTest = new TestCache("Cache", this.logger, this.threadSettings);
                this.currentTest.setVerbose(this.verbose);
                this.currentTest.setHotRunTime(10000L);
                this.currentTest.setRunTime(this.runTime);
                this.currentTest.setThreadSettings(this.doHotRun, this.doFullRun);
                this.currentTest.setThreads(this.threads);
                this.currentTest.setCalibrate(this.calibrate);
                this.currentTest.test();
                tests.results[0] = this.currentTest.getBenchmarkResult();
                totalIndexSYS = Math.min(totalIndexSYS, tests.results[0].getIndex());
                totalTime += tests.results[0].getTime();
                ++totalTests;
                this.currentTest.dispose();
                this.currentTest = null;
                System.gc();
                Tester.println(Tester.printResult(tests.results[0], this.verbose));
                Tester.println(Formatter.drawLine(68));
            }
            if (!this.stopped && this.doTestFSIImageLimited) {
                this.currentTest = new TestImage("Image", this.logger, this.swapPool, this.threadSettings);
                this.currentTest.setHotRunTime(10000L);
                this.currentTest.setRunTime(this.runTime);
                this.currentTest.setThreadSettings(this.doHotRun, this.doFullRun);
                this.currentTest.setThreads(this.threads);
                this.currentTest.setCalibrate(this.calibrate);
                this.currentTest.test();
                tests.results[1] = this.currentTest.getBenchmarkResult();
                totalIndexSYS = Math.min(totalIndexSYS, tests.results[1].getIndex());
                totalTime += tests.results[1].getTime();
                ++totalTests;
                this.currentTest.dispose();
                this.currentTest = null;
                System.gc();
                Tester.println(Tester.printResult(tests.results[1], this.verbose));
                Tester.println(Formatter.drawLine(68));
            }
            if (!this.stopped && this.doTestEncoder) {
                this.currentTest = new TestEncoder("Encoder", this.logger, this.swapPool, this.threadSettings);
                this.currentTest.setHotRunTime(10000L);
                this.currentTest.setRunTime(this.runTime);
                this.currentTest.setThreadSettings(this.doHotRun, this.doFullRun);
                this.currentTest.setThreads(this.threads);
                this.currentTest.setCalibrate(this.calibrate);
                this.currentTest.test();
                tests.results[2] = this.currentTest.getBenchmarkResult();
                totalIndexSYS = Math.min(totalIndexSYS, tests.results[2].getIndex());
                totalTime += tests.results[2].getTime();
                ++totalTests;
                this.currentTest.dispose();
                this.currentTest = null;
                System.gc();
                Tester.println(Tester.printResult(tests.results[2], this.verbose));
                Tester.println(Formatter.drawLine(68));
            }
            if (!this.stopped && this.doTestSwap) {
                this.currentTest = new TestSwap("Swap", this.logger, this.workDirBase, this.threadSettings);
                this.currentTest.setHotRunTime(10000L);
                this.currentTest.setRunTime(this.runTime);
                this.currentTest.setThreadSettings(this.doHotRun, this.doFullRun);
                this.currentTest.setThreads(this.threads);
                this.currentTest.setCalibrate(this.calibrate);
                if (!this.currentTest.hasError()) {
                    this.currentTest.test();
                    tests.results[3] = this.currentTest.getBenchmarkResult();
                    totalIndexIO = Math.min(totalIndexIO, tests.results[3].getIndex());
                    totalTime += tests.results[3].getTime();
                    ++totalTests;
                    this.currentTest.dispose();
                    this.currentTest = null;
                    System.gc();
                    Tester.println(Tester.printResult(tests.results[3], this.verbose));
                    Tester.println(Formatter.drawLine(68));
                } else {
                    Tester.println("Error in Test: " + this.currentTest.getError());
                }
            }
            if (!this.stopped && this.doTestIO) {
                this.currentTest = new TestIO("IO", this.logger, this.workDirBase, this.threadSettings);
                this.currentTest.setHotRunTime(10000L);
                this.currentTest.setRunTime(this.runTime);
                this.currentTest.setThreadSettings(this.doHotRun, this.doFullRun);
                this.currentTest.setThreads(this.threads);
                this.currentTest.setCalibrate(this.calibrate);
                this.currentTest.test();
                tests.results[4] = this.currentTest.getBenchmarkResult();
                totalIndexIO = Math.min(totalIndexIO, tests.results[4].getIndex());
                totalTime += tests.results[4].getTime();
                ++totalTests;
                this.currentTest.dispose();
                this.currentTest = null;
                System.gc();
                Tester.println(Tester.printResult(tests.results[4], this.verbose));
                Tester.println(Formatter.drawLine(68));
            }
            if (!this.stopped && this.doTestStorage) {
                this.currentTest = new TestStorage("Storage", this.logger, ioFileList, this.threadSettings);
                this.currentTest.setHotRunTime(10000L);
                this.currentTest.setRunTime(this.runTime);
                this.currentTest.setThreadSettings(this.doHotRun, this.doFullRun);
                this.currentTest.setThreads(this.threads);
                this.currentTest.setCalibrate(this.calibrate);
                this.currentTest.test();
                tests.results[5] = this.currentTest.getBenchmarkResult();
                totalIndexIO = Math.min(totalIndexIO, tests.results[5].getIndex());
                totalTime += tests.results[5].getTime();
                ++totalTests;
                this.currentTest.dispose();
                this.currentTest = null;
                System.gc();
                Tester.println(Tester.printResult(tests.results[5], this.verbose));
                Tester.println(Formatter.drawLine(68));
            }
            if (this.doTestStorage) {
                FileOperations.deleteDir(workDirWrite);
                FileOperations.deleteDir(workDirRead);
            }
            if ((printTotalIndex = this.doHotRun && this.doFullRun && this.doTestCache && this.doTestEncoder && this.doTestFSIImageLimited && this.doTestSwap && this.doTestIO && this.doTestStorage) && totalTests == 6) {
                Tester.println(Formatter.printPair("Total Index SYS", totalIndexSYS, ":", 25));
                Tester.println(Formatter.printPair("Total Index IO", totalIndexIO, ":", 25));
                if (this.verbose) {
                    int totalTimeMS = (int)((float)totalTime / 1.0E9f);
                    String testTime = Formatter.secToTime(totalTimeMS, false, true);
                    Tester.println(Formatter.printPair("Total Test Time", testTime, ":", 25));
                }
            }
            if (this.resultFile != null) {
                String outputText = null;
                try {
                    if (this.format == OutputFormat.XML) {
                        outputText = tests.makeXML();
                    } else if (this.format == OutputFormat.TXT) {
                        outputText = tests.makeTXT(totalIndexSYS, totalIndexIO, printTotalIndex);
                    }
                    try (BufferedWriter fw = Files.newBufferedWriter(this.resultFile, FileOperations.charsetUTF8, new OpenOption[0]);){
                        fw.write(outputText);
                    }
                }
                catch (Exception e) {
                    System.err.println("Error writing resultFile: " + this.resultFile.toString() + ":" + e.getLocalizedMessage());
                }
            }
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownThread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.dispose();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    void setStopped() {
        this.stopped = true;
        if (this.currentTest != null) {
            this.currentTest.stop();
        }
    }

    void dispose() {
        this.logger.shutdown();
    }

    public static void print(Object s) {
        if (doOutput) {
            System.out.print(s);
        }
    }

    public static void println(Object s) {
        if (doOutput) {
            System.out.println(s);
        }
    }

    private static String printResult(SingleTestResult result, boolean verbose) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        if (result.passesTotal > 0L) {
            sb.append(result.name).append(' ').append("Full Thread Test").append(ls);
            if (verbose) {
                if (result.threadPassesPerSec != null) {
                    for (int t = 0; t < result.threadPassesPerSec.length; ++t) {
                        sb.append(Formatter.printPair("TPS at " + (t + 1) + " thread" + (t + 1 > 1 ? "s" : ""), dcdotsf.format(result.threadPassesPerSec[t]), ":", 25)).append(ls);
                    }
                }
                sb.append(Formatter.printPair("Passes Total", dcdots.format(result.passesTotal), ":", 25)).append(ls);
            }
            sb.append(Formatter.printPair("Sub Index", dcdots.format(result.index), ":", 25)).append(ls);
        }
        return sb.toString();
    }
}

