/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiserverbenchmark;

import com.neptunelabs.fsiframework.SoftwareVersion;
import com.neptunelabs.fsiframework.helpers.DateFormatter;
import com.neptunelabs.fsiframework.helpers.FormatBytes;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.MemoryManager;
import com.neptunelabs.fsiframework.io.StringWriterFast;
import com.neptunelabs.fsiframework.security.Sha160;
import com.neptunelabs.fsiframework.systeminformation.JavaInformation;
import com.neptunelabs.fsiframework.systeminformation.SystemInformation;
import com.neptunelabs.fsiserver.utils.Version;
import com.neptunelabs.fsiserverbenchmark.Formatter;
import com.neptunelabs.fsiserverbenchmark.SingleTestResult;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class TotalTestResult {
    SingleTestResult[] results = new SingleTestResult[6];
    final SystemInformation sysinfo = new SystemInformation();
    private static final DecimalFormat dcdotsf = new DecimalFormat("###,###.00");
    private static final String lineSeparator = System.getProperty("line.separator");
    HashMap<String, String> strings = new HashMap();

    TotalTestResult(long runTime, boolean calibrate, boolean doHotRun, boolean doFullRun, int threads, int priority, Path workDirBase) {
        SoftwareVersion.setSoftware(null, new Version());
        this.strings.put("txtBenchmarkVersion", "Benchmark Version");
        this.strings.put("xmlBenchmarkVersion", "version");
        this.strings.put("resBenchmarkVersion", SoftwareVersion.getSoftware(true));
        this.strings.put("txtCalibrate", "Calibrate Mode");
        this.strings.put("xmlCalibrate", "calibrateMode");
        if (calibrate) {
            this.strings.put("resCalibrate", "true");
        }
        this.strings.put("txtJava", "Java");
        this.strings.put("xmlJava", "java");
        this.strings.put("resJava", this.sysinfo.getJVMInformation());
        this.strings.put("txtJavaVersion", "Java Version");
        this.strings.put("xmlJavaVersion", "javaVersion");
        this.strings.put("resJavaVersion", this.sysinfo.getJVMVersionDetailed());
        this.strings.put("txtDataModel", "Data Model");
        this.strings.put("xmlDataModel", "dataModel");
        if (this.sysinfo.is64()) {
            this.strings.put("resDataModel", "64 Bit");
        } else {
            this.strings.put("resDataModel", "32 Bit");
        }
        this.strings.put("txtVMOptions", "VM Options");
        this.strings.put("xmlVMOptions", "vmOptions");
        JavaInformation ji = new JavaInformation();
        List<String> aList = ji.getStartOptions();
        StringBuilder vmOpts = new StringBuilder();
        for (int i = 0; i < aList.size(); ++i) {
            vmOpts.append(aList.get(i));
            if (i >= aList.size() - 1) continue;
            vmOpts.append(' ');
        }
        this.strings.put("resVMOptions", vmOpts.toString());
        this.strings.put("txtRuntime", "Runtime");
        this.strings.put("xmlRuntime", "runtime");
        this.strings.put("resRuntime", Integer.toString((int)(runTime / 1000L)));
        this.strings.put("txtSubTests", "Sub tests");
        this.strings.put("xmlSubTests", "subTests");
        this.strings.put("resSubTests", (doHotRun ? "H" : "") + (doFullRun ? "F" : ""));
        this.strings.put("txtOS", "OS");
        this.strings.put("xmlOS", "os");
        this.strings.put("resOS", this.sysinfo.getOperationSystemString());
        this.strings.put("txtTestThreads", "Test Threads");
        this.strings.put("xmlTestThreads", "testThreads");
        this.strings.put("resTestThreads", Integer.toString(threads));
        this.strings.put("txtAvailThreads", "CPU Threads");
        this.strings.put("xmlAvailThreads", "cpuThreads");
        this.strings.put("resAvailThreads", Integer.toString(this.sysinfo.getProcessors()));
        this.strings.put("txtThreadPriority", "Thread Priority");
        this.strings.put("xmlThreadPriority", "threadPriority");
        if (priority == 1) {
            this.strings.put("resThreadPriority", "min");
        } else if (priority == 5) {
            this.strings.put("resThreadPriority", "norm");
        } else if (priority == 10) {
            this.strings.put("resThreadPriority", "max");
        }
        this.strings.put("txtVMRamMax", "VM RAM Max");
        this.strings.put("xmlVMRamMax", "vmRAMMax");
        this.strings.put("resVMRamMax", FormatBytes.byteToString(Runtime.getRuntime().maxMemory(), 3, 1));
        this.strings.put("txtVMRamAvail", "VM RAM Free");
        this.strings.put("xmlVMRamAvail", "vmRAMFree");
        this.strings.put("resVMRamAvail", FormatBytes.byteToString(MemoryManager.getFreeHeapSpace(), 3, 1));
        this.strings.put("txtWorkDir", "Working Dir");
        this.strings.put("xmlWorkDir", "workingDir");
        this.strings.put("resWorkDir", workDirBase.toAbsolutePath().toString());
        InetAddress addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.strings.put("txtIP", "IP");
        this.strings.put("xmlIP", "ip");
        if (addr != null) {
            this.strings.put("resIP", addr.getHostAddress());
        }
        this.strings.put("txtHostname", "Hostname");
        this.strings.put("xmlHostname", "hostname");
        if (addr != null) {
            this.strings.put("resHostname", addr.getCanonicalHostName());
        }
        this.strings.put("txtDateTime", "Date/Time");
        this.strings.put("xmlDateTime", "dateTime");
        this.strings.put("resDateTime", DateFormatter.toRFC2822(System.currentTimeMillis()));
        this.strings.put("txtTPS", "TPS");
        this.strings.put("xmlTPS", "tps");
        this.strings.put("txtPasses", "Passes Total");
        this.strings.put("xmlPasses", "passes");
        this.strings.put("txtSubIndex", "Sub Index");
        this.strings.put("xmlSubIndex", "subIndex");
        this.strings.put("txtSubTime", "Sub Time");
        this.strings.put("xmlSubTime", "subTime");
        this.strings.put("txtTotalIndexSYS", "Total Index SYS");
        this.strings.put("txtTotalIndexIO", "Total Index IO");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String makeXML() throws ParserConfigurationException, TransformerException {
        StringBuilder hasher = new StringBuilder();
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element rootElement = doc.createElement("fsi");
        doc.appendChild(rootElement);
        Element benchmark = doc.createElement("benchmark");
        rootElement.appendChild(benchmark);
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlBenchmarkVersion"), this.strings.get("resBenchmarkVersion"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlCalibrate"), this.strings.get("resCalibrate"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlJava"), this.strings.get("resJava"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlJavaVersion"), this.strings.get("resJavaVersion"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlDataModel"), this.strings.get("resDataModel"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlVMOptions"), this.strings.get("resVMOptions"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlRuntime"), this.strings.get("resRuntime"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlSubTests"), this.strings.get("resSubTests"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlOS"), this.strings.get("resOS"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlTestThreads"), this.strings.get("resTestThreads"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlAvailThreads"), this.strings.get("resAvailThreads"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlThreadPriority"), this.strings.get("resThreadPriority"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlVMRamMax"), this.strings.get("resVMRamMax"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlVMRamAvail"), this.strings.get("resVMRamAvail"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlWorkDir"), this.strings.get("resWorkDir"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlIP"), this.strings.get("resIP"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlHostname"), this.strings.get("resHostname"));
        TotalTestResult.appendTextChild(doc, hasher, benchmark, this.strings.get("xmlDateTime"), this.strings.get("resDateTime"));
        Element tests = doc.createElement("tests");
        benchmark.appendChild(tests);
        for (SingleTestResult result : this.results) {
            if (result == null) continue;
            Element resultNode = doc.createElement("test");
            tests.appendChild(resultNode);
            Attr attr = doc.createAttribute("name");
            attr.setValue(result.name);
            resultNode.setAttributeNode(attr);
            for (int t = 0; t < result.threadPassesPerSec.length; ++t) {
                Element tpsEle = doc.createElement(this.strings.get("xmlTPS"));
                Attr attrThread = doc.createAttribute("threads");
                attrThread.setValue(Integer.toString(t + 1));
                tpsEle.setAttributeNode(attrThread);
                String tpsStr = dcdotsf.format(result.threadPassesPerSec[t]);
                hasher.append(tpsStr);
                tpsEle.appendChild(doc.createTextNode(tpsStr));
                resultNode.appendChild(tpsEle);
            }
            TotalTestResult.appendTextChild(doc, hasher, resultNode, this.strings.get("xmlSubTime"), Long.toString(result.testTime));
            TotalTestResult.appendTextChild(doc, hasher, resultNode, this.strings.get("xmlPasses"), Long.toString(result.passesTotal));
            TotalTestResult.appendTextChild(doc, hasher, resultNode, this.strings.get("xmlSubIndex"), Integer.toString(result.index));
        }
        Sha160 sha = new Sha160();
        sha.update(hasher.toString().getBytes(FileOperations.charsetUTF8));
        sha.update(Version.getVersionKey());
        byte[] signatureBytes = sha.digest();
        StringBuilder sbSha = new StringBuilder();
        for (Object b : (SingleTestResult)signatureBytes) {
            sbSha.append(String.format("%02x", b & 0xFF));
        }
        Element signature = doc.createElement("signature");
        signature.appendChild(doc.createTextNode(sbSha.toString()));
        rootElement.appendChild(signature);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(doc);
        try (StringWriterFast swf = new StringWriterFast();){
            StreamResult result = new StreamResult(swf);
            transformer.transform(source, result);
            String string = swf.toString();
            return string;
        }
        catch (IOException e) {
            return null;
        }
    }

    String makeTXT(int totalIndexSYS, int totalIndexIO, boolean printTotalIndex) {
        StringBuilder sb = new StringBuilder();
        TotalTestResult.echoPair(sb, this.strings.get("txtBenchmarkVersion"), this.strings.get("resBenchmarkVersion"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtCalibrate"), this.strings.get("resCalibrate"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtJava"), this.strings.get("resJava"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtJavaVersion"), this.strings.get("resJavaVersion"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtDataModel"), this.strings.get("resDataModel"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtVMOptions"), this.strings.get("resVMOptions"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtRuntime"), this.strings.get("resRuntime"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtSubTests"), this.strings.get("resSubTests"), ":", 25);
        sb.append(Formatter.drawLine(68));
        sb.append(lineSeparator);
        TotalTestResult.echoPair(sb, this.strings.get("txtOS"), this.strings.get("resOS"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtTestThreads"), this.strings.get("resTestThreads"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtAvailThreads"), this.strings.get("resAvailThreads"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtThreadPriority"), this.strings.get("resThreadPriority"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtVMRamMax"), this.strings.get("resVMRamMax"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtVMRamAvail"), this.strings.get("resVMRamAvail"), ":", 25);
        sb.append(Formatter.drawLine(68));
        sb.append(lineSeparator);
        TotalTestResult.echoPair(sb, this.strings.get("txtWorkDir"), this.strings.get("resWorkDir"), ":", 25);
        sb.append(Formatter.drawLine(68));
        sb.append(lineSeparator);
        TotalTestResult.echoPair(sb, this.strings.get("txtIP"), this.strings.get("resIP"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtHostname"), this.strings.get("resHostname"), ":", 25);
        TotalTestResult.echoPair(sb, this.strings.get("txtDateTime"), this.strings.get("resDateTime"), ":", 25);
        sb.append(Formatter.drawLine(68));
        sb.append(lineSeparator);
        for (SingleTestResult result : this.results) {
            if (result == null) continue;
            sb.append("Test " + result.name);
            sb.append(lineSeparator);
            for (int t = 0; t < result.threadPassesPerSec.length; ++t) {
                TotalTestResult.echoPair(sb, this.strings.get("txtTPS") + " at " + (t + 1), dcdotsf.format(result.threadPassesPerSec[t]), ":", 25);
            }
            TotalTestResult.echoPair(sb, this.strings.get("txtPasses"), Long.toString(result.passesTotal), ":", 25);
            TotalTestResult.echoPair(sb, this.strings.get("txtSubIndex"), Long.toString(result.index), ":", 25);
            sb.append(Formatter.drawLine(68));
            sb.append(lineSeparator);
        }
        if (printTotalIndex) {
            TotalTestResult.echoPair(sb, this.strings.get("txtTotalIndexSYS"), Integer.toString(totalIndexSYS), ":", 25);
            TotalTestResult.echoPair(sb, this.strings.get("txtTotalIndexIO"), Integer.toString(totalIndexIO), ":", 25);
        }
        return sb.toString();
    }

    private static void appendTextChild(Document doc, StringBuilder hasher, Element parent, String key, String value) {
        if (value != null) {
            Element e = doc.createElement(key);
            e.appendChild(doc.createTextNode(value));
            parent.appendChild(e);
            hasher.append(value);
        }
    }

    private static void echoPair(StringBuilder sb, String key, String value, String delimiter, int limit) {
        if (value != null) {
            sb.append(Formatter.printPair(key, value, delimiter, limit));
            sb.append(lineSeparator);
        }
    }
}

