/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework;

import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.io.PathCached;
import com.neptunelabs.fsiframework.security.SecurityHelper;
import com.neptunelabs.fsiservletframework.interfacewebservice.DeleteFileRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.DeleteFileRequestType;
import com.neptunelabs.fsiservletframework.interfacewebservice.DeleteFileResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.DisconnectRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetFileListRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetFileListResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetHelpTextRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetHelpTextRequestType;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetHelpTextResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetRenderedTemplateRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetRenderedTemplateRequestType;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetRenderedTemplateResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetRenderedTemplateResponseType;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetSoftwareStatusRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetSoftwareStatusResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetUpdatableFileListRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.GetUpdatableFileListResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.KeyValuePair;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfFiles;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfKeyValuePairs;
import com.neptunelabs.fsiservletframework.interfacewebservice.ListOfUpdatableFiles;
import com.neptunelabs.fsiservletframework.interfacewebservice.ReadFileContentsRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.ReadFileContentsResponse;
import com.neptunelabs.fsiservletframework.interfacewebservice.RemoteDirectoryType;
import com.neptunelabs.fsiservletframework.interfacewebservice.RemoteFileType;
import com.neptunelabs.fsiservletframework.interfacewebservice.SetMaintenanceEnabledRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.UpdatableFile;
import com.neptunelabs.fsiservletframework.interfacewebservice.UpdateUserListRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.WriteFileContentsRequest;
import com.neptunelabs.fsiservletframework.interfacewebservice.WriteFileContentsRequestType;
import com.neptunelabs.fsiservletframework.interfacewebservice.WriteFileContentsResponse;
import com.neptunelabs.fsiservletframework.interfacewebserviceconnection.FsiappinterfaceSkeleton;
import com.neptunelabs.fsiservletframework.settings.ServletXMLSettings;
import com.neptunelabs.fsiservletframework.utils.ServletUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.ServletContext;
import org.apache.axis2.context.ServiceContext;

public abstract class BaseWSAdminConnector
extends FsiappinterfaceSkeleton {
    public ServletXMLSettings settings;
    protected SecurityHelper securityHelper;

    public void init(ServiceContext serviceContext) {
        ServletContext context;
        Object tmp;
        Object o = serviceContext.getConfigurationContext().getProperty("transport.http.servletContext");
        if (o != null && o instanceof ServletContext && (tmp = (context = (ServletContext)o).getAttribute("FSIServletSettings")) != null && tmp instanceof ServletXMLSettings) {
            this.settings = (ServletXMLSettings)tmp;
        }
        if (this.settings != null) {
            this.securityHelper = new SecurityHelper(this.settings.getFSILogger());
        }
    }

    @Override
    public abstract void updateUserList(UpdateUserListRequest var1);

    @Override
    public ReadFileContentsResponse readFileContents(ReadFileContentsRequest requestparams) {
        ReadFileContentsResponse result = new ReadFileContentsResponse();
        String pathToFile = requestparams.getReadFileContentsRequest();
        Path file = ServletUtils.getRealPath(this.settings.getServletContext(), pathToFile);
        if (Files.isReadable(file)) {
            result.setReadFileContentsResponse(new DataHandler((DataSource)new FileDataSource(file.toFile())));
        }
        return result;
    }

    @Override
    public DeleteFileResponse deleteFile(DeleteFileRequest deleteFileRequest) {
        String[] filenames;
        DeleteFileResponse result = new DeleteFileResponse();
        boolean deleted = true;
        DeleteFileRequestType request = deleteFileRequest.getDeleteFileRequest();
        boolean update = request.getUpdate();
        for (String filename : filenames = request.getFilename()) {
            if (update) {
                Path targetBase = this.settings.getTemporaryUpdateDirectory();
                Path targetFile = targetBase.resolve(filename);
                Path realTargetFile = ServletUtils.getRealPath(this.settings.getServletContext(), filename);
                if (Files.isRegularFile(realTargetFile, new LinkOption[0]) && this.settings.isProtectedDir(realTargetFile.getParent())) continue;
                Path targetParent = targetFile.getParent();
                try {
                    if (Files.notExists(targetParent, new LinkOption[0])) {
                        Files.createDirectories(targetParent, new FileAttribute[0]);
                    }
                    Files.createFile(targetFile, new FileAttribute[0]);
                    deleted &= true;
                }
                catch (IOException ioe) {
                    deleted = false;
                }
                continue;
            }
            Path file = ServletUtils.getRealPath(this.settings.getServletContext(), filename);
            if (Files.exists(file, new LinkOption[0]) && Files.isWritable(file)) {
                try {
                    Files.delete(file);
                    deleted &= true;
                }
                catch (IOException iOException) {}
                continue;
            }
            deleted = false;
        }
        result.setDeleteFileResponse(deleted);
        return result;
    }

    @Override
    public GetFileListResponse getFileList(GetFileListRequest getFileListRequest) {
        GetFileListResponse result = new GetFileListResponse();
        RemoteDirectoryType baseDir = new RemoteDirectoryType();
        Path base = ServletUtils.getRealPath(this.settings.getServletContext(), "/");
        baseDir.setName("");
        baseDir.setFullPath(base.toAbsolutePath().toString().substring(base.toAbsolutePath().toString().length()));
        baseDir.setFileSeparator(File.separator);
        baseDir.setBackupEnabled(false);
        this.buildSubDir(baseDir, base);
        result.setGetFileListResponse(baseDir);
        return result;
    }

    private void buildSubDir(RemoteDirectoryType rdir, Path dir) {
        try {
            List<PathCached> items = FileOperations.listAllFiles(dir);
            for (PathCached item : items) {
                if (item.isRegularFile()) {
                    RemoteFileType rf = new RemoteFileType();
                    rf.setName(item.getFileName());
                    Calendar lastModified = Calendar.getInstance();
                    lastModified.setTimeInMillis(item.lastModified());
                    rf.setLastModified(lastModified);
                    rf.setSize(item.size());
                    rf.setFullPath(item.getAbsoluteName().substring(this.settings.getServletContext().getRealPath("/").length()));
                    rdir.addFiles(rf);
                    continue;
                }
                if (!item.isDirectory() || !this.settings.isViewableDir(item.getAbsoluteName().substring(this.settings.getServletContext().getRealPath("/").length()))) continue;
                RemoteDirectoryType rd = new RemoteDirectoryType();
                rd.setName(item.getFileName());
                rd.setFileSeparator(File.separator);
                rd.setViewingEnabled(true);
                rd.setBackupEnabled(false);
                rd.setFullPath(item.getAbsoluteName().substring(this.settings.getServletContext().getRealPath("/").length()));
                rdir.addSubdirectories(rd);
                this.buildSubDir(rd, item.getPath());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public abstract GetSoftwareStatusResponse getSoftwareStatus(GetSoftwareStatusRequest var1);

    @Override
    public GetHelpTextResponse getHelpText(GetHelpTextRequest request) {
        Path helpFilePath;
        Path helpfile;
        GetHelpTextResponse result = new GetHelpTextResponse();
        GetHelpTextRequestType parameters = request.getGetHelpTextRequest();
        String id = parameters.getId();
        String language = parameters.getLanguage();
        String helptext = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><data><help>No help available.</help></data>";
        if (this.settings != null && Files.exists(helpfile = (helpFilePath = this.settings.getAdministratorHelpDiretory()).resolve(id + "_" + language + ".xml"), new LinkOption[0])) {
            helptext = FileOperations.getTextFileContent(this.settings.getFSILogger(), helpfile, FileOperations.charsetUTF8);
        }
        result.setGetHelpTextResponse(helptext);
        return result;
    }

    @Override
    public WriteFileContentsResponse writeFileContents(WriteFileContentsRequest writeFileContentsRequest) {
        boolean fileWritten;
        WriteFileContentsResponse result;
        block21: {
            result = new WriteFileContentsResponse();
            WriteFileContentsRequestType parameters = writeFileContentsRequest.getWriteFileContentsRequest();
            String filename = parameters.getFilename();
            if (!filename.startsWith("/")) {
                filename = "/" + filename;
            }
            DataHandler dh = parameters.getData();
            boolean update = parameters.getUpdate();
            fileWritten = false;
            try {
                ServletUtils.getRealPath(this.settings.getServletContext(), filename);
                Path targetFile = ServletUtils.getRealPath(this.settings.getServletContext(), filename);
                Path targetFileParent = targetFile.getParent();
                if (update) {
                    if (this.settings.isProtectedDir(targetFileParent)) {
                        this.settings.getFSILogger().log(1599, targetFile.toString());
                    } else {
                        Path targetBase = this.settings.getTemporaryUpdateDirectory();
                        targetFile = targetBase.resolve(filename);
                    }
                }
                if (Files.notExists(targetFileParent, new LinkOption[0])) {
                    Files.createDirectories(targetFileParent, new FileAttribute[0]);
                }
                if (!Files.notExists(targetFile, new LinkOption[0]) && !Files.isWritable(targetFile)) break block21;
                try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                    dh.writeTo((OutputStream)bos);
                    byte[] data = bos.toByteArray();
                    fileWritten = FileOperations.writeFile(this.settings.getFSILogger(), targetFile, data);
                }
                catch (IOException iOException) {}
            }
            catch (Exception e) {
                this.settings.getFSILogger().log(1596, "writeFileContents", e.getClass().getName(), e.getLocalizedMessage());
            }
        }
        result.setWriteFileContentsResponse(fileWritten);
        return result;
    }

    @Override
    public void disconnect(DisconnectRequest disconnectRequest) {
        String message = null;
        if (disconnectRequest != null) {
            message = disconnectRequest.getDisconnectRequest();
        }
        Path keyStoreFile = this.getKeyStoreLocation();
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            try (InputStream in = Files.newInputStream(keyStoreFile, new OpenOption[0]);){
                ks.load(in, "fsiws".toCharArray());
            }
            ks.deleteEntry("administrator");
            var6_11 = null;
            try (OutputStream out = Files.newOutputStream(keyStoreFile, new OpenOption[0]);){
                ks.store(out, "fsiws".toCharArray());
            }
            catch (Throwable throwable) {
                var6_11 = throwable;
                throw throwable;
            }
        }
        catch (KeyStoreException e) {
            this.settings.getFSILogger().log(1028, e.getClass().getName() + ": " + e.getLocalizedMessage() + " (" + message + ")");
        }
        catch (NoSuchFileException e) {
            this.settings.getFSILogger().log(1028, e.getClass().getName() + ": " + e.getLocalizedMessage() + " (" + message + ")");
        }
        catch (NoSuchAlgorithmException e) {
            this.settings.getFSILogger().log(1028, e.getClass().getName() + ": " + e.getLocalizedMessage() + " (" + message + ")");
        }
        catch (CertificateException e) {
            this.settings.getFSILogger().log(1028, e.getClass().getName() + ": " + e.getLocalizedMessage() + " (" + message + ")");
        }
        catch (IOException e) {
            this.settings.getFSILogger().log(1028, e.getClass().getName() + ": " + e.getLocalizedMessage() + " (" + message + ")");
        }
    }

    private Path getKeyStoreLocation() {
        Object tmp = this.settings.getServletContext().getAttribute("AdministratorKeyStorePath");
        if (tmp != null && tmp instanceof Path) {
            return (Path)tmp;
        }
        return null;
    }

    @Override
    public abstract void setMaintenanceEnabled(SetMaintenanceEnabledRequest var1);

    @Override
    public GetRenderedTemplateResponse getRenderedTemplate(GetRenderedTemplateRequest getRenderedTemplateRequest) {
        GetRenderedTemplateResponseType response = new GetRenderedTemplateResponseType();
        int status = 500;
        try {
            GetRenderedTemplateRequestType parameters = getRenderedTemplateRequest.getGetRenderedTemplateRequest();
            String action = parameters.getAction();
            HashMap<String, Object> httpParameters = this.listOfKeyValuePairs2HashMap1toMany(parameters.getParameters());
            HashMap<String, String> sessionData = this.listOfKeyValuePairs2HashMap1to1(parameters.getSessionData());
            HashMap<String, String> requiredParameters = this.listOfKeyValuePairs2HashMap1to1(parameters.getRequiredParams());
            ListOfFiles files = parameters.getFiles();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            HashMap<String, String> responseSessionData = new HashMap<String, String>();
            ByteArrayOutputStream responseBodyOutputStream = new ByteArrayOutputStream();
            ArrayList<Map<String, Object>> relatedPages = new ArrayList<Map<String, Object>>();
            Set keys = sessionData.keySet();
            ArrayList<String> removeKeys = new ArrayList<String>();
            for (String key : keys) {
                if (!key.startsWith("relatedPage ")) continue;
                HashMap<String, Object> entry = new HashMap<String, Object>();
                String[] parts = ((String)sessionData.get(key)).split(";");
                entry.put("value", parts[0]);
                entry.put("description", parts[1]);
                entry.put("disabled", Boolean.valueOf(parts[2]));
                relatedPages.add(entry);
                removeKeys.add(key);
            }
            for (String k : removeKeys) {
                sessionData.remove(k);
            }
            status = this.getRenderedTemplate(action, httpParameters, sessionData, relatedPages, requiredParameters, files, responseHeaders, responseSessionData, responseBodyOutputStream);
            String mimetype = (String)responseHeaders.get("Content-Type");
            if (mimetype == null) {
                mimetype = "text/html";
                responseHeaders.put("Content-Type", mimetype);
            }
            response.setHeaders(this.hashMap2ListOfKeyValuePairs(responseHeaders));
            response.setSessionData(this.hashMap2ListOfKeyValuePairs(responseSessionData));
            response.setData(new DataHandler((DataSource)new ByteArrayDataSource(responseBodyOutputStream.toByteArray(), mimetype)));
        }
        catch (Exception e) {
            this.settings.getFSILogger().log(1596, "getRenderedTemplate", e.getClass().getName(), e.getLocalizedMessage());
            e.printStackTrace(System.err);
        }
        response.setStatus(status);
        GetRenderedTemplateResponse result = new GetRenderedTemplateResponse();
        result.setGetRenderedTemplateResponse(response);
        return result;
    }

    protected abstract int getRenderedTemplate(String var1, Map<String, Object> var2, Map<String, String> var3, List<Map<String, Object>> var4, Map<String, String> var5, ListOfFiles var6, Map<String, String> var7, Map<String, String> var8, ByteArrayOutputStream var9);

    protected HashMap<String, String> listOfKeyValuePairs2HashMap1to1(ListOfKeyValuePairs list) {
        KeyValuePair[] keyValuePairArray;
        HashMap<String, String> result = new HashMap<String, String>();
        if (list != null && (keyValuePairArray = list.getEntry()) != null) {
            for (KeyValuePair entry : keyValuePairArray) {
                result.put(entry.getKey(), entry.getValue());
            }
        }
        return result;
    }

    protected HashMap<String, Object> listOfKeyValuePairs2HashMap1toMany(ListOfKeyValuePairs list) {
        KeyValuePair[] keyValuePairArray;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (list != null && (keyValuePairArray = list.getEntry()) != null) {
            for (KeyValuePair entry : keyValuePairArray) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (result.containsKey(key)) {
                    if (result.get(key) instanceof String) {
                        String[] values = new String[]{(String)result.get(key), value};
                        result.put(key, values);
                        continue;
                    }
                    if (!(result.get(key) instanceof String[])) continue;
                    String[] oldValues = (String[])result.get(key);
                    String[] newValues = new String[oldValues.length + 1];
                    System.arraycopy(result.get(key), 0, newValues, 0, oldValues.length);
                    newValues[oldValues.length] = value;
                    result.put(key, newValues);
                    continue;
                }
                result.put(key, value);
            }
        }
        return result;
    }

    protected ListOfKeyValuePairs hashMap2ListOfKeyValuePairs(Map<String, String> map) {
        ListOfKeyValuePairs result = new ListOfKeyValuePairs();
        for (Map.Entry<String, String> mapentry : map.entrySet()) {
            KeyValuePair entry = new KeyValuePair();
            entry.setKey(mapentry.getKey());
            entry.setValue(mapentry.getValue());
            result.addEntry(entry);
        }
        return result;
    }

    @Override
    public GetUpdatableFileListResponse getUpdatableFileList(GetUpdatableFileListRequest getUpdatableFileListRequest) {
        Path applicationBaseDirStr = ServletUtils.getRealPath(this.settings.getServletContext(), "/");
        ListOfUpdatableFiles list = new ListOfUpdatableFiles();
        try {
            this.buildUpdateableFilesList(list, applicationBaseDirStr.toAbsolutePath().toString(), applicationBaseDirStr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        GetUpdatableFileListResponse response = new GetUpdatableFileListResponse();
        response.setGetUpdatableFileListResponse(list);
        return response;
    }

    private void buildUpdateableFilesList(ListOfUpdatableFiles list, String applicationBase, Path dir) throws IOException {
        List<PathCached> elements = FileOperations.listAllFiles(dir);
        for (PathCached entry : elements) {
            String name;
            if (entry.isRegularFile()) {
                UpdatableFile fileentry = new UpdatableFile();
                fileentry.setType("file");
                name = entry.getAbsoluteName().substring(applicationBase.length() + 1);
                fileentry.setName(name.replace(File.separatorChar, '/'));
                fileentry.setChecksum(this.securityHelper.sha1sum(entry.getPath()));
                fileentry.setWriteable(Files.isWritable(entry.getPath()));
                list.addEntry(fileentry);
                continue;
            }
            if (!entry.isDirectory() || this.settings.isProtectedDir(entry.getPath())) continue;
            UpdatableFile direntry = new UpdatableFile();
            direntry.setType("directory");
            name = entry.getAbsoluteName().substring(applicationBase.length() + 1);
            direntry.setName(name.replace(File.separatorChar, '/'));
            direntry.setChecksum("");
            direntry.setWriteable(entry.isWritable());
            this.buildUpdateableFilesList(list, applicationBase, entry.getPath());
        }
    }
}

