/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework;

import com.neptunelabs.fsiservletframework.interfacewebserviceconnection.AdministrationKey;
import com.neptunelabs.fsiservletframework.interfacewebserviceconnection.ApplicationKey;
import com.neptunelabs.fsiservletframework.interfacewebserviceconnection.FsiappinterfaceconnectionsetupSkeleton;
import com.neptunelabs.fsiservletframework.interfacewebserviceconnection.IdentifyRequest;
import com.neptunelabs.fsiservletframework.interfacewebserviceconnection.SoftwareID;
import com.neptunelabs.fsiservletframework.security.KeyStoreGenerator;
import com.neptunelabs.fsiservletframework.security.ServletMerlin;
import com.neptunelabs.fsiservletframework.settings.ServletXMLSettings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.servlet.ServletContext;
import org.apache.axis2.context.ServiceContext;
import org.bouncycastle.util.encoders.Base64;

public class ConnectionServiceImplementation
extends FsiappinterfaceconnectionsetupSkeleton {
    private ServletContext servletcontext;
    private ServletXMLSettings settings;

    public void init(ServiceContext serviceContext) {
        Object o = serviceContext.getConfigurationContext().getProperty("transport.http.servletContext");
        if (o != null && o instanceof ServletContext) {
            this.servletcontext = (ServletContext)o;
            Object tmp = this.servletcontext.getAttribute("FSIServletSettings");
            if (tmp != null && tmp instanceof ServletXMLSettings) {
                this.settings = (ServletXMLSettings)tmp;
            }
        }
    }

    private byte[] getRawAdministratorKeyFromRequest(AdministrationKey requestAdminKey) throws ConnectException {
        byte[] result = null;
        String receivedData = requestAdminKey.getAdministrationKey();
        if (receivedData == null) {
            throw new ConnectException("ERROR: empty key received");
        }
        result = Base64.decode((byte[])receivedData.getBytes());
        return result;
    }

    private void checkConnectPermission() throws ConnectException {
        if (this.servletcontext == null) {
            throw new ConnectException("ERROR: missing servlet context");
        }
        Object o = this.servletcontext.getAttribute("Allow FSI Administrator");
        if (!(o instanceof Boolean) || !((Boolean)o).booleanValue()) {
            throw new ConnectException("ERROR: application is running in standalone mode");
        }
    }

    private void checkForExistingAdministratorKey(KeyStore keyStore) throws ConnectException {
        try {
            if (keyStore.getCertificate("administrator") != null) {
                throw new ConnectException("ERROR: already connected");
            }
        }
        catch (KeyStoreException kse) {
            this.settings.getFSILogger().log(1528, kse.getClass().getName() + ": " + kse.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
    }

    private X509Certificate decodeAdministratorKey(byte[] rawAdministratorKey) throws ConnectException {
        ByteArrayInputStream stream = new ByteArrayInputStream(rawAdministratorKey);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            if (stream.available() > 0) {
                return (X509Certificate)cf.generateCertificate(stream);
            }
            throw new ConnectException("ERROR: invalid certificate data");
        }
        catch (CertificateException e) {
            throw new ConnectException("ERROR: invalid certificate data");
        }
    }

    private void addCertificateToKeyStore(KeyStore ks, X509Certificate certificate) throws ConnectException {
        try {
            ks.setCertificateEntry("administrator", certificate);
        }
        catch (KeyStoreException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
    }

    private void saveKeyStore(KeyStore ks, Path keystorepath) throws ConnectException {
        try (OutputStream out = Files.newOutputStream(keystorepath, new OpenOption[0]);){
            ks.store(out, "fsiws".toCharArray());
            ServletMerlin.invalidateKeyStore();
        }
        catch (CertificateException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
        catch (NoSuchAlgorithmException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
        catch (IOException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
        catch (KeyStoreException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
    }

    @Override
    public ApplicationKey Connect(AdministrationKey adminKeyRequest) {
        try {
            byte[] rawAdministratorKey = this.getRawAdministratorKeyFromRequest(adminKeyRequest);
            this.checkConnectPermission();
            Path keyStoreFile = this.getKeyStoreLocation();
            if (Files.exists(keyStoreFile, new LinkOption[0])) {
                throw new ConnectException("ERROR: locked");
            }
            KeyStore ks = this.loadKeyStore(keyStoreFile);
            this.checkForExistingAdministratorKey(ks);
            X509Certificate administratorCertificate = this.decodeAdministratorKey(rawAdministratorKey);
            this.addCertificateToKeyStore(ks, administratorCertificate);
            this.saveKeyStore(ks, keyStoreFile);
            return this.buildResponseWithApplicationCertificate(ks);
        }
        catch (ConnectException e) {
            ApplicationKey response = new ApplicationKey();
            response.setApplicationKey(e.getLocalizedMessage());
            return response;
        }
    }

    private Path getKeyStoreLocation() throws ConnectException {
        Object tmp = this.servletcontext.getAttribute("AdministratorKeyStorePath");
        if (tmp != null && tmp instanceof Path) {
            return (Path)tmp;
        }
        throw new ConnectException("ERROR: missing path to keystore");
    }

    private ApplicationKey buildResponseWithApplicationCertificate(KeyStore ks) throws ConnectException {
        try {
            ApplicationKey response = new ApplicationKey();
            Certificate[] cc = ks.getCertificateChain("application");
            Certificate mycert = cc[0];
            byte[] bytes = mycert.getEncoded();
            response.setApplicationKey(new String(Base64.encode((byte[])bytes)));
            return response;
        }
        catch (KeyStoreException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
        catch (CertificateEncodingException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private KeyStore loadKeyStore(Path keystorepath) throws ConnectException {
        KeyStoreGenerator.generateKeyStore(this.settings.getFSILogger(), keystorepath, "application", "applicationcert", "fsiws");
        try (InputStream in = Files.newInputStream(keystorepath, new OpenOption[0]);){
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(in, "fsiws".toCharArray());
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (KeyStoreException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
        catch (CertificateException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
        catch (NoSuchAlgorithmException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
        catch (IOException e) {
            this.settings.getFSILogger().log(1528, e.getClass().getName() + ": " + e.getLocalizedMessage());
            throw new ConnectException("ERROR: failed to access keystore. Please check your logfiles.");
        }
    }

    @Override
    public SoftwareID Identify(IdentifyRequest identifyRequest) {
        int result = 0;
        Object o = this.servletcontext.getAttribute("fsiSoftwareID");
        if (o != null && o instanceof Integer) {
            result = (Integer)o;
        }
        SoftwareID id = new SoftwareID();
        id.setSoftwareID(result);
        return id;
    }

    private class ConnectException
    extends Exception {
        private static final long serialVersionUID = -4209246338600226100L;

        ConnectException(String message) {
            super(message);
        }
    }
}

