/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework;

import com.neptunelabs.fsiframework.helpers.URLEncoderFast;
import com.neptunelabs.fsiframework.io.FileOperations;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HTTPDisposition {
    private final Pattern browser_opera = Pattern.compile("Opera ([0-9]{1,2}.[0-9]{1,2})", 2);
    private final Pattern browser_chrome = Pattern.compile("Chrome/([0-9]{1,2}.[0-9]{1})", 2);
    private final Pattern browser_msie = Pattern.compile("MSIE ([0-9]{1,2}.[0-9]{1,2})", 2);
    private final Pattern browser_mozilla = Pattern.compile("Mozilla\\/([0-9]{1,2}.[0-9]{1,2})", 2);
    private final Pattern browser_konqueror = Pattern.compile("Konqueror\\/([0-9]{1,2})", 2);
    private final Pattern version_split = Pattern.compile("([0-9]*?)\\.([0-9])");
    private final Pattern service_pack = Pattern.compile("\\(.+;.+SP([\\d]{1})\\)", 2);
    private final Pattern filenamepat = Pattern.compile("\\.[\\w]{2,4}$", 2);
    private final Pattern servicepat = Pattern.compile("[\\w]+(=|%3d)", 2);

    public HashMap<String, String> getHeader(String useragent, String saveName, long size, String mime) {
        HashMap<String, String> header = new HashMap<String, String>();
        if (useragent != null) {
            URLEncoderFast encoder = new URLEncoderFast("", false);
            String filenameUTF8 = encoder.escape(this.cleanSaveName(mime, saveName));
            String filenameISO = "";
            try {
                CharsetDecoder decoder = FileOperations.charsetISO8859_15.newDecoder();
                ByteBuffer bb = FileOperations.charsetISO8859_15.encode(this.cleanSaveName(mime, saveName));
                CharBuffer cbuf = decoder.decode(bb);
                filenameISO = cbuf.toString();
            }
            catch (CharacterCodingException decoder) {
                // empty catch block
            }
            Browser detectedBrowser = this.detectBrowser(useragent);
            header.put("Pragma", "no-cache");
            if (detectedBrowser.vendor == BrowserVendor.MSIE) {
                if (detectedBrowser.major <= 5 && detectedBrowser.minor == 5 && detectedBrowser.sp == 1) {
                    header.put("Content-Disposition", "atachment; filename=\"" + filenameISO + "\"");
                } else {
                    header.put("Content-Type", "application/octet-stream; name=\"" + filenameISO + "\"");
                    header.put("Content-Disposition", "attachment; filename=\"" + filenameISO + "\"");
                }
            } else if (detectedBrowser.vendor == BrowserVendor.Chrome && detectedBrowser.major < 9) {
                header.put("Cache-Control", "no-cache");
                header.put("Content-Type", "application/octet-stream; name=\"" + filenameISO + "\"");
                header.put("Content-Disposition", "attachment; filename=\"" + filenameISO + "\"");
            } else {
                header.put("Cache-Control", "no-cache");
                header.put("Content-Type", "application/octet-stream; charset\"UTF-8\"");
                header.put("Content-Disposition", "attachment; filename*=UTF-8''" + filenameUTF8 + "; filename=\"" + filenameISO + "\"");
            }
            if (size > 0L) {
                header.put("Content-Length", Long.toString(size));
            }
        }
        return header;
    }

    public String getSavename(String requestStr) {
        String name = "image";
        String lastImageName = null;
        StringTokenizer st = new StringTokenizer(requestStr, "/");
        while (st.hasMoreTokens()) {
            String element = st.nextToken();
            Matcher matfile = this.filenamepat.matcher(element);
            Matcher matservice = this.servicepat.matcher(element);
            if (!matfile.find() || matservice.find()) continue;
            lastImageName = element;
        }
        if (lastImageName != null) {
            name = lastImageName;
        }
        return name;
    }

    private Browser detectBrowser(String useragent) {
        Matcher vmat;
        Matcher browsermat;
        Browser detectedBrowser = new Browser();
        useragent = useragent.toLowerCase();
        String versionStr = null;
        if (detectedBrowser.vendor == BrowserVendor.Unknown && (browsermat = this.browser_opera.matcher(useragent)).find()) {
            detectedBrowser.vendor = BrowserVendor.Opera;
            versionStr = browsermat.group(1);
        }
        if (detectedBrowser.vendor == BrowserVendor.Unknown && (browsermat = this.browser_msie.matcher(useragent)).find()) {
            detectedBrowser.vendor = BrowserVendor.MSIE;
            versionStr = browsermat.group(1);
        }
        if (detectedBrowser.vendor == BrowserVendor.Unknown && (browsermat = this.browser_chrome.matcher(useragent)).find()) {
            detectedBrowser.vendor = BrowserVendor.Chrome;
            versionStr = browsermat.group(1);
        }
        if (detectedBrowser.vendor == BrowserVendor.Unknown && (browsermat = this.browser_mozilla.matcher(useragent)).find()) {
            versionStr = browsermat.group(1);
            detectedBrowser.vendor = useragent.contains("Gecko") ? BrowserVendor.Mozilla : BrowserVendor.Netscape;
        }
        if (detectedBrowser.vendor == BrowserVendor.Unknown && (browsermat = this.browser_konqueror.matcher(useragent)).find()) {
            detectedBrowser.vendor = BrowserVendor.Konqueror;
            versionStr = browsermat.group(1);
        }
        if (versionStr != null && (vmat = this.version_split.matcher(versionStr)).find()) {
            try {
                detectedBrowser.major = Integer.valueOf(vmat.group(1));
                detectedBrowser.minor = Integer.valueOf(vmat.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        detectedBrowser.sp = this.determineServicePack(useragent);
        return detectedBrowser;
    }

    private int determineServicePack(String useragent) {
        int result = 0;
        Matcher spmat = this.service_pack.matcher(useragent);
        if (spmat.find()) {
            try {
                result = Integer.valueOf(spmat.group(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    private String cleanSaveName(String mime, String saveName) {
        if (saveName == null || saveName.equals("")) {
            saveName = "image";
        }
        saveName = saveName.replaceAll("\\.[\\w]{3,4}$", "");
        if (mime.equals("image/jpeg")) {
            saveName = saveName + ".jpg";
        } else if (mime.equals("image/png")) {
            saveName = saveName + ".png";
        } else if (mime.equals("image/gif")) {
            saveName = saveName + ".gif";
        } else if (mime.equals("application/zip")) {
            saveName = saveName + ".zip";
        } else if (mime.equals("application/pdf")) {
            saveName = saveName + ".pdf";
        } else if (mime.equals("text/html")) {
            saveName = saveName + ".htm";
        }
        return saveName;
    }

    private static enum BrowserVendor {
        Unknown,
        MSIE,
        Mozilla,
        Netscape,
        Konqueror,
        Safari,
        Chrome,
        Opera;

    }

    private class Browser {
        BrowserVendor vendor = BrowserVendor.Unknown;
        int major = 0;
        int minor = 0;
        int sp = 0;
    }
}

