/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework;

import com.neptunelabs.fsiframework.logging.FSILogger;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.servlet.GenericServlet;

public class UncaughtExceptionLogger
implements Thread.UncaughtExceptionHandler {
    protected final GenericServlet servlet;
    protected FSILogger logger = null;

    public UncaughtExceptionLogger(GenericServlet servlet) {
        this.servlet = servlet;
    }

    public void setLogger(FSILogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uncaughtException(Thread t, Throwable e) {
        String threadname = t != null ? t.getName() : "unknown";
        String stackTrace = null;
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            try {
                e.printStackTrace(pw);
            }
            finally {
                pw.close();
                sw.close();
            }
            StringBuffer sb = sw.getBuffer();
            stackTrace = sb.toString();
        }
        catch (IOException sw) {
            // empty catch block
        }
        if (this.logger != null) {
            String stackMessage = e.getLocalizedMessage();
            if (stackMessage == null) {
                stackMessage = "unknown error";
            }
            this.logger.log(9000, threadname, stackMessage);
            if (stackTrace != null) {
                this.logger.log(9002, stackTrace);
            }
        } else {
            this.servlet.log("Unhandled Exception in Thread " + threadname, e);
        }
    }
}

