/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.bofh;

import com.neptunelabs.fsiframework.collections.LeastRecentlyUsedCache;
import com.neptunelabs.fsiframework.collections.Pair;
import com.neptunelabs.fsiframework.helpers.FileEventCallback;
import com.neptunelabs.fsiframework.helpers.Inet4AddressUtils;
import com.neptunelabs.fsiframework.helpers.Inet6AddressUtils;
import com.neptunelabs.fsiframework.io.FileEventCursor;
import com.neptunelabs.fsiframework.io.FileOperations;
import com.neptunelabs.fsiframework.logging.FSILogger;
import com.neptunelabs.fsiservletframework.bofh.BofHState;
import com.neptunelabs.fsiservletframework.bofh.HostRange;
import com.neptunelabs.fsiservletframework.bofh.IPv4HostRange;
import com.neptunelabs.fsiservletframework.bofh.IPv6HostRange;
import com.neptunelabs.fsiservletframework.bofh.RemoteAddress;
import com.neptunelabs.fsiservletframework.bofh.RequestDoS;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;

public class BOfH {
    protected final FSILogger logger;
    protected final Path blacklistPath;
    protected final Path whitelistPath;
    private boolean ipSense = false;
    private long ipSenseTime = 30000L;
    private int ipSenseCount = 10000;
    private long ipSenseLastCleanUp = 0L;
    private boolean requestSense = false;
    private long requestSenseTime = 60000L;
    private int requestSenseCount = 100;
    private long requestLastCleanUp = 0L;
    private boolean blacklistReferrer = false;
    private boolean blacklistHosts = false;
    private boolean whitelistHosts = false;
    private boolean blacklistUserAgent = false;
    private final ConcurrentHashMap<String, RequestDoS> antiDoSIPMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, RequestDoS> antiDoSRequestMap = new ConcurrentHashMap();
    private List<HostRange> blacklistHostsList = null;
    private List<HostRange> whitelistHostsList = null;
    private List<Pattern> blacklistReferrersList = null;
    private List<Pattern> blacklistAgentsList = null;
    private long checkedRequests;
    private long passedRequests;
    private long deniedRequests;
    private long blockedRequests;
    private final long initTime;
    private final ReentrantLock ipLock = new ReentrantLock();
    private final ReentrantLock requestLock = new ReentrantLock();
    private final LeastRecentlyUsedCache<String, RemoteAddress> remoteAddressCache = new LeastRecentlyUsedCache(500);
    private final LeastRecentlyUsedCache<String, Boolean> referrerCache = new LeastRecentlyUsedCache(500);
    private final LeastRecentlyUsedCache<String, Boolean> userAgentCache = new LeastRecentlyUsedCache(500);

    public BOfH(FSILogger logger, FileEventCursor fileEventCursor, String blacklistPath, String whitelistPath) {
        this.logger = logger;
        this.blacklistPath = Paths.get(blacklistPath, new String[0]);
        this.whitelistPath = Paths.get(whitelistPath, new String[0]);
        this.initTime = System.currentTimeMillis();
        this.checkedRequests = 0L;
        this.passedRequests = 0L;
        this.deniedRequests = 0L;
        this.blockedRequests = 0L;
        if (fileEventCursor != null) {
            FileEventCallback callback = new FileEventCallback(this, "init", null);
            ArrayList<FileEventCallback> cL = new ArrayList<FileEventCallback>();
            cL.add(callback);
            DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path file) {
                    return Files.isDirectory(file, new LinkOption[0]) || file.getFileName().toString().endsWith(".txt");
                }
            };
            try {
                fileEventCursor.addPathMonitor(this.blacklistPath, filter, false, cL);
                fileEventCursor.addPathMonitor(this.whitelistPath, filter, false, cL);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.init();
    }

    public void init() {
        this.logger.log(1522, new Object[0]);
        this.antiDoSIPMap.clear();
        this.antiDoSRequestMap.clear();
        this.referrerCache.clear();
        this.userAgentCache.clear();
        List<String> blacklistHostsListRaw = this.readRawLists(this.blacklistPath.resolve("hosts.txt"), true);
        this.blacklistHostsList = this.makeHostList(blacklistHostsListRaw);
        List<String> whitelistHostsListRaw = this.readRawLists(this.whitelistPath.resolve("hosts.txt"), true);
        this.whitelistHostsList = this.makeHostList(whitelistHostsListRaw);
        List<String> blacklistReferrerListRaw = this.readRawLists(this.blacklistPath.resolve("referrers.txt"), true);
        this.blacklistReferrersList = this.makePatternList(blacklistReferrerListRaw);
        List<String> blacklistAgentsListRaw = this.readRawLists(this.blacklistPath.resolve("useragents.txt"), true);
        this.blacklistAgentsList = this.makePatternList(blacklistAgentsListRaw);
    }

    public long getInitTime() {
        return this.initTime;
    }

    public void setCheckIPDoS(boolean state, long time, int count) {
        this.ipSense = state;
        this.ipSenseTime = time;
        this.ipSenseCount = count;
    }

    public void setCheckRequestDoS(boolean state, long time, int count) {
        this.requestSense = state;
        this.requestSenseTime = time;
        this.requestSenseCount = count;
    }

    public void setCheckReferrers(boolean state) {
        this.blacklistReferrer = state;
    }

    public boolean getCheckReferrers() {
        return this.blacklistReferrer;
    }

    public int getReferrersBlacklistSize() {
        return this.getListSize(this.blacklistReferrersList);
    }

    public void setCheckWhiteHosts(boolean state) {
        this.whitelistHosts = state;
    }

    public boolean getCheckWhiteHosts() {
        return this.whitelistHosts;
    }

    public int getHostsWhitelistSize() {
        return this.getListSize(this.whitelistHostsList);
    }

    public void setCheckBlackHosts(boolean state) {
        this.blacklistHosts = state;
    }

    public boolean getCheckBlackHosts() {
        return this.blacklistHosts;
    }

    public int getHostsBlacklistSize() {
        return this.getListSize(this.blacklistHostsList);
    }

    public void setCheckUserAgents(boolean state) {
        this.blacklistUserAgent = state;
    }

    public boolean getCheckUserAgents() {
        return this.blacklistUserAgent;
    }

    public int getUserAgentsBlacklistSize() {
        return this.getListSize(this.blacklistAgentsList);
    }

    public boolean hasBOfHCheck() {
        return this.ipSense | this.requestSense | this.blacklistReferrer | this.blacklistHosts | this.whitelistHosts | this.blacklistUserAgent;
    }

    public boolean getIpSense() {
        return this.ipSense;
    }

    public int getBlockedIPCount() {
        int counter = 0;
        Set ips = this.antiDoSIPMap.keySet();
        for (String ip : ips) {
            if (!this.isIPDoS(this.antiDoSIPMap, ip)) continue;
            ++counter;
        }
        return counter;
    }

    public boolean getRequestSense() {
        return this.requestSense;
    }

    public int getBlockedRequestCount() {
        return this.antiDoSRequestMap.size();
    }

    public BofHState check(HttpServletRequest httprequest) {
        BofHState pass = BofHState.Pass;
        String remoteAddressString = httprequest.getRemoteAddr();
        RemoteAddress remoteAddress = this.getCachedRemoteAddress(remoteAddressString);
        boolean whitepass = this.isWhiteListed(remoteAddress);
        if (!whitepass) {
            pass = this.checkIPDosProtection(remoteAddressString);
            if (pass == BofHState.Pass) {
                pass = this.checkRequestDosProtection(httprequest);
            }
            if (pass == BofHState.Pass && this.isHostBlacklisted(remoteAddress)) {
                pass = BofHState.Deny;
            }
            if (pass == BofHState.Pass && this.isReferrerBlacklisted(httprequest)) {
                pass = BofHState.Deny;
            }
            if (pass == BofHState.Pass && this.isUserAgentBlacklisted(httprequest)) {
                pass = BofHState.Deny;
            }
        }
        this.countRequest(pass);
        return pass;
    }

    private boolean isUserAgentBlacklisted(HttpServletRequest httprequest) {
        String agent;
        boolean result = false;
        if (this.blacklistUserAgent && this.blacklistAgentsList != null && (agent = httprequest.getHeader("user-agent")) != null) {
            if (this.userAgentCache.containsKey(agent)) {
                result = (Boolean)this.userAgentCache.get(agent);
            } else {
                for (Pattern check : this.blacklistAgentsList) {
                    Matcher matcheck = check.matcher(agent);
                    if (!matcheck.find()) continue;
                    result = true;
                    break;
                }
                this.userAgentCache.put(agent, result);
            }
        }
        return result;
    }

    private boolean isReferrerBlacklisted(HttpServletRequest httprequest) {
        String referer;
        boolean result = false;
        if (this.blacklistReferrer && this.blacklistReferrersList != null && (referer = httprequest.getHeader("referer")) != null) {
            if (this.referrerCache.containsKey(referer)) {
                result = (Boolean)this.referrerCache.get(referer);
            } else {
                block6: {
                    try {
                        URL url = new URL(referer);
                        String host = url.getHost();
                        if (host == null) break block6;
                        for (Pattern check : this.blacklistReferrersList) {
                            Matcher matcheck = check.matcher(host);
                            if (!matcheck.find()) continue;
                            result = true;
                            break;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                this.referrerCache.put(referer, result);
            }
        }
        return result;
    }

    private boolean isHostBlacklisted(RemoteAddress address) {
        boolean result = false;
        if (this.blacklistHosts && this.blacklistHostsList != null) {
            for (HostRange hr : this.blacklistHostsList) {
                if (!hr.isInRange(address)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private BofHState checkRequestDosProtection(HttpServletRequest httprequest) {
        BofHState pass = BofHState.Pass;
        if (this.requestSense) {
            String request = httprequest.getRequestURI();
            long ret = this.cleanupTimedMapRequest(this.antiDoSRequestMap, this.requestSenseTime, this.requestSenseCount, this.requestLastCleanUp);
            if (ret != -1L) {
                this.requestLastCleanUp = ret;
            }
            if (this.isRequestDoS(this.antiDoSRequestMap, request)) {
                pass = BofHState.DoS;
            }
            if (this.addRequest(request)) {
                this.logger.log(1551, httprequest.getRequestURI());
            }
        }
        return pass;
    }

    private BofHState checkIPDosProtection(String remoteAddressString) {
        BofHState pass = BofHState.Pass;
        if (this.ipSense) {
            long ret = this.cleanupTimedMapIP(this.antiDoSIPMap, this.ipSenseTime, this.ipSenseCount, this.ipSenseLastCleanUp);
            if (ret != -1L) {
                this.ipSenseLastCleanUp = ret;
            }
            if (this.isIPDoS(this.antiDoSIPMap, remoteAddressString)) {
                pass = BofHState.DoS;
            }
            if (this.addIP(remoteAddressString)) {
                this.logger.log(1550, remoteAddressString);
            }
        }
        return pass;
    }

    private boolean isWhiteListed(RemoteAddress address) {
        boolean whitepass = false;
        if (this.whitelistHosts && this.whitelistHostsList != null) {
            for (HostRange hr : this.whitelistHostsList) {
                if (!hr.isInRange(address)) continue;
                whitepass = true;
            }
        }
        return whitepass;
    }

    private void countRequest(BofHState pass) {
        ++this.checkedRequests;
        if (pass == BofHState.Pass) {
            ++this.passedRequests;
        } else if (pass == BofHState.Deny) {
            ++this.deniedRequests;
        } else {
            ++this.blockedRequests;
        }
    }

    public long getCheckedRequests() {
        return this.checkedRequests;
    }

    public long getPassedRequests() {
        return this.passedRequests;
    }

    public long getDeniedRequests() {
        return this.deniedRequests;
    }

    public long getBlockedRequests() {
        return this.blockedRequests;
    }

    public void halt() {
    }

    private boolean addIP(String remoteAddressString) {
        boolean result = false;
        if (!this.ipLock.isLocked()) {
            RequestDoS rdos = this.antiDoSIPMap.get(remoteAddressString);
            if (rdos == null) {
                rdos = new RequestDoS();
                rdos.firstRequestTime = System.currentTimeMillis();
                this.antiDoSIPMap.put(remoteAddressString, rdos);
            }
            rdos.lastRequestTime = System.currentTimeMillis();
            ++rdos.requests;
            if (rdos.requests == (long)this.ipSenseCount) {
                result = true;
            }
        }
        return result;
    }

    private boolean addRequest(String request) {
        boolean result = false;
        if (!this.requestLock.isLocked()) {
            RequestDoS rdos = this.antiDoSRequestMap.get(request);
            if (rdos == null) {
                rdos = new RequestDoS();
                rdos.firstRequestTime = System.currentTimeMillis();
                this.antiDoSRequestMap.put(request, rdos);
            }
            rdos.lastRequestTime = System.currentTimeMillis();
            ++rdos.requests;
            if (rdos.requests == (long)this.requestSenseCount) {
                result = true;
            }
        }
        return result;
    }

    private boolean isIPDoS(Map<String, RequestDoS> table, String remoteAddressString) {
        long age;
        RequestDoS rdos;
        boolean result = false;
        if (!this.ipLock.isLocked() && (rdos = table.get(remoteAddressString)) != null && (age = System.currentTimeMillis() - rdos.lastRequestTime) < this.ipSenseTime && rdos.requests > (long)this.ipSenseCount) {
            result = true;
            rdos.blocked = true;
        }
        return result;
    }

    private boolean isRequestDoS(Map<String, RequestDoS> table, String request) {
        long age;
        RequestDoS rdos;
        boolean result = false;
        if (!this.requestLock.isLocked() && (rdos = table.get(request)) != null && (age = System.currentTimeMillis() - rdos.lastRequestTime) < this.requestSenseTime && rdos.requests > (long)this.requestSenseCount) {
            result = true;
            rdos.blocked = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long cleanupTimedMapRequest(Map<String, RequestDoS> table, long senseTime, long senseCount, long lastCleanUp) {
        long ret = -1L;
        long now = System.currentTimeMillis();
        long maxage = now - lastCleanUp;
        if (maxage > senseTime || table.size() > 200000) {
            try {
                RequestDoS rdos;
                this.requestLock.lock();
                ArrayList<String> keyToDelete = new ArrayList<String>(500);
                for (String key : table.keySet()) {
                    rdos = table.get(key);
                    if (rdos == null) continue;
                    if (!rdos.blocked && now - rdos.firstRequestTime > senseTime) {
                        keyToDelete.add(key);
                        continue;
                    }
                    if (!rdos.blocked || now - rdos.lastRequestTime <= senseTime) continue;
                    keyToDelete.add(key);
                }
                if (keyToDelete.size() > 0) {
                    for (String obj : keyToDelete) {
                        if (obj == null) continue;
                        rdos = table.get(obj);
                        if (rdos != null && rdos.requests > senseCount) {
                            this.logger.log(1552, obj);
                        }
                        table.remove(obj);
                    }
                    keyToDelete.clear();
                    keyToDelete = null;
                }
                ret = now;
            }
            finally {
                this.requestLock.unlock();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long cleanupTimedMapIP(Map<String, RequestDoS> table, long senseTime, long senseCount, long lastCleanUp) {
        long ret = -1L;
        long now = System.currentTimeMillis();
        long maxage = now - lastCleanUp;
        if (maxage > senseTime || table.size() > 200000) {
            try {
                RequestDoS rdos;
                this.ipLock.lock();
                ArrayList<String> keyToDelete = new ArrayList<String>(500);
                for (String key : table.keySet()) {
                    rdos = table.get(key);
                    if (rdos == null) continue;
                    if (!rdos.blocked && now - rdos.firstRequestTime > senseTime) {
                        keyToDelete.add(key);
                        continue;
                    }
                    if (!rdos.blocked || now - rdos.lastRequestTime <= senseTime) continue;
                    keyToDelete.add(key);
                }
                if (keyToDelete.size() > 0) {
                    for (String obj : keyToDelete) {
                        if (obj == null) continue;
                        rdos = table.get(obj);
                        if (rdos != null && rdos.requests > senseCount) {
                            this.logger.log(1552, obj);
                        }
                        table.remove(obj);
                    }
                    keyToDelete.clear();
                    keyToDelete = null;
                }
                ret = now;
            }
            finally {
                this.ipLock.unlock();
            }
        }
        return ret;
    }

    private List<String> readRawLists(Path file, boolean toLower) {
        ArrayList<String> blacklist = new ArrayList<String>();
        if (Files.isReadable(file)) {
            try (BufferedReader br = Files.newBufferedReader(file, FileOperations.charsetUTF8);){
                String line;
                while ((line = br.readLine()) != null) {
                    int comment;
                    String cline = line.trim();
                    if (cline.equals("")) continue;
                    if (toLower) {
                        cline = cline.toLowerCase();
                    }
                    if ((comment = Math.max(cline.indexOf(35), cline.indexOf(59))) > -1) {
                        cline = cline.substring(0, comment);
                    }
                    if ((cline = cline.trim()).length() <= 1) continue;
                    blacklist.add(cline);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return blacklist;
    }

    private List<HostRange> makeHostList(List<String> rawlist) {
        ArrayList<HostRange> hostlist = new ArrayList<HostRange>();
        Pattern pat_host = Pattern.compile("[a-z][\\w\\.]+", 2);
        Pattern pat_IPv4cidr = Pattern.compile("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})/(\\d{1,2})");
        Pattern pat_quickIPv6cidr = Pattern.compile("[a-f0-9:]{3,39}/(\\d{1,2})", 2);
        Pattern pat_ip = Pattern.compile("(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})");
        Pattern pat_ip3 = Pattern.compile("^(\\d{1,3}\\.\\d{1,3}\\.\\d{1,3})$");
        Pattern pat_ip2 = Pattern.compile("^(\\d{1,3}\\.\\d{1,3})$");
        Pattern pat_ip1 = Pattern.compile("^(\\d{1,3})$");
        Pattern pat_v6 = Pattern.compile("[a-f0-9:]{3,39}");
        for (String line : rawlist) {
            InetSocketAddress isa;
            InetAddress iaddr;
            Matcher mat_host;
            Inet6Address address;
            Matcher mat_ipv6;
            Pair<Inet6Address, Inet6Address> range;
            Matcher mat_ipv6_cidr;
            Matcher mat_ip1;
            Matcher mat_ip2;
            long end;
            long start;
            Matcher mat_ip3;
            Matcher mat_ip;
            HostRange hr = null;
            Matcher mat_cidr = pat_IPv4cidr.matcher(line);
            if (mat_cidr.find()) {
                try {
                    long ip = Inet4AddressUtils.stringToLongIP(mat_cidr.group(1));
                    int cidr = Integer.valueOf(mat_cidr.group(2));
                    long cidr_first = (long)Math.pow(2.0, cidr) - 1L << 32 - cidr;
                    long cidr_last = (long)Math.pow(2.0, 32 - cidr) - 1L;
                    long start2 = (ip & cidr_first) + 1L;
                    long end2 = (start2 | cidr_last) - 1L;
                    hr = new IPv4HostRange(start2, end2);
                }
                catch (NumberFormatException ip) {
                    // empty catch block
                }
            }
            if (hr == null && (mat_ip = pat_ip.matcher(line)).find()) {
                long address2 = Inet4AddressUtils.stringToLongIP(mat_ip.group(1));
                hr = new IPv4HostRange(address2, address2);
            }
            if (hr == null && (mat_ip3 = pat_ip3.matcher(line)).find()) {
                String ip1 = mat_ip3.group(1) + ".0";
                String ip2 = mat_ip3.group(1) + ".255";
                start = Inet4AddressUtils.stringToLongIP(ip1);
                end = Inet4AddressUtils.stringToLongIP(ip2);
                hr = new IPv4HostRange(start, end);
            }
            if (hr == null && (mat_ip2 = pat_ip2.matcher(line)).find()) {
                String ip1 = mat_ip2.group(1) + ".0.0";
                String ip2 = mat_ip2.group(1) + ".255.255";
                start = Inet4AddressUtils.stringToLongIP(ip1);
                end = Inet4AddressUtils.stringToLongIP(ip2);
                hr = new IPv4HostRange(start, end);
            }
            if (hr == null && (mat_ip1 = pat_ip1.matcher(line)).find()) {
                String ip1 = mat_ip1.group(1) + ".0.0.0";
                String ip2 = mat_ip1.group(1) + ".255.255.255";
                start = Inet4AddressUtils.stringToLongIP(ip1);
                end = Inet4AddressUtils.stringToLongIP(ip2);
                hr = new IPv4HostRange(start, end);
            }
            if (hr == null && (mat_ipv6_cidr = pat_quickIPv6cidr.matcher(line)).find() && (range = Inet6AddressUtils.parseCIDR(line)) != null) {
                hr = new IPv6HostRange(range.getItem1(), range.getItem2());
            }
            if (hr == null && (mat_ipv6 = pat_v6.matcher(line)).find() && (address = Inet6AddressUtils.parseInet6AddressString(line)) != null) {
                hr = new IPv6HostRange(address, address);
            }
            if (hr == null && (mat_host = pat_host.matcher(line)).find() && (iaddr = (isa = new InetSocketAddress(line, 80)).getAddress()) != null) {
                end = start = Inet4AddressUtils.stringToLongIP(iaddr.getHostAddress());
                hr = new IPv4HostRange(start, end);
            }
            if (hr == null) continue;
            hostlist.add(hr);
        }
        return hostlist;
    }

    private List<Pattern> makePatternList(List<String> rawlist) {
        ArrayList<Pattern> patternlist = new ArrayList<Pattern>();
        for (String line : rawlist) {
            String newline = line.replaceAll("\\.", "\\\\.");
            newline = newline.replaceAll("\\*", ".*");
            try {
                Pattern pat = Pattern.compile(newline, 2);
                if (pat == null) continue;
                patternlist.add(pat);
            }
            catch (PatternSyntaxException patternSyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return patternlist;
    }

    private int getListSize(List<?> list) {
        int size = 0;
        if (list != null) {
            size = list.size();
        }
        return size;
    }

    private RemoteAddress getCachedRemoteAddress(String remoteAddressString) {
        RemoteAddress result;
        if (this.remoteAddressCache.containsKey(remoteAddressString)) {
            result = (RemoteAddress)this.remoteAddressCache.get(remoteAddressString);
        } else {
            result = new RemoteAddress(remoteAddressString);
            this.remoteAddressCache.put(remoteAddressString, result);
        }
        return result;
    }
}

