/*
 * Decompiled with CFR 0.152.
 */
package com.neptunelabs.fsiservletframework.bofh;

import com.neptunelabs.fsiframework.helpers.Inet4AddressUtils;
import com.neptunelabs.fsiservletframework.bofh.HostRange;
import com.neptunelabs.fsiservletframework.bofh.RemoteAddress;

final class IPv4HostRange
extends HostRange {
    long start;
    long end;

    public IPv4HostRange(long start, long end) {
        this.start = start;
        this.end = end;
    }

    @Override
    boolean isInRange(RemoteAddress address) {
        return address.isIPv4Address() && address.ipv4long >= this.start && address.ipv4long <= this.end;
    }

    public String toString() {
        return "IPv4 host range from " + Inet4AddressUtils.longToStringIP(this.start) + " - " + Inet4AddressUtils.longToStringIP(this.end);
    }
}

